/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transform.search;

import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.script.Script;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.transform.ExecutableTransform;
import org.elasticsearch.xpack.core.watcher.transform.Transform;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateRequest;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateService;
import org.elasticsearch.xpack.watcher.transform.search.SearchTransform;

public class ExecutableSearchTransform
extends ExecutableTransform<SearchTransform, SearchTransform.Result> {
    static final SearchType DEFAULT_SEARCH_TYPE = SearchType.QUERY_THEN_FETCH;
    private final Client client;
    private final WatcherSearchTemplateService searchTemplateService;
    private final TimeValue timeout;

    public ExecutableSearchTransform(SearchTransform transform, Logger logger, Client client, WatcherSearchTemplateService searchTemplateService, TimeValue defaultTimeout) {
        super((Transform)transform, logger);
        this.client = client;
        this.searchTemplateService = searchTemplateService;
        this.timeout = transform.getTimeout() != null ? transform.getTimeout() : defaultTimeout;
    }

    public SearchTransform.Result execute(WatchExecutionContext ctx, Payload payload) {
        WatcherSearchTemplateRequest request = null;
        try {
            Script template = ((SearchTransform)this.transform).getRequest().getOrCreateTemplate();
            String renderedTemplate = this.searchTemplateService.renderTemplate(template, ctx, payload);
            request = new WatcherSearchTemplateRequest(((SearchTransform)this.transform).getRequest(), (BytesReference)new BytesArray(renderedTemplate));
            SearchRequest searchRequest = this.searchTemplateService.toSearchRequest(request);
            SearchResponse resp = (SearchResponse)ClientHelper.executeWithHeaders((Map)ctx.watch().status().getHeaders(), (String)"watcher", (Client)this.client, () -> (SearchResponse)this.client.search(searchRequest).actionGet(this.timeout));
            Object params = request.isRestTotalHitsAsint() ? new ToXContent.MapParams(Collections.singletonMap("rest_total_hits_as_int", "true")) : EMPTY_PARAMS;
            return new SearchTransform.Result(request, (Payload)new Payload.XContent((ToXContentObject)resp, params));
        }
        catch (Exception e) {
            this.logger.error((Message)new ParameterizedMessage("failed to execute [{}] transform for [{}]", (Object)"search", (Object)ctx.id()), (Throwable)e);
            return new SearchTransform.Result(request, e);
        }
    }
}

