/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;
import org.elasticsearch.xpack.watcher.Watcher;

public class WatcherIndexTemplateRegistry
extends IndexTemplateRegistry {
    public static final String WATCHER_TEMPLATE_VERSION_VARIABLE = "xpack.watcher.template.version";
    private final boolean ilmManagementEnabled;
    private static final Map<String, ComposableIndexTemplate> TEMPLATES_WATCH_HISTORY = WatcherIndexTemplateRegistry.parseComposableTemplates((IndexTemplateConfig[])new IndexTemplateConfig[]{new IndexTemplateConfig(".watch-history-16", "/watch-history.json", 16, "xpack.watcher.template.version")});
    private static final Map<String, ComposableIndexTemplate> TEMPLATES_WATCH_HISTORY_NO_ILM = WatcherIndexTemplateRegistry.parseComposableTemplates((IndexTemplateConfig[])new IndexTemplateConfig[]{new IndexTemplateConfig(".watch-history-no-ilm-16", "/watch-history-no-ilm.json", 16, "xpack.watcher.template.version")});
    private static final List<LifecyclePolicy> LIFECYCLE_POLICIES = List.of(new LifecyclePolicyConfig("watch-history-ilm-policy-16", "/watch-history-ilm-policy.json").load(LifecyclePolicyConfig.DEFAULT_X_CONTENT_REGISTRY));

    public WatcherIndexTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.ilmManagementEnabled = (Boolean)Watcher.USE_ILM_INDEX_MANAGEMENT.get(nodeSettings);
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        return this.ilmManagementEnabled ? TEMPLATES_WATCH_HISTORY : TEMPLATES_WATCH_HISTORY_NO_ILM;
    }

    protected List<LifecyclePolicy> getPolicyConfigs() {
        return (Boolean)Watcher.USE_ILM_INDEX_MANAGEMENT.get(this.settings) == false ? Collections.emptyList() : LIFECYCLE_POLICIES;
    }

    protected String getOrigin() {
        return "watcher";
    }

    public static boolean validate(ClusterState state) {
        return state.getMetadata().templatesV2().keySet().stream().filter(s -> s.startsWith(".watch-history-")).map(s -> Integer.valueOf(s.substring(s.lastIndexOf(45) + 1))).anyMatch(version -> version >= 12);
    }
}

