/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.search;

import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.input.ExecutableInput;
import org.elasticsearch.xpack.core.watcher.input.Input;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.input.search.SearchInput;
import org.elasticsearch.xpack.watcher.support.XContentFilterKeysUtils;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateRequest;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateService;

public class ExecutableSearchInput
extends ExecutableInput<SearchInput, SearchInput.Result> {
    public static final SearchType DEFAULT_SEARCH_TYPE = SearchType.QUERY_THEN_FETCH;
    private static final Logger logger = LogManager.getLogger(ExecutableSearchInput.class);
    private static final ToXContent.Params EMPTY_PARAMS = new ToXContent.MapParams(Collections.emptyMap());
    private final Client client;
    private final WatcherSearchTemplateService searchTemplateService;
    private final TimeValue timeout;

    public ExecutableSearchInput(SearchInput input, Client client, WatcherSearchTemplateService searchTemplateService, TimeValue defaultTimeout) {
        super((Input)input);
        this.client = client;
        this.searchTemplateService = searchTemplateService;
        this.timeout = input.getTimeout() != null ? input.getTimeout() : defaultTimeout;
    }

    public SearchInput.Result execute(WatchExecutionContext ctx, Payload payload) {
        WatcherSearchTemplateRequest request = null;
        try {
            Script template = ((SearchInput)this.input).getRequest().getOrCreateTemplate();
            String renderedTemplate = this.searchTemplateService.renderTemplate(template, ctx, payload);
            request = new WatcherSearchTemplateRequest(((SearchInput)this.input).getRequest(), (BytesReference)new BytesArray(renderedTemplate));
            return this.doExecute(ctx, request);
        }
        catch (Exception e) {
            logger.error((Message)new ParameterizedMessage("failed to execute [{}] input for watch [{}]", (Object)"search", (Object)ctx.watch().id()), (Throwable)e);
            return new SearchInput.Result(request, e);
        }
    }

    SearchInput.Result doExecute(WatchExecutionContext ctx, WatcherSearchTemplateRequest request) throws Exception {
        Payload.XContent payload;
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] running query for [{}] [{}]", (Object)ctx.id(), (Object)ctx.watch().id(), (Object)request.getSearchSource().utf8ToString());
        }
        SearchRequest searchRequest = this.searchTemplateService.toSearchRequest(request);
        ClientHelper.assertNoAuthorizationHeader((Map)ctx.watch().status().getHeaders());
        SearchResponse response = (SearchResponse)ClientHelper.executeWithHeaders((Map)ctx.watch().status().getHeaders(), (String)"watcher", (Client)this.client, () -> (SearchResponse)this.client.search(searchRequest).actionGet(this.timeout));
        if (logger.isDebugEnabled()) {
            logger.debug("[{}] found [{}] hits", (Object)ctx.id(), (Object)response.getHits().getTotalHits().value);
            for (SearchHit hit : response.getHits()) {
                logger.debug("[{}] hit [{}]", (Object)ctx.id(), (Object)hit.getSourceAsMap());
            }
        }
        Object params = request.isRestTotalHitsAsint() ? new ToXContent.MapParams(Collections.singletonMap("rest_total_hits_as_int", "true")) : EMPTY_PARAMS;
        if (((SearchInput)this.input).getExtractKeys() != null) {
            BytesReference bytes = XContentHelper.toXContent((ToXContent)response, (XContentType)XContentType.SMILE, (ToXContent.Params)params, (boolean)false);
            try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)bytes, (XContentType)XContentType.SMILE);){
                Map<String, Object> filteredKeys = XContentFilterKeysUtils.filterMapOrdered(((SearchInput)this.input).getExtractKeys(), parser);
                payload = new Payload.Simple(filteredKeys);
            }
        } else {
            payload = new Payload.XContent((ToXContentObject)response, params);
        }
        return new SearchInput.Result(request, (Payload)payload);
    }
}

