/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.rate;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.aggregations.support.HistogramValuesSource;
import org.elasticsearch.xpack.analytics.rate.AbstractRateAggregator;
import org.elasticsearch.xpack.analytics.rate.RateMode;

public class HistogramRateAggregator
extends AbstractRateAggregator {
    public HistogramRateAggregator(String name, ValuesSourceConfig valuesSourceConfig, Rounding.DateTimeUnit rateUnit, RateMode rateMode, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, valuesSourceConfig, rateUnit, rateMode, context, parent, metadata);
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        final HistogramValues values = ((HistogramValuesSource.Histogram)this.valuesSource).getHistogramValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                HistogramRateAggregator.this.sums = HistogramRateAggregator.this.bigArrays().grow(HistogramRateAggregator.this.sums, bucket + 1L);
                HistogramRateAggregator.this.compensations = HistogramRateAggregator.this.bigArrays().grow(HistogramRateAggregator.this.compensations, bucket + 1L);
                if (values.advanceExact(doc)) {
                    HistogramValue sketch = values.histogram();
                    while (sketch.next()) {
                        double sum = HistogramRateAggregator.this.sums.get(bucket);
                        double compensation = HistogramRateAggregator.this.compensations.get(bucket);
                        kahanSummation.reset(sum, compensation);
                        double value = switch (HistogramRateAggregator.this.rateMode) {
                            default -> throw new IncompatibleClassChangeError();
                            case RateMode.SUM -> sketch.value();
                            case RateMode.VALUE_COUNT -> sketch.count();
                        };
                        kahanSummation.add(value);
                        HistogramRateAggregator.this.compensations.set(bucket, kahanSummation.delta());
                        HistogramRateAggregator.this.sums.set(bucket, kahanSummation.value());
                    }
                }
            }
        };
    }
}

