/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.multiterms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.KeyComparable;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractInternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalMultiTerms
extends AbstractInternalTerms<InternalMultiTerms, Bucket> {
    public static final TermsComparator TERMS_COMPARATOR = new TermsComparator();
    protected final BucketOrder reduceOrder;
    protected final BucketOrder order;
    protected final int requiredSize;
    protected final long minDocCount;
    protected final List<DocValueFormat> formats;
    protected final List<KeyConverter> keyConverters;
    protected final int shardSize;
    protected final boolean showTermDocCountError;
    protected final long otherDocCount;
    protected final List<Bucket> buckets;
    protected long docCountError;

    public InternalMultiTerms(String name, BucketOrder reduceOrder, BucketOrder order, int requiredSize, long minDocCount, int shardSize, boolean showTermDocCountError, long otherDocCount, List<Bucket> buckets, long docCountError, List<DocValueFormat> formats, List<KeyConverter> keyConverters, Map<String, Object> metadata) {
        super(name, metadata);
        this.reduceOrder = reduceOrder;
        this.order = order;
        this.requiredSize = requiredSize;
        this.minDocCount = minDocCount;
        this.shardSize = shardSize;
        this.showTermDocCountError = showTermDocCountError;
        this.otherDocCount = otherDocCount;
        this.buckets = buckets;
        this.docCountError = docCountError;
        this.formats = formats;
        this.keyConverters = keyConverters;
    }

    public InternalMultiTerms(StreamInput in) throws IOException {
        super(in);
        this.reduceOrder = InternalOrder.Streams.readOrder((StreamInput)in);
        this.order = InternalOrder.Streams.readOrder((StreamInput)in);
        this.requiredSize = InternalMultiTerms.readSize((StreamInput)in);
        this.minDocCount = in.readVLong();
        this.docCountError = in.readZLong();
        this.shardSize = InternalMultiTerms.readSize((StreamInput)in);
        this.showTermDocCountError = in.readBoolean();
        this.otherDocCount = in.readVLong();
        this.formats = in.readList(in1 -> (DocValueFormat)in1.readNamedWriteable(DocValueFormat.class));
        this.keyConverters = in.readList(in1 -> (KeyConverter)in1.readEnum(KeyConverter.class));
        this.buckets = in.readList(stream -> new Bucket(stream, this.formats, this.keyConverters, this.showTermDocCountError));
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        this.reduceOrder.writeTo(out);
        this.order.writeTo(out);
        InternalMultiTerms.writeSize((int)this.requiredSize, (StreamOutput)out);
        out.writeVLong(this.minDocCount);
        out.writeZLong(this.docCountError);
        InternalMultiTerms.writeSize((int)this.shardSize, (StreamOutput)out);
        out.writeBoolean(this.showTermDocCountError);
        out.writeVLong(this.otherDocCount);
        out.writeCollection(this.formats, StreamOutput::writeNamedWriteable);
        out.writeCollection(this.keyConverters, StreamOutput::writeEnum);
        out.writeList(this.buckets);
    }

    protected InternalMultiTerms create(String name, List<Bucket> buckets, BucketOrder reduceOrder, long docCountError, long otherDocCount) {
        return new InternalMultiTerms(name, reduceOrder, this.order, this.requiredSize, this.minDocCount, this.shardSize, this.showTermDocCountError, otherDocCount, buckets, docCountError, this.formats, this.keyConverters, this.getMetadata());
    }

    protected int getShardSize() {
        return this.shardSize;
    }

    protected BucketOrder getReduceOrder() {
        return this.reduceOrder;
    }

    protected BucketOrder getOrder() {
        return this.order;
    }

    protected long getSumOfOtherDocCounts() {
        return this.otherDocCount;
    }

    protected Long getDocCountError() {
        return this.docCountError;
    }

    protected void setDocCountError(long docCountError) {
        this.docCountError = docCountError;
    }

    protected long getMinDocCount() {
        return this.minDocCount;
    }

    protected int getRequiredSize() {
        return this.requiredSize;
    }

    protected Bucket createBucket(long docCount, InternalAggregations aggs, long docCountError, Bucket prototype) {
        return new Bucket(prototype.terms, docCount, aggs, prototype.showDocCountError, docCountError, this.formats, this.keyConverters);
    }

    public InternalMultiTerms create(List<Bucket> buckets) {
        return new InternalMultiTerms(this.name, this.reduceOrder, this.order, this.requiredSize, this.minDocCount, this.shardSize, this.showTermDocCountError, this.otherDocCount, buckets, this.docCountError, this.formats, this.keyConverters, this.getMetadata());
    }

    private boolean[] needsPromotionToDouble(List<InternalAggregation> aggregations) {
        if (aggregations.size() < 2) {
            return null;
        }
        boolean[] promotions = null;
        for (int i = 0; i < this.keyConverters.size(); ++i) {
            boolean hasLong = false;
            boolean hasUnsignedLong = false;
            boolean hasDouble = false;
            boolean hasNonNumber = false;
            block6: for (InternalAggregation aggregation : aggregations) {
                InternalMultiTerms agg = (InternalMultiTerms)aggregation;
                KeyConverter keyConverter = agg.keyConverters.get(i);
                switch (keyConverter) {
                    case DOUBLE: {
                        hasDouble = true;
                        continue block6;
                    }
                    case LONG: {
                        hasLong = true;
                        continue block6;
                    }
                    case UNSIGNED_LONG: {
                        hasUnsignedLong = true;
                        continue block6;
                    }
                }
                hasNonNumber = true;
            }
            if (hasNonNumber && (hasDouble || hasUnsignedLong || hasLong)) {
                throw new AggregationExecutionException("Merging/Reducing the multi_term aggregations failed when computing the aggregation " + this.name + " because the field in the position " + (i + 1) + " in the aggregation has two different types in two  different indices");
            }
            if ((hasDouble ? 1 : 0) + (hasUnsignedLong ? 1 : 0) + (hasLong ? 1 : 0) <= 1) continue;
            if (promotions == null) {
                promotions = new boolean[this.keyConverters.size()];
            }
            promotions[i] = true;
        }
        return promotions;
    }

    private InternalAggregation promoteToDouble(InternalAggregation aggregation, boolean[] needsPromotion) {
        InternalMultiTerms multiTerms = (InternalMultiTerms)aggregation;
        List<Bucket> multiTermsBuckets = multiTerms.getBuckets();
        ArrayList newKeys = new ArrayList();
        for (Bucket bucket : multiTermsBuckets) {
            newKeys.add(new ArrayList(bucket.terms.size()));
        }
        ArrayList<KeyConverter> newKeyConverters = new ArrayList<KeyConverter>(multiTerms.keyConverters.size());
        for (int i = 0; i < needsPromotion.length; ++i) {
            int j;
            KeyConverter converter = multiTerms.keyConverters.get(i);
            DocValueFormat format = this.formats.get(i);
            if (needsPromotion[i]) {
                newKeyConverters.add(KeyConverter.DOUBLE);
                for (j = 0; j < multiTermsBuckets.size(); ++j) {
                    ((List)newKeys.get(j)).add(converter.toDouble(format, multiTermsBuckets.get((int)j).terms.get(i)));
                }
                continue;
            }
            newKeyConverters.add(converter);
            for (j = 0; j < multiTermsBuckets.size(); ++j) {
                ((List)newKeys.get(j)).add(multiTermsBuckets.get((int)j).terms.get(i));
            }
        }
        ArrayList<Bucket> newBuckets = new ArrayList<Bucket>(multiTermsBuckets.size());
        for (int i = 0; i < multiTermsBuckets.size(); ++i) {
            Bucket oldBucket = multiTermsBuckets.get(i);
            newBuckets.add(new Bucket((List)newKeys.get(i), oldBucket.docCount, oldBucket.aggregations, oldBucket.showDocCountError, oldBucket.docCountError, this.formats, newKeyConverters));
        }
        newBuckets.sort(this.reduceOrder.comparator());
        return new InternalMultiTerms(multiTerms.name, multiTerms.reduceOrder, multiTerms.order, multiTerms.requiredSize, multiTerms.minDocCount, multiTerms.shardSize, multiTerms.showTermDocCountError, multiTerms.otherDocCount, newBuckets, multiTerms.docCountError, multiTerms.formats, newKeyConverters, multiTerms.metadata);
    }

    public InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext, boolean[] needsPromotionToDouble) {
        if (needsPromotionToDouble != null) {
            ArrayList<InternalAggregation> newAggs = new ArrayList<InternalAggregation>(aggregations.size());
            for (InternalAggregation agg : aggregations) {
                newAggs.add(this.promoteToDouble(agg, needsPromotionToDouble));
            }
            return ((InternalMultiTerms)((Object)newAggs.get(0))).reduce(newAggs, reduceContext, null);
        }
        return super.reduce(aggregations, reduceContext);
    }

    public InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        return this.reduce(aggregations, reduceContext, this.needsPromotionToDouble(aggregations));
    }

    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.terms, prototype.docCount, aggregations, this.showTermDocCountError, this.docCountError, this.formats, this.keyConverters);
    }

    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return InternalMultiTerms.doXContentCommon((XContentBuilder)builder, (ToXContent.Params)params, (Long)this.docCountError, (long)this.otherDocCount, this.buckets);
    }

    public String getWriteableName() {
        return "multi_terms";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InternalMultiTerms that = (InternalMultiTerms)((Object)o);
        return this.requiredSize == that.requiredSize && this.minDocCount == that.minDocCount && this.shardSize == that.shardSize && this.showTermDocCountError == that.showTermDocCountError && this.otherDocCount == that.otherDocCount && this.docCountError == that.docCountError && Objects.equals(this.reduceOrder, that.reduceOrder) && Objects.equals(this.order, that.order) && Objects.equals(this.formats, that.formats) && Objects.equals(this.keyConverters, that.keyConverters) && Objects.equals(this.buckets, that.buckets);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.reduceOrder, this.order, this.requiredSize, this.minDocCount, this.formats, this.keyConverters, this.shardSize, this.showTermDocCountError, this.otherDocCount, this.buckets, this.docCountError);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static class Bucket
    extends AbstractInternalTerms.AbstractTermsBucket
    implements KeyComparable<Bucket> {
        long bucketOrd;
        protected long docCount;
        protected InternalAggregations aggregations;
        protected final boolean showDocCountError;
        protected long docCountError;
        protected final List<DocValueFormat> formats;
        protected List<Object> terms;
        protected List<KeyConverter> keyConverters;

        public Bucket(List<Object> terms, long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError, List<DocValueFormat> formats, List<KeyConverter> keyConverters) {
            this.terms = terms;
            this.docCount = docCount;
            this.aggregations = aggregations;
            this.showDocCountError = showDocCountError;
            this.docCountError = docCountError;
            this.formats = formats;
            this.keyConverters = keyConverters;
        }

        protected Bucket(StreamInput in, List<DocValueFormat> formats, List<KeyConverter> keyConverters, boolean showDocCountError) throws IOException {
            this.terms = in.readList(StreamInput::readGenericValue);
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readFrom((StreamInput)in);
            this.showDocCountError = showDocCountError;
            this.docCountError = -1L;
            if (showDocCountError) {
                this.docCountError = in.readLong();
            }
            this.formats = formats;
            this.keyConverters = keyConverters;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.terms, StreamOutput::writeGenericValue);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
            if (this.showDocCountError) {
                out.writeLong(this.docCountError);
            }
        }

        public List<Object> getKey() {
            ArrayList<Object> keys = new ArrayList<Object>(this.terms.size());
            for (int i = 0; i < this.terms.size(); ++i) {
                keys.add(this.keyConverters.get(i).convert(this.formats.get(i), this.terms.get(i)));
            }
            return keys;
        }

        public String getKeyAsString() {
            StringBuilder keys = new StringBuilder();
            for (int i = 0; i < this.terms.size(); ++i) {
                if (i != 0) {
                    keys.append('|');
                }
                keys.append(this.keyConverters.get(i).convert(this.formats.get(i), this.terms.get(i)).toString());
            }
            return keys.toString();
        }

        public long getDocCount() {
            return this.docCount;
        }

        public Aggregations getAggregations() {
            return this.aggregations;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), (Iterable)this.getKey());
            builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), this.getKeyAsString());
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            if (this.getShowDocCountError()) {
                builder.field(InternalTerms.DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME.getPreferredName(), this.getDocCountError());
            }
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        public long getDocCountError() {
            if (!this.showDocCountError) {
                throw new IllegalStateException("show_terms_doc_count_error is false");
            }
            return this.docCountError;
        }

        protected void setDocCountError(long docCountError) {
            this.docCountError = docCountError;
        }

        protected void updateDocCountError(long docCountErrorDiff) {
            this.docCountError += docCountErrorDiff;
        }

        protected boolean getShowDocCountError() {
            return this.showDocCountError;
        }

        public int compareKey(Bucket other) {
            return TERMS_COMPARATOR.compare(this.terms, other.terms);
        }

        public boolean equals(Object obj) {
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Bucket other = (Bucket)((Object)obj);
            if (this.showDocCountError && this.docCountError != other.docCountError) {
                return false;
            }
            return this.docCount == other.docCount && this.aggregations.equals((Object)other.aggregations) && this.showDocCountError == other.showDocCountError && this.terms.equals(other.terms) && this.keyConverters.equals(other.keyConverters);
        }

        public int hashCode() {
            return Objects.hash(this.docCount, this.aggregations, this.showDocCountError, this.showDocCountError ? this.docCountError : -1L, this.terms, this.keyConverters);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum KeyConverter {
        UNSIGNED_LONG{

            @Override
            public Object convert(DocValueFormat format, Object obj) {
                return format.format(((Long)obj).longValue()).toString();
            }

            @Override
            public double toDouble(DocValueFormat format, Object obj) {
                return ((Number)format.format(((Long)obj).longValue())).doubleValue();
            }
        }
        ,
        LONG{

            @Override
            public Object convert(DocValueFormat format, Object obj) {
                return format.format(((Long)obj).longValue());
            }

            @Override
            public double toDouble(DocValueFormat format, Object obj) {
                return ((Long)obj).doubleValue();
            }
        }
        ,
        DOUBLE{

            @Override
            public Object convert(DocValueFormat format, Object obj) {
                return format.format(((Double)obj).doubleValue());
            }

            @Override
            public double toDouble(DocValueFormat format, Object obj) {
                return (Double)obj;
            }
        }
        ,
        STRING{

            @Override
            public Object convert(DocValueFormat format, Object obj) {
                return format.format((BytesRef)obj);
            }
        }
        ,
        IP{

            @Override
            public Object convert(DocValueFormat format, Object obj) {
                return format.format((BytesRef)obj);
            }
        };


        public Object convert(DocValueFormat format, Object obj) {
            throw new UnsupportedOperationException();
        }

        public double toDouble(DocValueFormat format, Object obj) {
            throw new UnsupportedOperationException();
        }
    }

    static class TermsComparator
    implements Comparator<List<Object>> {
        TermsComparator() {
        }

        @Override
        public int compare(List<Object> thisTerms, List<Object> otherTerms) {
            if (thisTerms.size() != otherTerms.size()) {
                throw new AggregationExecutionException("Merging/Reducing the multi_term aggregations failed due to different term list sizes");
            }
            for (int i = 0; i < thisTerms.size(); ++i) {
                int res;
                try {
                    res = ((Comparable)thisTerms.get(i)).compareTo(otherTerms.get(i));
                }
                catch (ClassCastException ex) {
                    throw new AggregationExecutionException("Merging/Reducing the multi_term aggregations failed when computing the aggregation because one of the field you gave in the aggregation query existed as two different types in two different indices");
                }
                if (res == 0) continue;
                return res;
            }
            return 0;
        }
    }
}

