/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.movingPercentiles;

import com.tdunning.math.stats.TDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.HdrHistogram.DoubleHistogram;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramFactory;
import org.elasticsearch.search.aggregations.metrics.InternalHDRPercentiles;
import org.elasticsearch.search.aggregations.metrics.InternalTDigestPercentiles;
import org.elasticsearch.search.aggregations.metrics.PercentilesMethod;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationPath;

public class MovingPercentilesPipelineAggregator
extends PipelineAggregator {
    private final int window;
    private final int shift;

    MovingPercentilesPipelineAggregator(String name, String[] bucketsPaths, int window, int shift, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.window = window;
        this.shift = shift;
    }

    public InternalAggregation reduce(InternalAggregation aggregation, AggregationReduceContext reduceContext) {
        InternalMultiBucketAggregation histo = (InternalMultiBucketAggregation)aggregation;
        List buckets = histo.getBuckets();
        HistogramFactory factory = (HistogramFactory)histo;
        ArrayList<MultiBucketsAggregation.Bucket> newBuckets = new ArrayList<MultiBucketsAggregation.Bucket>(buckets.size());
        if (buckets.size() == 0) {
            return factory.createAggregation(newBuckets);
        }
        PercentileConfig config = this.resolvePercentileConfig((MultiBucketsAggregation)histo, (InternalMultiBucketAggregation.InternalBucket)buckets.get(0), this.bucketsPaths()[0]);
        switch (config.method) {
            case TDIGEST: {
                this.reduceTDigest(buckets, (MultiBucketsAggregation)histo, newBuckets, factory, config);
                break;
            }
            case HDR: {
                this.reduceHDR(buckets, (MultiBucketsAggregation)histo, newBuckets, factory, config);
                break;
            }
            default: {
                throw new AggregationExecutionException(AbstractPipelineAggregationBuilder.BUCKETS_PATH_FIELD.getPreferredName() + " references an unknown percentile aggregation method: [" + config.method + "]");
            }
        }
        return factory.createAggregation(newBuckets);
    }

    private void reduceTDigest(List<? extends InternalMultiBucketAggregation.InternalBucket> buckets, MultiBucketsAggregation histo, List<MultiBucketsAggregation.Bucket> newBuckets, HistogramFactory factory, PercentileConfig config) {
        List values = buckets.stream().map(b -> this.resolveTDigestBucketValue(histo, (InternalMultiBucketAggregation.InternalBucket)b, this.bucketsPaths()[0])).filter(v -> v != null).collect(Collectors.toList());
        int index = 0;
        Iterator<? extends InternalMultiBucketAggregation.InternalBucket> iterator = buckets.iterator();
        while (iterator.hasNext()) {
            InternalMultiBucketAggregation.InternalBucket bucket;
            InternalMultiBucketAggregation.InternalBucket newBucket = bucket = iterator.next();
            TDigestState state = null;
            int fromIndex = this.clamp(index - this.window + this.shift, values.size());
            int toIndex = this.clamp(index + this.shift, values.size());
            for (int i = fromIndex; i < toIndex; ++i) {
                TDigestState bucketState = (TDigestState)values.get(i);
                if (bucketState == null) continue;
                if (state == null) {
                    state = new TDigestState(bucketState.compression());
                }
                state.add((TDigest)bucketState);
            }
            if (state != null) {
                List aggs = bucket.getAggregations().asList().stream().map(p -> (InternalAggregation)p).collect(Collectors.toList());
                aggs.add(new InternalTDigestPercentiles(this.name(), config.keys, state, config.keyed, config.formatter, this.metadata()));
                newBucket = factory.createBucket(factory.getKey((MultiBucketsAggregation.Bucket)bucket), bucket.getDocCount(), InternalAggregations.from(aggs));
            }
            newBuckets.add((MultiBucketsAggregation.Bucket)newBucket);
            ++index;
        }
    }

    private void reduceHDR(List<? extends InternalMultiBucketAggregation.InternalBucket> buckets, MultiBucketsAggregation histo, List<MultiBucketsAggregation.Bucket> newBuckets, HistogramFactory factory, PercentileConfig config) {
        List values = buckets.stream().map(b -> this.resolveHDRBucketValue(histo, (InternalMultiBucketAggregation.InternalBucket)b, this.bucketsPaths()[0])).filter(v -> v != null).collect(Collectors.toList());
        int index = 0;
        for (InternalMultiBucketAggregation.InternalBucket internalBucket : buckets) {
            DoubleHistogram state = null;
            InternalMultiBucketAggregation.InternalBucket newBucket = internalBucket;
            int fromIndex = this.clamp(index - this.window + this.shift, values.size());
            int toIndex = this.clamp(index + this.shift, values.size());
            for (int i = fromIndex; i < toIndex; ++i) {
                DoubleHistogram bucketState = (DoubleHistogram)values.get(i);
                if (bucketState == null) continue;
                if (state == null) {
                    state = new DoubleHistogram(bucketState.getNumberOfSignificantValueDigits());
                }
                state.add(bucketState);
            }
            if (state != null) {
                List aggs = internalBucket.getAggregations().asList().stream().map(p -> (InternalAggregation)p).collect(Collectors.toList());
                aggs.add(new InternalHDRPercentiles(this.name(), config.keys, state, config.keyed, config.formatter, this.metadata()));
                newBucket = factory.createBucket(factory.getKey((MultiBucketsAggregation.Bucket)internalBucket), internalBucket.getDocCount(), InternalAggregations.from(aggs));
            }
            newBuckets.add((MultiBucketsAggregation.Bucket)newBucket);
            ++index;
        }
    }

    private PercentileConfig resolvePercentileConfig(MultiBucketsAggregation agg, InternalMultiBucketAggregation.InternalBucket bucket, String aggPath) {
        List aggPathsList = AggregationPath.parse((String)aggPath).getPathElementsAsStringList();
        Object propertyValue = bucket.getProperty(agg.getName(), aggPathsList);
        if (propertyValue == null) {
            throw this.buildResolveError(agg, aggPathsList, propertyValue, "percentiles");
        }
        if (propertyValue instanceof InternalTDigestPercentiles) {
            InternalTDigestPercentiles internalTDigestPercentiles = (InternalTDigestPercentiles)propertyValue;
            return new PercentileConfig(PercentilesMethod.TDIGEST, internalTDigestPercentiles.getKeys(), internalTDigestPercentiles.keyed(), internalTDigestPercentiles.formatter());
        }
        if (propertyValue instanceof InternalHDRPercentiles) {
            InternalHDRPercentiles internalHDRPercentiles = (InternalHDRPercentiles)propertyValue;
            return new PercentileConfig(PercentilesMethod.HDR, internalHDRPercentiles.getKeys(), internalHDRPercentiles.keyed(), internalHDRPercentiles.formatter());
        }
        throw this.buildResolveError(agg, aggPathsList, propertyValue, "percentiles");
    }

    private TDigestState resolveTDigestBucketValue(MultiBucketsAggregation agg, InternalMultiBucketAggregation.InternalBucket bucket, String aggPath) {
        List aggPathsList = AggregationPath.parse((String)aggPath).getPathElementsAsStringList();
        Object propertyValue = bucket.getProperty(agg.getName(), aggPathsList);
        if (propertyValue == null || !(propertyValue instanceof InternalTDigestPercentiles)) {
            throw this.buildResolveError(agg, aggPathsList, propertyValue, "TDigest");
        }
        return ((InternalTDigestPercentiles)propertyValue).getState();
    }

    private DoubleHistogram resolveHDRBucketValue(MultiBucketsAggregation agg, InternalMultiBucketAggregation.InternalBucket bucket, String aggPath) {
        List aggPathsList = AggregationPath.parse((String)aggPath).getPathElementsAsStringList();
        Object propertyValue = bucket.getProperty(agg.getName(), aggPathsList);
        if (propertyValue == null || !(propertyValue instanceof InternalHDRPercentiles)) {
            throw this.buildResolveError(agg, aggPathsList, propertyValue, "HDR");
        }
        return ((InternalHDRPercentiles)propertyValue).getState();
    }

    private IllegalArgumentException buildResolveError(MultiBucketsAggregation agg, List<String> aggPathsList, Object propertyValue, String method) {
        if (propertyValue == null) {
            return new IllegalArgumentException(AbstractPipelineAggregationBuilder.BUCKETS_PATH_FIELD.getPreferredName() + " must reference a " + method + " percentile aggregation");
        }
        String currentAggName = aggPathsList.isEmpty() ? agg.getName() : aggPathsList.get(0);
        return new IllegalArgumentException(AbstractPipelineAggregationBuilder.BUCKETS_PATH_FIELD.getPreferredName() + " must reference a " + method + " percentiles aggregation, got: [" + propertyValue.getClass().getSimpleName() + "] at aggregation [" + currentAggName + "]");
    }

    private int clamp(int index, int length) {
        if (index < 0) {
            return 0;
        }
        if (index > length) {
            return length;
        }
        return index;
    }

    private static class PercentileConfig {
        final double[] keys;
        final boolean keyed;
        final PercentilesMethod method;
        final DocValueFormat formatter;

        PercentileConfig(PercentilesMethod method, double[] keys, boolean keyed, DocValueFormat formatter) {
            this.method = method;
            this.keys = keys;
            this.keyed = keyed;
            this.formatter = formatter;
        }
    }
}

