/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.cumulativecardinality;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.pipeline.SimpleValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalSimpleLongValue
extends InternalNumericMetricsAggregation.SingleValue
implements SimpleValue {
    public static final String NAME = "simple_long_value";
    protected final long value;

    public InternalSimpleLongValue(String name, long value, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, metadata);
        this.format = formatter;
        this.value = value;
    }

    public InternalSimpleLongValue(StreamInput in) throws IOException {
        super(in);
        this.format = (DocValueFormat)in.readNamedWriteable(DocValueFormat.class);
        this.value = in.readZLong();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.format);
        out.writeZLong(this.value);
    }

    public String getWriteableName() {
        return NAME;
    }

    public double value() {
        return this.value;
    }

    public long getValue() {
        return this.value;
    }

    DocValueFormat formatter() {
        return this.format;
    }

    public InternalSimpleLongValue reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        throw new UnsupportedOperationException("Not supported");
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = !(Double.isInfinite(this.value) || Double.isNaN(this.value));
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), hasValue ? Long.valueOf(this.value) : null);
        if (hasValue && this.format != DocValueFormat.RAW) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(this.value).toString());
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalSimpleLongValue other = (InternalSimpleLongValue)((Object)obj);
        return Objects.equals(this.value, other.value);
    }
}

