/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.notifications;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditor;
import org.elasticsearch.xpack.core.transform.TransformMetadata;
import org.elasticsearch.xpack.core.transform.notifications.TransformAuditMessage;
import org.elasticsearch.xpack.transform.persistence.TransformInternalIndex;

public class TransformAuditor
extends AbstractAuditor<TransformAuditMessage> {
    private volatile boolean isResetMode = false;

    public TransformAuditor(Client client, String nodeName, ClusterService clusterService) {
        super(new OriginSettingClient(client, "transform"), ".transform-notifications-000002", ".transform-notifications-000002", () -> {
            try {
                return new PutComposableIndexTemplateAction.Request(".transform-notifications-000002").indexTemplate(new ComposableIndexTemplate.Builder().template(TransformInternalIndex.getAuditIndexTemplate()).version(Long.valueOf(Version.CURRENT.id)).indexPatterns(Collections.singletonList(".transform-notifications-*")).priority(Long.valueOf(Long.MAX_VALUE)).build());
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failure creating transform notification index", (Throwable)e, new Object[0]);
            }
        }, nodeName, TransformAuditMessage::new, clusterService);
        clusterService.addListener(event -> {
            if (event.metadataChanged()) {
                this.isResetMode = TransformMetadata.getTransformMetadata((ClusterState)event.state()).isResetMode();
            }
        });
    }

    protected void indexDoc(ToXContent toXContent) {
        if (!this.isResetMode) {
            super.indexDoc(toXContent);
        }
    }

    protected void writeBacklog() {
        if (this.isResetMode) {
            this.clearBacklog();
        } else {
            super.writeBacklog();
        }
    }
}

