/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexAction;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.transform.action.ResetTransformAction;
import org.elasticsearch.xpack.core.transform.action.StopTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfigUpdate;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.action.TransformUpdater;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.SeqNoPrimaryTermAndIndex;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.persistence.TransformIndex;
import org.elasticsearch.xpack.transform.transforms.TransformTask;

public class TransportResetTransformAction
extends AcknowledgedTransportMasterNodeAction<ResetTransformAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportResetTransformAction.class);
    private final TransformConfigManager transformConfigManager;
    private final TransformAuditor auditor;
    private final Client client;
    private final SecurityContext securityContext;
    private final Settings settings;

    @Inject
    public TransportResetTransformAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TransformServices transformServices, Client client, Settings settings) {
        super("cluster:admin/transform/reset", transportService, clusterService, threadPool, actionFilters, ResetTransformAction.Request::new, indexNameExpressionResolver, "same");
        this.transformConfigManager = transformServices.getConfigManager();
        this.auditor = transformServices.getAuditor();
        this.client = Objects.requireNonNull(client);
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.settings = settings;
    }

    protected void masterOperation(Task task, ResetTransformAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        boolean transformIsRunning;
        boolean bl = transformIsRunning = TransformTask.getTransformTask(request.getId(), state) != null;
        if (transformIsRunning && !request.isForce()) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Cannot reset transform [" + request.getId() + "] as the task is running. Stop the task first", RestStatus.CONFLICT, new Object[0]));
            return;
        }
        SetOnce transformConfigAndVersionHolder = new SetOnce();
        ActionListener updateTransformListener = ActionListener.wrap(unusedUpdateResult -> this.transformConfigManager.resetTransform(request.getId(), (ActionListener<Boolean>)ActionListener.wrap(resetResponse -> {
            logger.debug("[{}] reset transform", (Object)request.getId());
            this.auditor.info(request.getId(), "Reset transform.");
            listener.onResponse((Object)AcknowledgedResponse.of((boolean)resetResponse));
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0));
        ActionListener deleteDestIndexListener = ActionListener.wrap(unusedDeleteDestIndexResponse -> {
            ClusterState clusterState = this.clusterService.state();
            TransformUpdater.updateTransform(this.securityContext, this.indexNameExpressionResolver, clusterState, this.settings, this.client, this.transformConfigManager, (TransformConfig)((Tuple)transformConfigAndVersionHolder.get()).v1(), TransformConfigUpdate.EMPTY, (SeqNoPrimaryTermAndIndex)((Tuple)transformConfigAndVersionHolder.get()).v2(), false, false, false, request.timeout(), (ActionListener<TransformUpdater.UpdateResult>)updateTransformListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener isDestinationIndexCreatedByTransformListener = ActionListener.wrap(isDestinationIndexCreatedByTransform -> {
            if (!isDestinationIndexCreatedByTransform.booleanValue()) {
                deleteDestIndexListener.onResponse((Object)AcknowledgedResponse.TRUE);
                return;
            }
            String destIndex = ((TransformConfig)((Tuple)transformConfigAndVersionHolder.get()).v1()).getDestination().getIndex();
            DeleteIndexRequest deleteDestIndexRequest = new DeleteIndexRequest(destIndex);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"transform", (ActionType)DeleteIndexAction.INSTANCE, (ActionRequest)deleteDestIndexRequest, (ActionListener)deleteDestIndexListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener getTransformConfigurationListener = ActionListener.wrap(transformConfigAndVersion -> {
            transformConfigAndVersionHolder.set(transformConfigAndVersion);
            String destIndex = ((TransformConfig)transformConfigAndVersion.v1()).getDestination().getIndex();
            TransformIndex.isDestinationIndexCreatedByTransform(this.client, destIndex, (ActionListener<Boolean>)isDestinationIndexCreatedByTransformListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener stopTransformActionListener = ActionListener.wrap(unusedStopResponse -> this.transformConfigManager.getTransformConfigurationForUpdate(request.getId(), (ActionListener<Tuple<TransformConfig, SeqNoPrimaryTermAndIndex>>)getTransformConfigurationListener), arg_0 -> listener.onFailure(arg_0));
        if (!transformIsRunning) {
            stopTransformActionListener.onResponse(null);
            return;
        }
        StopTransformAction.Request stopTransformRequest = new StopTransformAction.Request(request.getId(), true, false, null, true, false);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"transform", (ActionType)StopTransformAction.INSTANCE, (ActionRequest)stopTransformRequest, (ActionListener)stopTransformActionListener);
    }

    protected ClusterBlockException checkBlock(ResetTransformAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

