/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.transform.action.GetTransformStatsAction;
import org.elasticsearch.xpack.core.transform.transforms.NodeAttributes;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpointingInfo;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformStoredDoc;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.checkpoint.TransformCheckpointService;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.transforms.TransformNodeAssignments;
import org.elasticsearch.xpack.transform.transforms.TransformNodes;
import org.elasticsearch.xpack.transform.transforms.TransformTask;

public class TransportGetTransformStatsAction
extends TransportTasksAction<TransformTask, GetTransformStatsAction.Request, GetTransformStatsAction.Response, GetTransformStatsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetTransformStatsAction.class);
    private final TransformConfigManager transformConfigManager;
    private final TransformCheckpointService transformCheckpointService;
    private final Client client;
    private final Settings nodeSettings;

    @Inject
    public TransportGetTransformStatsAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, TransformServices transformServices, Client client, Settings settings) {
        super("cluster:monitor/transform/stats/get", clusterService, transportService, actionFilters, GetTransformStatsAction.Request::new, GetTransformStatsAction.Response::new, GetTransformStatsAction.Response::new, "same");
        this.transformConfigManager = transformServices.getConfigManager();
        this.transformCheckpointService = transformServices.getCheckpointService();
        this.client = client;
        this.nodeSettings = settings;
    }

    protected GetTransformStatsAction.Response newResponse(GetTransformStatsAction.Request request, List<GetTransformStatsAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        List responses = tasks.stream().flatMap(r -> r.getTransformsStats().stream()).sorted(Comparator.comparing(TransformStats::getId)).collect(Collectors.toList());
        ArrayList<FailedNodeException> allFailedNodeExceptions = new ArrayList<FailedNodeException>(failedNodeExceptions);
        allFailedNodeExceptions.addAll(tasks.stream().flatMap(r -> r.getNodeFailures().stream()).collect(Collectors.toList()));
        return new GetTransformStatsAction.Response(responses, (long)responses.size(), taskOperationFailures, allFailedNodeExceptions);
    }

    protected void taskOperation(GetTransformStatsAction.Request request, TransformTask task, ActionListener<GetTransformStatsAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        String nodeId = state.nodes().getLocalNode().getId();
        if (!task.isCancelled()) {
            task.getCheckpointingInfo(this.transformCheckpointService, (ActionListener<TransformCheckpointingInfo>)ActionListener.wrap(checkpointingInfo -> listener.onResponse((Object)new GetTransformStatsAction.Response(Collections.singletonList(TransportGetTransformStatsAction.deriveStats(task, checkpointingInfo)), 1L)), e -> {
                logger.warn("Failed to retrieve checkpointing info for transform [" + task.getTransformId() + "]", (Throwable)e);
                listener.onResponse((Object)new GetTransformStatsAction.Response(Collections.singletonList(TransportGetTransformStatsAction.deriveStats(task, null)), 1L, Collections.emptyList(), Collections.singletonList(new FailedNodeException(nodeId, "Failed to retrieve checkpointing info", (Throwable)e))));
            }));
        } else {
            listener.onResponse((Object)new GetTransformStatsAction.Response(Collections.emptyList(), 0L));
        }
    }

    protected void doExecute(Task task, GetTransformStatsAction.Request request, ActionListener<GetTransformStatsAction.Response> finalListener) {
        ClusterState clusterState = this.clusterService.state();
        TransformNodes.warnIfNoTransformNodes(clusterState);
        this.transformConfigManager.expandTransformIds(request.getId(), request.getPageParams(), request.isAllowNoMatch(), (ActionListener<Tuple<Long, Tuple<List<String>, List<TransformConfig>>>>)ActionListener.wrap(hitsAndIds -> {
            boolean hasAnyTransformNode = TransformNodes.hasAnyTransformNode(clusterState.getNodes());
            boolean requiresRemote = ((List)((Tuple)hitsAndIds.v2()).v2()).stream().anyMatch(config -> config.getSource().requiresRemoteCluster());
            if (hasAnyTransformNode && TransformNodes.redirectToAnotherNodeIfNeeded(clusterState, this.nodeSettings, requiresRemote, this.transportService, this.actionName, request, GetTransformStatsAction.Response::new, finalListener)) {
                return;
            }
            request.setExpandedIds((List)((Tuple)hitsAndIds.v2()).v1());
            TransformNodeAssignments transformNodeAssignments = TransformNodes.transformTaskNodes((List)((Tuple)hitsAndIds.v2()).v1(), clusterState);
            ActionListener doExecuteListener = ActionListener.wrap(response -> {
                PersistentTasksCustomMetadata tasksInProgress = (PersistentTasksCustomMetadata)clusterState.getMetadata().custom("persistent_tasks");
                if (tasksInProgress != null) {
                    response.getTransformsStats().forEach(dtsasi -> TransportGetTransformStatsAction.setNodeAttributes(dtsasi, tasksInProgress, clusterState));
                }
                this.collectStatsForTransformsWithoutTasks(request, (GetTransformStatsAction.Response)response, transformNodeAssignments.getWaitingForAssignment(), clusterState, (ActionListener<GetTransformStatsAction.Response>)ActionListener.wrap(finalResponse -> finalListener.onResponse((Object)new GetTransformStatsAction.Response(finalResponse.getTransformsStats(), ((Long)hitsAndIds.v1()).longValue(), finalResponse.getTaskFailures(), finalResponse.getNodeFailures())), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)));
            }, arg_0 -> ((ActionListener)finalListener).onFailure(arg_0));
            if (transformNodeAssignments.getExecutorNodes().size() > 0) {
                request.setNodes(transformNodeAssignments.getExecutorNodes().toArray(new String[0]));
                super.doExecute(task, (BaseTasksRequest)request, doExecuteListener);
            } else {
                doExecuteListener.onResponse((Object)new GetTransformStatsAction.Response(Collections.emptyList(), 0L));
            }
        }, e -> {
            if (e instanceof ResourceNotFoundException) {
                finalListener.onResponse((Object)new GetTransformStatsAction.Response(Collections.emptyList(), 0L));
            } else {
                finalListener.onFailure(e);
            }
        }));
    }

    private static void setNodeAttributes(TransformStats transformStats, PersistentTasksCustomMetadata persistentTasksCustomMetadata, ClusterState state) {
        PersistentTasksCustomMetadata.PersistentTask pTask = persistentTasksCustomMetadata.getTask(transformStats.getId());
        if (pTask != null) {
            transformStats.setNode(NodeAttributes.fromDiscoveryNode((DiscoveryNode)state.nodes().get(pTask.getExecutorNode())));
        }
    }

    static TransformStats deriveStats(TransformTask task, @Nullable TransformCheckpointingInfo checkpointingInfo) {
        TransformState transformState = task.getState();
        TransformStats.State derivedState = TransformStats.State.fromComponents((TransformTaskState)transformState.getTaskState(), (IndexerState)transformState.getIndexerState());
        String reason = transformState.getReason();
        if (transformState.shouldStopAtNextCheckpoint() && !derivedState.equals((Object)TransformStats.State.STOPPED) && !derivedState.equals((Object)TransformStats.State.FAILED)) {
            derivedState = TransformStats.State.STOPPING;
            reason = Strings.isNullOrEmpty((String)reason) ? "transform is set to stop at the next checkpoint" : reason;
        }
        return new TransformStats(task.getTransformId(), derivedState, reason, null, task.getStats(), checkpointingInfo == null ? TransformCheckpointingInfo.EMPTY : checkpointingInfo);
    }

    private void collectStatsForTransformsWithoutTasks(GetTransformStatsAction.Request request, GetTransformStatsAction.Response response, Set<String> transformsWaitingForAssignment, ClusterState clusterState, ActionListener<GetTransformStatsAction.Response> listener) {
        if (request.getExpandedIds().size() == response.getTransformsStats().size()) {
            listener.onResponse((Object)response);
            return;
        }
        HashSet<String> transformsWithoutTasks = new HashSet<String>(request.getExpandedIds());
        transformsWithoutTasks.removeAll(response.getTransformsStats().stream().map(TransformStats::getId).collect(Collectors.toList()));
        assert (transformsWithoutTasks.size() <= 1000);
        ActionListener searchStatsListener = ActionListener.wrap(statsForTransformsWithoutTasks -> {
            ArrayList<TransformStats> allStateAndStats = new ArrayList<TransformStats>(response.getTransformsStats());
            this.addCheckpointingInfoForTransformsWithoutTasks((List<TransformStats>)allStateAndStats, (List<TransformStoredDoc>)statsForTransformsWithoutTasks, transformsWaitingForAssignment, clusterState, (ActionListener<Void>)ActionListener.wrap(aVoid -> {
                transformsWithoutTasks.removeAll(statsForTransformsWithoutTasks.stream().map(TransformStoredDoc::getId).collect(Collectors.toSet()));
                transformsWithoutTasks.forEach(transformId -> allStateAndStats.add(TransformStats.initialStats((String)transformId)));
                allStateAndStats.sort(Comparator.comparing(TransformStats::getId));
                listener.onResponse((Object)new GetTransformStatsAction.Response(allStateAndStats, (long)allStateAndStats.size(), response.getTaskFailures(), response.getNodeFailures()));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                listener.onResponse((Object)response);
            } else {
                listener.onFailure(e);
            }
        });
        this.transformConfigManager.getTransformStoredDocs(transformsWithoutTasks, (ActionListener<List<TransformStoredDoc>>)searchStatsListener);
    }

    private void populateSingleStoppedTransformStat(TransformStoredDoc transform, ActionListener<TransformCheckpointingInfo> listener) {
        this.transformCheckpointService.getCheckpointingInfo(this.client, transform.getId(), transform.getTransformState().getCheckpoint(), transform.getTransformState().getPosition(), transform.getTransformState().getProgress(), (ActionListener<TransformCheckpointingInfo.TransformCheckpointingInfoBuilder>)ActionListener.wrap(infoBuilder -> listener.onResponse((Object)infoBuilder.build()), e -> {
            logger.warn("Failed to retrieve checkpointing info for transform [" + transform.getId() + "]", (Throwable)e);
            listener.onResponse((Object)TransformCheckpointingInfo.EMPTY);
        }));
    }

    private void addCheckpointingInfoForTransformsWithoutTasks(List<TransformStats> allStateAndStats, List<TransformStoredDoc> statsForTransformsWithoutTasks, Set<String> transformsWaitingForAssignment, ClusterState clusterState, ActionListener<Void> listener) {
        if (statsForTransformsWithoutTasks.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        AtomicInteger numberRemaining = new AtomicInteger(statsForTransformsWithoutTasks.size());
        AtomicBoolean isExceptionReported = new AtomicBoolean(false);
        statsForTransformsWithoutTasks.forEach(stat -> this.populateSingleStoppedTransformStat((TransformStoredDoc)stat, (ActionListener<TransformCheckpointingInfo>)ActionListener.wrap(checkpointingInfo -> {
            List list = allStateAndStats;
            synchronized (list) {
                if (transformsWaitingForAssignment.contains(stat.getId())) {
                    PersistentTasksCustomMetadata.Assignment assignment = TransformNodes.getAssignment(stat.getId(), clusterState);
                    allStateAndStats.add(new TransformStats(stat.getId(), TransformStats.State.WAITING, assignment.getExplanation(), null, stat.getTransformStats(), checkpointingInfo));
                } else {
                    allStateAndStats.add(new TransformStats(stat.getId(), TransformStats.State.STOPPED, null, null, stat.getTransformStats(), checkpointingInfo));
                }
            }
            if (numberRemaining.decrementAndGet() == 0) {
                listener.onResponse(null);
            }
        }, e -> {
            if (isExceptionReported.compareAndSet(false, true)) {
                listener.onFailure(e);
            }
        })));
    }
}

