/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.transform.action.DeleteTransformAction;
import org.elasticsearch.xpack.core.transform.action.StopTransformAction;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.transforms.TransformTask;

public class TransportDeleteTransformAction
extends AcknowledgedTransportMasterNodeAction<DeleteTransformAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteTransformAction.class);
    private final TransformConfigManager transformConfigManager;
    private final TransformAuditor auditor;
    private final Client client;

    @Inject
    public TransportDeleteTransformAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, TransformServices transformServices, Client client) {
        super("cluster:admin/transform/delete", transportService, clusterService, threadPool, actionFilters, DeleteTransformAction.Request::new, indexNameExpressionResolver, "same");
        this.transformConfigManager = transformServices.getConfigManager();
        this.auditor = transformServices.getAuditor();
        this.client = client;
    }

    protected void masterOperation(Task task, DeleteTransformAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        boolean transformIsRunning;
        boolean bl = transformIsRunning = TransformTask.getTransformTask(request.getId(), state) != null;
        if (transformIsRunning && !request.isForce()) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Cannot delete transform [" + request.getId() + "] as the task is running. Stop the task first", RestStatus.CONFLICT, new Object[0]));
            return;
        }
        ActionListener stopTransformActionListener = ActionListener.wrap(unusedStopResponse -> this.transformConfigManager.deleteTransform(request.getId(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
            logger.debug("[{}] deleted transform", (Object)request.getId());
            this.auditor.info(request.getId(), "Deleted transform.");
            listener.onResponse((Object)AcknowledgedResponse.of((boolean)r));
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0));
        if (!transformIsRunning) {
            stopTransformActionListener.onResponse(null);
            return;
        }
        StopTransformAction.Request stopTransformRequest = new StopTransformAction.Request(request.getId(), true, true, null, true, false);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"transform", (ActionType)StopTransformAction.INSTANCE, (ActionRequest)stopTransformRequest, (ActionListener)stopTransformActionListener);
    }

    protected ClusterBlockException checkBlock(DeleteTransformAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

