/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.features.ResetFeatureStateResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.indices.AssociatedIndexDescriptor;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.action.SetResetModeActionRequest;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.scheduler.SchedulerEngine;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.TransformNamedXContentProvider;
import org.elasticsearch.xpack.core.transform.action.DeleteTransformAction;
import org.elasticsearch.xpack.core.transform.action.GetTransformAction;
import org.elasticsearch.xpack.core.transform.action.GetTransformStatsAction;
import org.elasticsearch.xpack.core.transform.action.PreviewTransformAction;
import org.elasticsearch.xpack.core.transform.action.PutTransformAction;
import org.elasticsearch.xpack.core.transform.action.ResetTransformAction;
import org.elasticsearch.xpack.core.transform.action.SetResetModeAction;
import org.elasticsearch.xpack.core.transform.action.StartTransformAction;
import org.elasticsearch.xpack.core.transform.action.StopTransformAction;
import org.elasticsearch.xpack.core.transform.action.UpdateTransformAction;
import org.elasticsearch.xpack.core.transform.action.UpgradeTransformsAction;
import org.elasticsearch.xpack.core.transform.action.ValidateTransformAction;
import org.elasticsearch.xpack.transform.TransformClusterStateListener;
import org.elasticsearch.xpack.transform.TransformInfoTransportAction;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.TransformUsageTransportAction;
import org.elasticsearch.xpack.transform.action.TransportDeleteTransformAction;
import org.elasticsearch.xpack.transform.action.TransportGetTransformAction;
import org.elasticsearch.xpack.transform.action.TransportGetTransformStatsAction;
import org.elasticsearch.xpack.transform.action.TransportPreviewTransformAction;
import org.elasticsearch.xpack.transform.action.TransportPutTransformAction;
import org.elasticsearch.xpack.transform.action.TransportResetTransformAction;
import org.elasticsearch.xpack.transform.action.TransportSetTransformResetModeAction;
import org.elasticsearch.xpack.transform.action.TransportStartTransformAction;
import org.elasticsearch.xpack.transform.action.TransportStopTransformAction;
import org.elasticsearch.xpack.transform.action.TransportUpdateTransformAction;
import org.elasticsearch.xpack.transform.action.TransportUpgradeTransformsAction;
import org.elasticsearch.xpack.transform.action.TransportValidateTransformAction;
import org.elasticsearch.xpack.transform.checkpoint.TransformCheckpointService;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.IndexBasedTransformConfigManager;
import org.elasticsearch.xpack.transform.persistence.TransformInternalIndex;
import org.elasticsearch.xpack.transform.rest.action.RestCatTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestDeleteTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestGetTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestGetTransformStatsAction;
import org.elasticsearch.xpack.transform.rest.action.RestPreviewTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestPutTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestResetTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestStartTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestStopTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestUpdateTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestUpgradeTransformsAction;
import org.elasticsearch.xpack.transform.transforms.TransformPersistentTasksExecutor;

public class Transform
extends Plugin
implements SystemIndexPlugin,
PersistentTaskPlugin {
    public static final String NAME = "transform";
    private static final Logger logger = LogManager.getLogger(Transform.class);
    private final Settings settings;
    private final SetOnce<TransformServices> transformServices = new SetOnce();
    public static final int DEFAULT_FAILURE_RETRIES = 10;
    public static final Integer DEFAULT_INITIAL_MAX_PAGE_SEARCH_SIZE = 500;
    public static final TimeValue DEFAULT_TRANSFORM_FREQUENCY = TimeValue.timeValueMillis((long)60000L);
    public static final Setting<Integer> NUM_FAILURE_RETRIES_SETTING = Setting.intSetting((String)"xpack.transform.num_transform_failure_retries", (int)10, (int)0, (int)100, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});

    public Transform(Settings settings) {
        this.settings = settings;
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public List<RestHandler> getRestHandlers(Settings unused, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestHandler[]{new RestPutTransformAction(), new RestStartTransformAction(), new RestStopTransformAction(), new RestDeleteTransformAction(), new RestGetTransformAction(), new RestGetTransformStatsAction(), new RestPreviewTransformAction(), new RestUpdateTransformAction(), new RestCatTransformAction(), new RestUpgradeTransformsAction(), new RestResetTransformAction()});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)PutTransformAction.INSTANCE, TransportPutTransformAction.class), new ActionPlugin.ActionHandler((ActionType)StartTransformAction.INSTANCE, TransportStartTransformAction.class), new ActionPlugin.ActionHandler((ActionType)StopTransformAction.INSTANCE, TransportStopTransformAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteTransformAction.INSTANCE, TransportDeleteTransformAction.class), new ActionPlugin.ActionHandler((ActionType)GetTransformAction.INSTANCE, TransportGetTransformAction.class), new ActionPlugin.ActionHandler((ActionType)GetTransformStatsAction.INSTANCE, TransportGetTransformStatsAction.class), new ActionPlugin.ActionHandler((ActionType)PreviewTransformAction.INSTANCE, TransportPreviewTransformAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateTransformAction.INSTANCE, TransportUpdateTransformAction.class), new ActionPlugin.ActionHandler((ActionType)SetResetModeAction.INSTANCE, TransportSetTransformResetModeAction.class), new ActionPlugin.ActionHandler((ActionType)ValidateTransformAction.INSTANCE, TransportValidateTransformAction.class), new ActionPlugin.ActionHandler((ActionType)UpgradeTransformsAction.INSTANCE, TransportUpgradeTransformsAction.class), new ActionPlugin.ActionHandler((ActionType)ResetTransformAction.INSTANCE, TransportResetTransformAction.class), new ActionPlugin.ActionHandler((ActionType)XPackUsageFeatureAction.TRANSFORM, TransformUsageTransportAction.class), new ActionPlugin.ActionHandler((ActionType)XPackInfoFeatureAction.TRANSFORM, TransformInfoTransportAction.class));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        IndexBasedTransformConfigManager configManager = new IndexBasedTransformConfigManager(clusterService, expressionResolver, client, xContentRegistry);
        TransformAuditor auditor = new TransformAuditor(client, clusterService.getNodeName(), clusterService);
        TransformCheckpointService checkpointService = new TransformCheckpointService(Clock.systemUTC(), this.settings, clusterService, configManager, auditor);
        SchedulerEngine scheduler = new SchedulerEngine(this.settings, Clock.systemUTC());
        this.transformServices.set((Object)new TransformServices(configManager, checkpointService, auditor, scheduler));
        return Arrays.asList(this.transformServices.get(), new TransformClusterStateListener(clusterService, client));
    }

    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule, IndexNameExpressionResolver expressionResolver) {
        assert (this.transformServices.get() != null);
        return Collections.singletonList(new TransformPersistentTasksExecutor(client, (TransformServices)this.transformServices.get(), threadPool, clusterService, settingsModule.getSettings(), expressionResolver));
    }

    public List<Setting<?>> getSettings() {
        return List.of(NUM_FAILURE_RETRIES_SETTING);
    }

    public void close() {
        if (this.transformServices.get() != null) {
            ((TransformServices)this.transformServices.get()).getSchedulerEngine().stop();
        }
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return new TransformNamedXContentProvider().getNamedXContentParsers();
    }

    public UnaryOperator<Map<String, IndexTemplateMetadata>> getIndexTemplateMetadataUpgrader() {
        return templates -> {
            templates.remove(".data-frame-internal-1");
            templates.remove(".data-frame-internal-2");
            templates.remove(".transform-internal-003");
            templates.remove(".transform-internal-004");
            templates.remove(".transform-internal-005");
            templates.remove(".data-frame-notifications-1");
            templates.remove(".transform-notifications-000001");
            templates.remove(".transform-notifications-000002");
            return templates;
        };
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        try {
            return Collections.singletonList(TransformInternalIndex.getSystemIndexDescriptor());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Collection<AssociatedIndexDescriptor> getAssociatedIndexDescriptors() {
        return List.of(new AssociatedIndexDescriptor(".transform-notifications-*", "Audit index"));
    }

    public void cleanUpFeature(ClusterService clusterService, Client unwrappedClient, ActionListener<ResetFeatureStateResponse.ResetFeatureStateStatus> finalListener) {
        OriginSettingClient client = new OriginSettingClient(unwrappedClient, NAME);
        ActionListener unsetResetModeListener = ActionListener.wrap(success -> client.execute((ActionType)SetResetModeAction.INSTANCE, (ActionRequest)SetResetModeActionRequest.disabled((boolean)true), ActionListener.wrap(resetSuccess -> finalListener.onResponse(success), resetFailure -> {
            logger.error("failed to disable reset mode after otherwise successful transform reset", (Throwable)resetFailure);
            finalListener.onFailure((Exception)new ElasticsearchStatusException(TransformMessages.getMessage((String)"Failed to set [reset_mode] to [false] after {0}. To allow transforms to run, please call the feature reset API again", (Object[])new Object[]{"a successful feature reset"}), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)resetFailure, new Object[0]));
        })), failure -> client.execute((ActionType)SetResetModeAction.INSTANCE, (ActionRequest)SetResetModeActionRequest.disabled((boolean)false), ActionListener.wrap(resetSuccess -> finalListener.onFailure(failure), resetFailure -> {
            logger.error(TransformMessages.getMessage((String)"Failed to set [reset_mode] to [false] after {0}. To allow transforms to run, please call the feature reset API again", (Object[])new Object[]{"a failed feature reset"}), (Throwable)resetFailure);
            ElasticsearchException ex = new ElasticsearchException(TransformMessages.getMessage((String)"Failed to set [reset_mode] to [false] after {0}. To allow transforms to run, please call the feature reset API again", (Object[])new Object[]{"a failed feature reset"}), new Object[0]);
            ex.addSuppressed((Throwable)resetFailure);
            failure.addSuppressed((Throwable)ex);
            finalListener.onFailure(failure);
        })));
        ActionListener afterWaitingForTasks = ActionListener.wrap(listTasksResponse -> {
            listTasksResponse.rethrowFailures("Waiting for transform indexing tasks");
            super.cleanUpFeature(clusterService, (Client)client, unsetResetModeListener);
        }, arg_0 -> ((ActionListener)unsetResetModeListener).onFailure(arg_0));
        ActionListener afterStoppingTransforms = ActionListener.wrap(stopTransformsResponse -> {
            if (stopTransformsResponse.isAcknowledged() && stopTransformsResponse.getTaskFailures().isEmpty() && stopTransformsResponse.getNodeFailures().isEmpty()) {
                ((ListTasksRequestBuilder)client.admin().cluster().prepareListTasks(new String[0]).setActions(new String[]{"data_frame/transforms"})).setWaitForCompletion(true).execute(ActionListener.wrap(listTransformTasks -> {
                    listTransformTasks.rethrowFailures("Waiting for transform tasks");
                    ((ListTasksRequestBuilder)client.admin().cluster().prepareListTasks(new String[0]).setActions(new String[]{"indices:data/write/bulk"})).setDetailed(true).setWaitForCompletion(true).setDescriptions(new String[]{"*.transform-*", "*.data-frame-*"}).execute(afterWaitingForTasks);
                }, arg_0 -> ((ActionListener)unsetResetModeListener).onFailure(arg_0)));
            } else {
                String errMsg = "Failed to reset Transform: " + (stopTransformsResponse.isAcknowledged() ? "" : "not acknowledged ") + (String)(stopTransformsResponse.getNodeFailures().isEmpty() ? "" : "node failures: " + stopTransformsResponse.getNodeFailures() + " ") + (String)(stopTransformsResponse.getTaskFailures().isEmpty() ? "" : "task failures: " + stopTransformsResponse.getTaskFailures());
                unsetResetModeListener.onResponse((Object)ResetFeatureStateResponse.ResetFeatureStateStatus.failure((String)this.getFeatureName(), (Exception)new ElasticsearchException(errMsg, new Object[0])));
            }
        }, arg_0 -> ((ActionListener)unsetResetModeListener).onFailure(arg_0));
        ActionListener afterResetModeSet = ActionListener.wrap(response -> {
            StopTransformAction.Request stopTransformsRequest = new StopTransformAction.Request("_all", true, true, null, true, false);
            client.execute((ActionType)StopTransformAction.INSTANCE, (ActionRequest)stopTransformsRequest, afterStoppingTransforms);
        }, arg_0 -> finalListener.onFailure(arg_0));
        client.execute((ActionType)SetResetModeAction.INSTANCE, (ActionRequest)SetResetModeActionRequest.enabled(), afterResetModeSet);
    }

    public String getFeatureName() {
        return NAME;
    }

    public String getFeatureDescription() {
        return "Manages configuration and state for transforms";
    }
}

