/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.ExecutorNames;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class SecuritySystemIndices {
    public static final int INTERNAL_MAIN_INDEX_FORMAT = 6;
    private static final int INTERNAL_TOKENS_INDEX_FORMAT = 7;
    private static final int INTERNAL_PROFILE_INDEX_FORMAT = 8;
    public static final String INTERNAL_SECURITY_PROFILE_INDEX_8 = ".security-profile-8";
    public static final String SECURITY_PROFILE_ALIAS = ".security-profile";
    private final Logger logger = LogManager.getLogger();
    private final SystemIndexDescriptor mainDescriptor = this.getSecurityMainIndexDescriptor();
    private final SystemIndexDescriptor tokenDescriptor = this.getSecurityTokenIndexDescriptor();
    private final SystemIndexDescriptor profileDescriptor = this.getSecurityProfileIndexDescriptor();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private SecurityIndexManager mainIndexManager = null;
    private SecurityIndexManager tokenIndexManager = null;
    private SecurityIndexManager profileIndexManager = null;

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors() {
        if (XPackSettings.USER_PROFILE_FEATURE_FLAG_ENABLED) {
            return List.of(this.mainDescriptor, this.tokenDescriptor, this.profileDescriptor);
        }
        return List.of(this.mainDescriptor, this.tokenDescriptor);
    }

    public void init(Client client, ClusterService clusterService) {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("Already initialized");
        }
        this.mainIndexManager = SecurityIndexManager.buildSecurityIndexManager(client, clusterService, this.mainDescriptor);
        this.tokenIndexManager = SecurityIndexManager.buildSecurityIndexManager(client, clusterService, this.tokenDescriptor);
        this.profileIndexManager = SecurityIndexManager.buildSecurityIndexManager(client, clusterService, this.profileDescriptor);
    }

    public SecurityIndexManager getMainIndexManager() {
        this.checkInitialized();
        return this.mainIndexManager;
    }

    public SecurityIndexManager getTokenIndexManager() {
        this.checkInitialized();
        return this.tokenIndexManager;
    }

    public SecurityIndexManager getProfileIndexManager() {
        return this.profileIndexManager;
    }

    private void checkInitialized() {
        if (!this.initialized.get()) {
            String message = "Attempt access " + this.getClass().getSimpleName() + " before it is initialized";
            assert (false) : message;
            throw new IllegalStateException(message);
        }
    }

    private SystemIndexDescriptor getSecurityMainIndexDescriptor() {
        return SystemIndexDescriptor.builder().setIndexPattern(".security-[0-9]+*").setPrimaryIndex(".security-7").setDescription("Contains Security configuration").setMappings(this.getMainIndexMappings()).setSettings(this.getMainIndexSettings()).setAliasName(".security").setIndexFormat(6).setVersionMetaKey("security-version").setOrigin("security").setThreadPools(ExecutorNames.CRITICAL_SYSTEM_INDEX_THREAD_POOLS).build();
    }

    private Settings getMainIndexSettings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.auto_expand_replicas", "0-1").put("index.priority", 1000).put("index.refresh_interval", "1s").put(IndexMetadata.INDEX_FORMAT_SETTING.getKey(), 6).put("analysis.filter.email.type", "pattern_capture").put("analysis.filter.email.preserve_original", true).putList("analysis.filter.email.patterns", List.of("([^@]+)", "(\\p{L}+)", "(\\d+)", "@(.+)")).put("analysis.analyzer.email.tokenizer", "uax_url_email").putList("analysis.analyzer.email.filter", List.of("email", "lowercase", "unique")).build();
    }

    private XContentBuilder getMainIndexMappings() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.startObject("_meta");
            builder.field("security-version", Version.CURRENT.toString());
            builder.endObject();
            builder.field("dynamic", "strict");
            builder.startObject("properties");
            builder.startObject("username");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("roles");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("role_templates");
            builder.startObject("properties");
            builder.startObject("template");
            builder.field("type", "text");
            builder.endObject();
            builder.startObject("format");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("password");
            builder.field("type", "keyword");
            builder.field("index", false);
            builder.field("doc_values", false);
            builder.endObject();
            builder.startObject("full_name");
            builder.field("type", "text");
            builder.endObject();
            builder.startObject("email");
            builder.field("type", "text");
            builder.field("analyzer", "email");
            builder.endObject();
            builder.startObject("metadata");
            builder.field("type", "object");
            builder.field("dynamic", false);
            builder.endObject();
            builder.startObject("metadata_flattened");
            builder.field("type", "flattened");
            builder.endObject();
            builder.startObject("enabled");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("cluster");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("indices");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("field_security");
            builder.startObject("properties");
            builder.startObject("grant");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("except");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("names");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("privileges");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("query");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("allow_restricted_indices");
            builder.field("type", "boolean");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("applications");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("application");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("privileges");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("resources");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("application");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("global");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("application");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("manage");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("applications");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("name");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("run_as");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("doc_type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("actions");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("expiration_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("creation_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("api_key_hash");
            builder.field("type", "keyword");
            builder.field("index", false);
            builder.field("doc_values", false);
            builder.endObject();
            builder.startObject("api_key_invalidated");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("role_descriptors");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.endObject();
            builder.startObject("limited_by_role_descriptors");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.endObject();
            builder.startObject("version");
            builder.field("type", "integer");
            builder.endObject();
            builder.startObject("creator");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("principal");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("full_name");
            builder.field("type", "text");
            builder.endObject();
            builder.startObject("email");
            builder.field("type", "text");
            builder.field("analyzer", "email");
            builder.endObject();
            builder.startObject("metadata");
            builder.field("type", "object");
            builder.field("dynamic", false);
            builder.endObject();
            builder.startObject("realm");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("realm_type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("rules");
            builder.field("type", "object");
            builder.field("dynamic", false);
            builder.endObject();
            builder.startObject("refresh_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("token");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("refreshed");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("refresh_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("superseding");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("encrypted_tokens");
            builder.field("type", "binary");
            builder.endObject();
            builder.startObject("encryption_iv");
            builder.field("type", "binary");
            builder.endObject();
            builder.startObject("encryption_salt");
            builder.field("type", "binary");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("invalidated");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("client");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("user");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("realm");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("access_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("user_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("id");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("expiration_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("version");
            builder.field("type", "integer");
            builder.endObject();
            builder.startObject("metadata");
            builder.field("type", "object");
            builder.field("dynamic", false);
            builder.endObject();
            builder.startObject("authentication");
            builder.field("type", "binary");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("invalidated");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("realm");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            this.logger.fatal("Failed to build .security-7 index mappings", (Throwable)e);
            throw new UncheckedIOException("Failed to build .security-7 index mappings", e);
        }
    }

    private SystemIndexDescriptor getSecurityTokenIndexDescriptor() {
        return SystemIndexDescriptor.builder().setIndexPattern(".security-tokens-[0-9]+*").setPrimaryIndex(".security-tokens-7").setDescription("Contains auth token data").setMappings(this.getTokenIndexMappings()).setSettings(SecuritySystemIndices.getTokenIndexSettings()).setAliasName(".security-tokens").setIndexFormat(7).setVersionMetaKey("security-version").setOrigin("security").setThreadPools(ExecutorNames.CRITICAL_SYSTEM_INDEX_THREAD_POOLS).build();
    }

    private static Settings getTokenIndexSettings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.auto_expand_replicas", "0-1").put("index.priority", 1000).put("index.refresh_interval", "1s").put(IndexMetadata.INDEX_FORMAT_SETTING.getKey(), 7).build();
    }

    private XContentBuilder getTokenIndexMappings() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.startObject("_meta");
            builder.field("security-version", (ToXContent)Version.CURRENT);
            builder.endObject();
            builder.field("dynamic", "strict");
            builder.startObject("properties");
            builder.startObject("doc_type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("creation_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("refresh_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("token");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("refreshed");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("refresh_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("superseding");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("encrypted_tokens");
            builder.field("type", "binary");
            builder.endObject();
            builder.startObject("encryption_iv");
            builder.field("type", "binary");
            builder.endObject();
            builder.startObject("encryption_salt");
            builder.field("type", "binary");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("invalidated");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("client");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("user");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("realm");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("access_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("user_token");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("id");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("expiration_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("version");
            builder.field("type", "integer");
            builder.endObject();
            builder.startObject("metadata");
            builder.field("type", "object");
            builder.field("dynamic", false);
            builder.endObject();
            builder.startObject("authentication");
            builder.field("type", "binary");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("invalidated");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("realm");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to build .security-tokens-7 index mappings", e);
        }
    }

    private SystemIndexDescriptor getSecurityProfileIndexDescriptor() {
        return SystemIndexDescriptor.builder().setIndexPattern(".security-profile-[0-9]+*").setPrimaryIndex(INTERNAL_SECURITY_PROFILE_INDEX_8).setDescription("Contains user profile documents").setMappings(this.getProfileIndexMappings()).setSettings(this.getProfileIndexSettings()).setAliasName(SECURITY_PROFILE_ALIAS).setIndexFormat(8).setVersionMetaKey("security-version").setOrigin("security").setThreadPools(ExecutorNames.CRITICAL_SYSTEM_INDEX_THREAD_POOLS).build();
    }

    private Settings getProfileIndexSettings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.auto_expand_replicas", "0-1").put("index.priority", 1000).put("index.refresh_interval", "1s").put(IndexMetadata.INDEX_FORMAT_SETTING.getKey(), 8).put("analysis.filter.email.type", "pattern_capture").put("analysis.filter.email.preserve_original", true).putList("analysis.filter.email.patterns", List.of("([^@]+)", "(\\p{L}+)", "(\\d+)", "@(.+)")).put("analysis.analyzer.email.tokenizer", "uax_url_email").putList("analysis.analyzer.email.filter", List.of("email", "lowercase", "unique")).build();
    }

    private XContentBuilder getProfileIndexMappings() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.startObject("_meta");
            builder.field("security-version", Version.CURRENT.toString());
            builder.endObject();
            builder.field("dynamic", "strict");
            builder.startObject("properties");
            builder.startObject("user_profile");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("uid");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("enabled");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("user");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("username");
            builder.field("type", "search_as_you_type");
            builder.endObject();
            builder.startObject("roles");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("realm");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("name");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("domain");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("name");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("realms");
            builder.field("type", "nested");
            builder.startObject("properties");
            builder.startObject("name");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("node_name");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("email");
            builder.field("type", "text");
            builder.field("analyzer", "email");
            builder.endObject();
            builder.startObject("full_name");
            builder.field("type", "search_as_you_type");
            builder.endObject();
            builder.startObject("display_name");
            builder.field("type", "search_as_you_type");
            builder.endObject();
            builder.startObject("active");
            builder.field("type", "boolean");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("last_synchronized");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("access");
            builder.field("type", "flattened");
            builder.endObject();
            builder.startObject("application_data");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            this.logger.fatal("Failed to build profile index mappings", (Throwable)e);
            throw new UncheckedIOException("Failed to build profile index mappings", e);
        }
    }
}

