/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.service;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xpack.core.security.action.ClearSecurityCacheAction;
import org.elasticsearch.xpack.core.security.action.ClearSecurityCacheRequest;
import org.elasticsearch.xpack.core.security.support.Validation;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestClearServiceAccountTokenStoreCacheAction
extends SecurityBaseRestHandler {
    public RestClearServiceAccountTokenStoreCacheAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_security/service/{namespace}/{service}/credential/token/{name}/_clear_cache"));
    }

    public String getName() {
        return "xpack_security_clear_service_account_token_store_cache";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String namespace = request.param("namespace");
        String service = request.param("service");
        String[] tokenNames = request.paramAsStringArrayOrEmptyIfAll("name");
        ClearSecurityCacheRequest req = new ClearSecurityCacheRequest().cacheName("service");
        if (tokenNames.length == 0) {
            req.keys(new String[]{namespace + "/" + service + "/"});
        } else {
            HashSet<CallSite> qualifiedTokenNames = new HashSet<CallSite>(tokenNames.length);
            for (String name : tokenNames) {
                if (!Validation.isValidServiceAccountTokenName((String)name)) {
                    throw new IllegalArgumentException(Validation.formatInvalidServiceTokenNameErrorMessage((String)name));
                }
                qualifiedTokenNames.add((CallSite)((Object)(namespace + "/" + service + "/" + name)));
            }
            req.keys((String[])qualifiedTokenNames.toArray(String[]::new));
        }
        return channel -> client.execute((ActionType)ClearSecurityCacheAction.INSTANCE, (ActionRequest)req, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }
}

