/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.rolemapping;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingRequestBuilder;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingResponse;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestDeleteRoleMappingAction
extends SecurityBaseRestHandler {
    public RestDeleteRoleMappingAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.DELETE, (String)"/_security/role_mapping/{name}").replaces(RestRequest.Method.DELETE, "/_xpack/security/role_mapping/{name}", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "security_delete_role_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String name = request.param("name");
        String refresh = request.param("refresh");
        return channel -> ((DeleteRoleMappingRequestBuilder)new DeleteRoleMappingRequestBuilder((ElasticsearchClient)client).name(name).setRefreshPolicy(refresh)).execute((ActionListener)new RestBuilderListener<DeleteRoleMappingResponse>(channel){

            public RestResponse buildResponse(DeleteRoleMappingResponse response, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(response.isFound() ? RestStatus.OK : RestStatus.NOT_FOUND, builder.startObject().field("found", response.isFound()).endObject());
            }
        });
    }
}

