/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.role;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheAction;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheRequest;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public final class RestClearRolesCacheAction
extends SecurityBaseRestHandler {
    public RestClearRolesCacheAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_security/role/{name}/_clear_cache").replaces(RestRequest.Method.POST, "/_xpack/security/role/{name}/_clear_cache", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "security_clear_roles_cache_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) {
        String[] roles = request.paramAsStringArrayOrEmptyIfAll("name");
        ClearRolesCacheRequest req = new ClearRolesCacheRequest().names(roles);
        return channel -> client.execute((ActionType)ClearRolesCacheAction.INSTANCE, (ActionRequest)req, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }
}

