/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.profile;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.security.action.profile.UpdateProfileDataAction;
import org.elasticsearch.xpack.core.security.action.profile.UpdateProfileDataRequest;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestUpdateProfileDataAction
extends SecurityBaseRestHandler {
    static final ConstructingObjectParser<Payload, Void> PARSER = new ConstructingObjectParser("update_profile_data_request_payload", a -> new Payload((Map)a[0], (Map)a[1]));

    public RestUpdateProfileDataAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_security/profile/_data/{uid}"));
    }

    public String getName() {
        return "xpack_security_update_profile_data";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String uid = request.param("uid");
        long ifPrimaryTerm = request.paramAsLong("if_primary_term", -1L);
        long ifSeqNo = request.paramAsLong("if_seq_no", -1L);
        WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.parse((String)request.param("refresh", "wait_for"));
        Payload payload = (Payload)PARSER.parse(request.contentParser(), null);
        UpdateProfileDataRequest updateProfileDataRequest = new UpdateProfileDataRequest(uid, payload.access, payload.data, ifPrimaryTerm, ifSeqNo, refreshPolicy);
        return channel -> client.execute((ActionType)UpdateProfileDataAction.INSTANCE, (ActionRequest)updateProfileDataRequest, (ActionListener)new RestToXContentListener(channel));
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField("access", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField("data", new String[0]));
    }

    record Payload(Map<String, Object> access, Map<String, Object> data) {
    }
}

