/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.profile;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.xpack.core.security.action.profile.GetProfileAction;
import org.elasticsearch.xpack.core.security.action.profile.GetProfileRequest;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestGetProfileAction
extends SecurityBaseRestHandler {
    public RestGetProfileAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_security/profile/{uid}"));
    }

    public String getName() {
        return "xpack_security_get_profile";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String uid = request.param("uid");
        Set dataKeys = Strings.tokenizeByCommaToSet((String)request.param("data", null));
        GetProfileRequest getProfileRequest = new GetProfileRequest(uid, dataKeys);
        return channel -> client.execute((ActionType)GetProfileAction.INSTANCE, (ActionRequest)getProfileRequest, (ActionListener)new RestStatusToXContentListener(channel));
    }
}

