/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.profile;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.profile.ActivateProfileAction;
import org.elasticsearch.xpack.core.security.action.profile.ActivateProfileRequest;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestActivateProfileAction
extends SecurityBaseRestHandler {
    static final ObjectParser<ActivateProfileRequest, Void> PARSER = new ObjectParser("activate_profile_request", ActivateProfileRequest::new);

    public RestActivateProfileAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_security/profile/_activate"));
    }

    public String getName() {
        return "xpack_security_activate_profile";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            ActivateProfileRequest activateProfileRequest = (ActivateProfileRequest)PARSER.parse(parser, null);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)ActivateProfileAction.INSTANCE, (ActionRequest)activateProfileRequest, (ActionListener)new RestToXContentListener(channel));
            return restChannelConsumer;
        }
    }

    private static SecureString getSecureString(XContentParser parser) throws IOException {
        return new SecureString(Arrays.copyOfRange(parser.textCharacters(), parser.textOffset(), parser.textOffset() + parser.textLength()));
    }

    static {
        PARSER.declareString((req, str) -> req.getGrant().setType(str), new ParseField("grant_type", new String[0]));
        PARSER.declareString((req, str) -> req.getGrant().setUsername(str), new ParseField("username", new String[0]));
        PARSER.declareField((req, secStr) -> req.getGrant().setPassword(secStr), RestActivateProfileAction::getSecureString, new ParseField("password", new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField((req, secStr) -> req.getGrant().setAccessToken(secStr), RestActivateProfileAction::getSecureString, new ParseField("access_token", new String[0]), ObjectParser.ValueType.STRING);
    }
}

