/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.enrollment;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.enrollment.KibanaEnrollmentAction;
import org.elasticsearch.xpack.core.security.action.enrollment.KibanaEnrollmentRequest;
import org.elasticsearch.xpack.core.security.action.enrollment.KibanaEnrollmentResponse;
import org.elasticsearch.xpack.security.rest.action.enrollment.EnrollmentBaseRestHandler;

public class RestKibanaEnrollAction
extends EnrollmentBaseRestHandler {
    public RestKibanaEnrollAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public String getName() {
        return "kibana_enroll_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_security/enroll/kibana"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        return restChannel -> client.execute((ActionType)KibanaEnrollmentAction.INSTANCE, (ActionRequest)new KibanaEnrollmentRequest(), (ActionListener)new RestBuilderListener<KibanaEnrollmentResponse>(restChannel){

            public RestResponse buildResponse(KibanaEnrollmentResponse kibanaEnrollmentResponse, XContentBuilder builder) throws Exception {
                kibanaEnrollmentResponse.toXContent(builder, (ToXContent.Params)this.channel.request());
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

