/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.profile;

import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.TransportSingleItemBulkWriteAction;
import org.elasticsearch.action.get.GetAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.action.update.UpdateAction;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.action.profile.Profile;
import org.elasticsearch.xpack.core.security.action.profile.UpdateProfileDataRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationContext;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.profile.ProfileDocument;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class ProfileService {
    private static final Logger logger = LogManager.getLogger(ProfileService.class);
    private static final String DOC_ID_PREFIX = "profile_";
    private final Settings settings;
    private final Clock clock;
    private final Client client;
    private final SecurityIndexManager profileIndex;
    private final ThreadPool threadPool;

    public ProfileService(Settings settings, Clock clock, Client client, SecurityIndexManager profileIndex, ThreadPool threadPool) {
        this.settings = settings;
        this.clock = clock;
        this.client = client;
        this.profileIndex = profileIndex;
        this.threadPool = threadPool;
    }

    public void getProfile(String uid, @Nullable Set<String> dataKeys, ActionListener<Profile> listener) {
        this.getVersionedDocument(uid, (ActionListener<VersionedDocument>)listener.map(versionedDocument -> versionedDocument != null ? versionedDocument.toProfile(null, dataKeys) : null));
    }

    public void activateProfile(Authentication authentication, ActionListener<Profile> listener) {
        Subject subject = AuthenticationContext.fromAuthentication((Authentication)authentication).getEffectiveSubject();
        if (Subject.Type.USER != subject.getType()) {
            listener.onFailure((Exception)new IllegalArgumentException("profile is supported for user only, but subject is a [" + subject.getType().name().toLowerCase(Locale.ROOT) + "]"));
            return;
        }
        if (User.isInternal((User)subject.getUser())) {
            listener.onFailure((Exception)new IllegalStateException("profile should not be created for internal user [" + subject.getUser().principal() + "]"));
            return;
        }
        this.getVersionedDocument(authentication, (ActionListener<VersionedDocument>)ActionListener.wrap(versionedDocument -> {
            if (versionedDocument == null) {
                this.createNewProfile(subject, listener);
            } else {
                this.updateProfileForActivate(subject, (VersionedDocument)versionedDocument, listener);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void updateProfileData(UpdateProfileDataRequest request, ActionListener<AcknowledgedResponse> listener) {
        XContentBuilder builder;
        try {
            builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.field("user_profile");
            builder.startObject();
            if (!request.getAccess().isEmpty()) {
                builder.field("access", request.getAccess());
            }
            if (!request.getData().isEmpty()) {
                builder.field("application_data", request.getData());
            }
            builder.endObject();
            builder.endObject();
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
            return;
        }
        this.doUpdate(this.buildUpdateRequest(request.getUid(), builder, request.getRefreshPolicy(), request.getIfPrimaryTerm(), request.getIfSeqNo()), (ActionListener<UpdateResponse>)listener.map(updateResponse -> AcknowledgedResponse.TRUE));
    }

    private void getVersionedDocument(String uid, ActionListener<VersionedDocument> listener) {
        this.tryFreezeAndCheckIndex(listener).ifPresent(frozenProfileIndex -> {
            GetRequest getRequest = new GetRequest(".security-profile", this.uidToDocId(uid));
            frozenProfileIndex.checkIndexVersionThenExecute(arg_0 -> ((ActionListener)listener).onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)GetAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)ActionListener.wrap(response -> {
                if (!response.isExists()) {
                    logger.debug("profile with uid [{}] does not exist", (Object)uid);
                    listener.onResponse(null);
                    return;
                }
                listener.onResponse((Object)new VersionedDocument(this.buildProfileDocument(response.getSourceAsBytesRef()), response.getPrimaryTerm(), response.getSeqNo()));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
        });
    }

    void getVersionedDocument(Authentication authentication, ActionListener<VersionedDocument> listener) {
        this.tryFreezeAndCheckIndex(listener).ifPresent(frozenProfileIndex -> {
            SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{".security-profile"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"user_profile.user.username", (String)authentication.getUser().principal())).must((QueryBuilder)QueryBuilders.termQuery((String)"user_profile.user.realm.name", (String)authentication.getSourceRealm().getName()))).request();
            frozenProfileIndex.checkIndexVersionThenExecute(arg_0 -> ((ActionListener)listener).onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
                SearchHits searchHits = searchResponse.getHits();
                SearchHit[] hits = searchHits.getHits();
                if (hits.length < 1) {
                    logger.debug("profile does not exist for username [{}] and realm name [{}]", (Object)authentication.getUser().principal(), (Object)authentication.getSourceRealm().getName());
                    listener.onResponse(null);
                } else if (hits.length == 1) {
                    SearchHit hit = hits[0];
                    listener.onResponse((Object)new VersionedDocument(this.buildProfileDocument(hit.getSourceRef()), hit.getPrimaryTerm(), hit.getSeqNo()));
                } else {
                    ParameterizedMessage errorMessage = new ParameterizedMessage("multiple [{}] profiles [{}] found for user [{}]", new Object[]{hits.length, Arrays.stream(hits).map(SearchHit::getId).map(this::docIdToUid).sorted().collect(Collectors.joining(",")), authentication.getUser().principal()});
                    logger.error((Message)errorMessage);
                    listener.onFailure((Exception)new ElasticsearchException(errorMessage.getFormattedMessage(), new Object[0]));
                }
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
        });
    }

    private void createNewProfile(Subject subject, ActionListener<Profile> listener) throws IOException {
        ProfileDocument profileDocument = ProfileDocument.fromSubject(subject);
        String docId = this.uidToDocId(profileDocument.uid());
        BulkRequest bulkRequest = TransportSingleItemBulkWriteAction.toSingleItemBulkRequest((ReplicatedWriteRequest)((ReplicatedWriteRequest)((IndexRequestBuilder)this.client.prepareIndex(".security-profile").setId(docId).setSource(this.wrapProfileDocument(profileDocument)).setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL)).request()));
        this.profileIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)BulkAction.INSTANCE, (ActionRequest)bulkRequest, (ActionListener)TransportSingleItemBulkWriteAction.wrapBulkResponse((ActionListener)ActionListener.wrap(indexResponse -> {
            assert (docId.equals(indexResponse.getId()));
            listener.onResponse((Object)new VersionedDocument(profileDocument, indexResponse.getPrimaryTerm(), indexResponse.getSeqNo()).toProfile(null));
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)))));
    }

    private void updateProfileForActivate(Subject subject, VersionedDocument versionedDocument, ActionListener<Profile> listener) throws IOException {
        ProfileDocument profileDocument = this.updateWithSubject(versionedDocument.doc, subject);
        this.doUpdate(this.buildUpdateRequest(profileDocument.uid(), this.wrapProfileDocumentWithoutApplicationData(profileDocument), WriteRequest.RefreshPolicy.WAIT_UNTIL, versionedDocument.primaryTerm, versionedDocument.seqNo), (ActionListener<UpdateResponse>)listener.map(updateResponse -> new VersionedDocument(profileDocument, updateResponse.getPrimaryTerm(), updateResponse.getSeqNo()).toProfile(null)));
    }

    private UpdateRequest buildUpdateRequest(String uid, XContentBuilder builder, WriteRequest.RefreshPolicy refreshPolicy, long ifPrimaryTerm, long ifSeqNo) {
        String docId = this.uidToDocId(uid);
        UpdateRequestBuilder updateRequestBuilder = (UpdateRequestBuilder)this.client.prepareUpdate(".security-profile", docId).setDoc(builder).setRefreshPolicy(refreshPolicy);
        if (ifPrimaryTerm >= 0L) {
            updateRequestBuilder.setIfPrimaryTerm(ifPrimaryTerm);
        }
        if (ifSeqNo >= 0L) {
            updateRequestBuilder.setIfSeqNo(ifSeqNo);
        }
        return (UpdateRequest)updateRequestBuilder.request();
    }

    private void doUpdate(UpdateRequest updateRequest, ActionListener<UpdateResponse> listener) {
        this.profileIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)UpdateAction.INSTANCE, (ActionRequest)updateRequest, (ActionListener)ActionListener.wrap(updateResponse -> {
            assert (updateResponse.getResult() == DocWriteResponse.Result.UPDATED || updateResponse.getResult() == DocWriteResponse.Result.NOOP);
            listener.onResponse(updateResponse);
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
    }

    private String uidToDocId(String uid) {
        return DOC_ID_PREFIX + uid;
    }

    private String docIdToUid(String docId) {
        if (docId == null || !docId.startsWith(DOC_ID_PREFIX)) {
            throw new IllegalStateException("profile document ID [" + docId + "] has unexpected value");
        }
        return docId.substring(DOC_ID_PREFIX.length());
    }

    ProfileDocument buildProfileDocument(BytesReference source) throws IOException {
        if (source == null) {
            throw new IllegalStateException("profile document did not have source but source should have been fetched");
        }
        try (XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)XContentType.JSON);){
            ProfileDocument profileDocument = ProfileDocument.fromXContent(parser);
            return profileDocument;
        }
    }

    private XContentBuilder wrapProfileDocument(ProfileDocument profileDocument) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.field("user_profile", (ToXContent)profileDocument);
        builder.endObject();
        return builder;
    }

    private XContentBuilder wrapProfileDocumentWithoutApplicationData(ProfileDocument profileDocument) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.field("user_profile", (ToXContent)profileDocument, (ToXContent.Params)new ToXContent.MapParams(Map.of("include_access", Boolean.FALSE.toString(), "include_data", Boolean.FALSE.toString())));
        builder.endObject();
        return builder;
    }

    private <T> Optional<SecurityIndexManager> tryFreezeAndCheckIndex(ActionListener<T> listener) {
        SecurityIndexManager frozenProfileIndex = this.profileIndex.freeze();
        if (!frozenProfileIndex.indexExists()) {
            logger.debug("profile index does not exist");
            listener.onResponse(null);
            return Optional.empty();
        }
        if (!frozenProfileIndex.isAvailable()) {
            listener.onFailure((Exception)frozenProfileIndex.getUnavailableReason());
            return Optional.empty();
        }
        return Optional.of(frozenProfileIndex);
    }

    private ProfileDocument updateWithSubject(ProfileDocument doc, Subject subject) {
        User subjectUser = subject.getUser();
        return new ProfileDocument(doc.uid(), true, Instant.now().toEpochMilli(), new ProfileDocument.ProfileDocumentUser(subjectUser.principal(), Arrays.asList(subjectUser.roles()), subject.getRealm(), subjectUser.email(), subjectUser.fullName(), doc.user().displayName(), subjectUser.enabled()), doc.access(), doc.applicationData());
    }

    record VersionedDocument(ProfileDocument doc, long primaryTerm, long seqNo) {
        Profile toProfile(@Nullable String realmDomain) {
            return this.toProfile(realmDomain, Set.of());
        }

        Profile toProfile(@Nullable String realmDomain, @Nullable Set<String> dataKeys) {
            Map applicationData = dataKeys == null || dataKeys.isEmpty() ? Map.of() : (Map)XContentHelper.convertToMap((BytesReference)this.doc.applicationData(), (boolean)false, (XContentType)XContentType.JSON, dataKeys, null).v2();
            return new Profile(this.doc.uid(), this.doc.enabled(), this.doc.lastSynchronized(), this.doc.user().toProfileUser(realmDomain), this.doc.access(), applicationData, new Profile.VersionControl(this.primaryTerm, this.seqNo));
        }
    }
}

