/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.profile;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ObjectParserHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.profile.Profile;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.user.User;

public record ProfileDocument(String uid, boolean enabled, long lastSynchronized, ProfileDocumentUser user, Map<String, Object> access, BytesReference applicationData) implements ToXContentObject
{
    static final ConstructingObjectParser<ProfileDocumentUser, Void> PROFILE_DOC_USER_PARSER = new ConstructingObjectParser("user_profile_document_user", false, (args, v) -> new ProfileDocumentUser((String)args[0], (List)args[1], (Authentication.RealmRef)args[2], (String)args[3], (String)args[4], (String)args[5], (Boolean)args[6]));
    static final ConstructingObjectParser<ProfileDocument, Void> PROFILE_DOC_PARSER = new ConstructingObjectParser("user_profile_document", false, (args, v) -> new ProfileDocument((String)args[0], (Boolean)args[1], (Long)args[2], (ProfileDocumentUser)args[3], (Map)args[4], (BytesReference)args[5]));
    static final ConstructingObjectParser<ProfileDocument, Void> PARSER = new ConstructingObjectParser("user_profile_document_container", true, (args, v) -> (ProfileDocument)args[0]);
    public static ConstructingObjectParser<Authentication.RealmRef, Void> REALM_REF_PARSER = new ConstructingObjectParser("realm_ref", true, (args, v) -> new Authentication.RealmRef((String)args[0], (String)args[1], (String)args[2]));

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("uid", this.uid);
        builder.field("enabled", this.enabled);
        builder.field("last_synchronized", this.lastSynchronized);
        this.user.toXContent(builder, params);
        if (params.paramAsBoolean("include_access", true) && this.access != null) {
            builder.field("access", this.access);
        } else {
            builder.startObject("access").endObject();
        }
        if (params.paramAsBoolean("include_data", true) && this.applicationData != null) {
            builder.field("application_data", (ToXContent)this.applicationData);
        } else {
            builder.startObject("application_data").endObject();
        }
        builder.endObject();
        return builder;
    }

    static ProfileDocument fromSubject(Subject subject) {
        String uid = "u_" + UUIDs.randomBase64UUID();
        User subjectUser = subject.getUser();
        return new ProfileDocument(uid, true, Instant.now().toEpochMilli(), new ProfileDocumentUser(subjectUser.principal(), Arrays.asList(subjectUser.roles()), subject.getRealm(), subjectUser.email(), subjectUser.fullName(), null, subjectUser.enabled()), Map.of(), null);
    }

    public static ProfileDocument fromXContent(XContentParser parser) {
        return (ProfileDocument)PARSER.apply(parser, null);
    }

    static {
        REALM_REF_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        REALM_REF_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
        REALM_REF_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("node_name", new String[0]));
        PROFILE_DOC_USER_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("username", new String[0]));
        PROFILE_DOC_USER_PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("roles", new String[0]));
        PROFILE_DOC_USER_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> (Authentication.RealmRef)REALM_REF_PARSER.parse(p, null), new ParseField("realm", new String[0]));
        PROFILE_DOC_USER_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("email", new String[0]));
        PROFILE_DOC_USER_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("full_name", new String[0]));
        PROFILE_DOC_USER_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("display_name", new String[0]));
        PROFILE_DOC_USER_PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("active", new String[0]));
        PROFILE_DOC_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("uid", new String[0]));
        PROFILE_DOC_PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("enabled", new String[0]));
        PROFILE_DOC_PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("last_synchronized", new String[0]));
        PROFILE_DOC_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> (ProfileDocumentUser)PROFILE_DOC_USER_PARSER.parse(p, null), new ParseField("user", new String[0]));
        PROFILE_DOC_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), new ParseField("access", new String[0]));
        ObjectParserHelper parserHelper = new ObjectParserHelper();
        parserHelper.declareRawObject(PROFILE_DOC_PARSER, ConstructingObjectParser.constructorArg(), new ParseField("application_data", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> (ProfileDocument)PROFILE_DOC_PARSER.parse(p, null), new ParseField("user_profile", new String[0]));
    }

    public record ProfileDocumentUser(String username, List<String> roles, Authentication.RealmRef realm, String email, String fullName, String displayName, boolean active) implements ToXContent
    {
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("user");
            builder.field("username", this.username);
            builder.field("roles", this.roles);
            builder.startObject("realm");
            builder.field("name", this.realm.getName());
            builder.field("type", this.realm.getType());
            builder.field("node_name", this.realm.getNodeName());
            builder.endObject();
            if (this.email != null) {
                builder.field("email", this.email);
            }
            if (this.fullName != null) {
                builder.field("full_name", this.fullName);
            }
            if (this.displayName != null) {
                builder.field("display_name", this.displayName);
            }
            builder.field("active", this.active);
            builder.endObject();
            return builder;
        }

        public Profile.ProfileUser toProfileUser(@Nullable String realmDomain) {
            return new Profile.ProfileUser(this.username, this.roles, this.realm.getName(), realmDomain, this.email, this.fullName, this.displayName, this.active);
        }
    }
}

