/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.enrollment.tool;

import java.nio.file.Path;
import joptsimple.OptionSet;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.cli.KeyStoreAwareCommand;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.security.authc.esnative.ReservedRealm;
import org.elasticsearch.xpack.security.tool.CommandUtils;

public class AutoConfigGenerateElasticPasswordHash
extends KeyStoreAwareCommand {
    public AutoConfigGenerateElasticPasswordHash() {
        super("Generates a password hash for for the elastic user and stores it in elasticsearch.keystore");
    }

    public static void main(String[] args) throws Exception {
        AutoConfigGenerateElasticPasswordHash.exit((int)new AutoConfigGenerateElasticPasswordHash().main(args, Terminal.DEFAULT));
    }

    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        Hasher hasher = Hasher.resolve((String)((String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(env.settings())));
        try (SecureString elasticPassword = new SecureString(CommandUtils.generatePassword(20));
             KeyStoreWrapper nodeKeystore = KeyStoreWrapper.bootstrap((Path)env.configFile(), () -> new SecureString(new char[0]));){
            nodeKeystore.setString(ReservedRealm.AUTOCONFIG_ELASTIC_PASSWORD_HASH.getKey(), hasher.hash(elasticPassword));
            nodeKeystore.save(env.configFile(), new char[0]);
            terminal.print(Terminal.Verbosity.NORMAL, elasticPassword.toString());
        }
        catch (Exception e) {
            throw new UserException(73, "Failed to generate a password for the elastic user", (Throwable)e);
        }
    }
}

