/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.common.IteratingActionListener;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.core.security.authz.store.RoleReference;
import org.elasticsearch.xpack.core.security.authz.store.RoleReferenceResolver;
import org.elasticsearch.xpack.core.security.authz.store.RoleRetrievalResult;
import org.elasticsearch.xpack.core.security.authz.store.RolesRetrievalResult;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountService;
import org.elasticsearch.xpack.security.authz.store.RoleProviders;

public class RoleDescriptorStore
implements RoleReferenceResolver {
    private static final Logger logger = LogManager.getLogger(RoleDescriptorStore.class);
    private final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RoleDescriptorStore.class);
    private final RoleProviders roleProviders;
    private final ApiKeyService apiKeyService;
    private final ServiceAccountService serviceAccountService;
    private final XPackLicenseState licenseState;
    private final ThreadContext threadContext;
    private final Consumer<Collection<RoleDescriptor>> effectiveRoleDescriptorsConsumer;
    private final Cache<String, Boolean> negativeLookupCache;

    public RoleDescriptorStore(RoleProviders roleProviders, ApiKeyService apiKeyService, ServiceAccountService serviceAccountService, Cache<String, Boolean> negativeLookupCache, XPackLicenseState licenseState, ThreadContext threadContext, Consumer<Collection<RoleDescriptor>> effectiveRoleDescriptorsConsumer) {
        this.roleProviders = roleProviders;
        this.apiKeyService = Objects.requireNonNull(apiKeyService);
        this.serviceAccountService = Objects.requireNonNull(serviceAccountService);
        this.licenseState = Objects.requireNonNull(licenseState);
        this.threadContext = threadContext;
        this.effectiveRoleDescriptorsConsumer = Objects.requireNonNull(effectiveRoleDescriptorsConsumer);
        this.negativeLookupCache = negativeLookupCache;
    }

    public void resolveNamedRoleReference(RoleReference.NamedRoleReference namedRoleReference, ActionListener<RolesRetrievalResult> listener) {
        Set<String> roleNames = Set.copyOf(new HashSet<String>(List.of(namedRoleReference.getRoleNames())));
        if (roleNames.isEmpty()) {
            listener.onResponse((Object)RolesRetrievalResult.EMPTY);
        } else if (roleNames.equals(Set.of(ReservedRolesStore.SUPERUSER_ROLE_DESCRIPTOR.getName()))) {
            listener.onResponse((Object)RolesRetrievalResult.SUPERUSER);
        } else {
            this.resolveRoleNames(roleNames, listener);
        }
    }

    public void resolveApiKeyRoleReference(RoleReference.ApiKeyRoleReference apiKeyRoleReference, ActionListener<RolesRetrievalResult> listener) {
        List<RoleDescriptor> roleDescriptors = this.apiKeyService.parseRoleDescriptorsBytes(apiKeyRoleReference.getApiKeyId(), apiKeyRoleReference.getRoleDescriptorsBytes(), apiKeyRoleReference.getRoleType());
        RolesRetrievalResult rolesRetrievalResult = new RolesRetrievalResult();
        rolesRetrievalResult.addDescriptors(Set.copyOf(roleDescriptors));
        listener.onResponse((Object)rolesRetrievalResult);
    }

    public void resolveBwcApiKeyRoleReference(RoleReference.BwcApiKeyRoleReference bwcApiKeyRoleReference, ActionListener<RolesRetrievalResult> listener) {
        List<RoleDescriptor> roleDescriptors = this.apiKeyService.parseRoleDescriptors(bwcApiKeyRoleReference.getApiKeyId(), bwcApiKeyRoleReference.getRoleDescriptorsMap(), bwcApiKeyRoleReference.getRoleType());
        RolesRetrievalResult rolesRetrievalResult = new RolesRetrievalResult();
        rolesRetrievalResult.addDescriptors(Set.copyOf(roleDescriptors));
        listener.onResponse((Object)rolesRetrievalResult);
    }

    public void resolveServiceAccountRoleReference(RoleReference.ServiceAccountRoleReference roleReference, ActionListener<RolesRetrievalResult> listener) {
        this.serviceAccountService.getRoleDescriptorForPrincipal(roleReference.getPrincipal(), (ActionListener<RoleDescriptor>)listener.map(roleDescriptor -> {
            RolesRetrievalResult rolesRetrievalResult = new RolesRetrievalResult();
            rolesRetrievalResult.addDescriptors(Set.of(roleDescriptor));
            return rolesRetrievalResult;
        }));
    }

    private void resolveRoleNames(Set<String> roleNames, ActionListener<RolesRetrievalResult> listener) {
        this.roleDescriptors(roleNames, (ActionListener<RolesRetrievalResult>)ActionListener.wrap(rolesRetrievalResult -> {
            Set roleDescriptors;
            boolean missingRoles;
            this.logDeprecatedRoles(rolesRetrievalResult.getRoleDescriptors());
            boolean bl = missingRoles = !rolesRetrievalResult.getMissingRoles().isEmpty();
            if (missingRoles) {
                logger.debug(() -> new ParameterizedMessage("Could not find roles with names {}", (Object)rolesRetrievalResult.getMissingRoles()));
            }
            Set effectiveDescriptors = (roleDescriptors = rolesRetrievalResult.getRoleDescriptors()).stream().anyMatch(RoleDescriptor::isUsingDocumentOrFieldLevelSecurity) && !SecurityField.DOCUMENT_LEVEL_SECURITY_FEATURE.checkWithoutTracking(this.licenseState) ? roleDescriptors.stream().filter(Predicate.not(RoleDescriptor::isUsingDocumentOrFieldLevelSecurity)).collect(Collectors.toSet()) : roleDescriptors;
            logger.trace(() -> new ParameterizedMessage("Exposing effective role descriptors [{}] for role names [{}]", (Object)effectiveDescriptors, (Object)roleNames));
            this.effectiveRoleDescriptorsConsumer.accept(Collections.unmodifiableCollection(effectiveDescriptors));
            RolesRetrievalResult finalResult = new RolesRetrievalResult();
            finalResult.addDescriptors(effectiveDescriptors);
            finalResult.setMissingRoles(rolesRetrievalResult.getMissingRoles());
            if (!rolesRetrievalResult.isSuccess()) {
                finalResult.setFailure();
            }
            listener.onResponse((Object)finalResult);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void roleDescriptors(Set<String> roleNames, ActionListener<RolesRetrievalResult> rolesResultListener) {
        Set<String> filteredRoleNames = roleNames.stream().filter(s -> {
            if (this.negativeLookupCache.get(s) != null) {
                logger.debug(() -> new ParameterizedMessage("Requested role [{}] does not exist (cached)", s));
                return false;
            }
            return true;
        }).collect(Collectors.toSet());
        this.loadRoleDescriptorsAsync(filteredRoleNames, rolesResultListener);
    }

    void logDeprecatedRoles(Set<RoleDescriptor> roleDescriptors) {
        roleDescriptors.stream().filter(rd -> Boolean.TRUE.equals(rd.getMetadata().get("_deprecated"))).forEach(rd -> {
            String reason = Objects.toString(rd.getMetadata().get("_deprecated_reason"), "Please check the documentation");
            this.deprecationLogger.critical(DeprecationCategory.SECURITY, "deprecated_role-" + rd.getName(), "The role [" + rd.getName() + "] is deprecated and will be removed in a future version of Elasticsearch. " + reason, new Object[0]);
        });
    }

    private void loadRoleDescriptorsAsync(Set<String> roleNames, ActionListener<RolesRetrievalResult> listener) {
        RolesRetrievalResult rolesResult = new RolesRetrievalResult();
        List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>> asyncRoleProviders = this.roleProviders.getProviders();
        ContextPreservingActionListener descriptorsListener = ContextPreservingActionListener.wrapPreservingContext((ActionListener)ActionListener.wrap(ignore -> {
            rolesResult.setMissingRoles(roleNames);
            listener.onResponse((Object)rolesResult);
        }, arg_0 -> listener.onFailure(arg_0)), (ThreadContext)this.threadContext);
        Predicate<RoleRetrievalResult> iterationPredicate = result -> !roleNames.isEmpty();
        new IteratingActionListener((ActionListener)descriptorsListener, (rolesProvider, providerListener) -> rolesProvider.accept(roleNames, ActionListener.wrap(result -> {
            if (result.isSuccess()) {
                logger.debug(() -> new ParameterizedMessage("Roles [{}] were resolved by [{}]", (Object)result.getDescriptors().stream().map(RoleDescriptor::getName).collect(Collectors.joining(",")), rolesProvider));
                Set resolvedDescriptors = result.getDescriptors();
                rolesResult.addDescriptors(resolvedDescriptors);
                for (RoleDescriptor descriptor : resolvedDescriptors) {
                    roleNames.remove(descriptor.getName());
                }
            } else {
                logger.warn((Message)new ParameterizedMessage("role [{}] retrieval failed from [{}]", (Object)roleNames, rolesProvider), (Throwable)result.getFailure());
                rolesResult.setFailure();
            }
            providerListener.onResponse(result);
        }, arg_0 -> ((ActionListener)providerListener).onFailure(arg_0))), asyncRoleProviders, this.threadContext, Function.identity(), iterationPredicate).run();
    }
}

