/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.ClaimSetting;

public final class ClaimParser {
    private final String name;
    private final Function<JWTClaimsSet, List<String>> parser;

    public ClaimParser(String name, Function<JWTClaimsSet, List<String>> parser) {
        this.name = name;
        this.parser = parser;
    }

    public String getName() {
        return this.name;
    }

    public Function<JWTClaimsSet, List<String>> getParser() {
        return this.parser;
    }

    public List<String> getClaimValues(JWTClaimsSet claims) {
        return this.parser.apply(claims);
    }

    public String getClaimValue(JWTClaimsSet claims) {
        List<String> claimValues = this.parser.apply(claims);
        if (claimValues == null || claimValues.isEmpty()) {
            return null;
        }
        return claimValues.get(0);
    }

    public String toString() {
        return this.name;
    }

    private static Collection<String> parseClaimValues(JWTClaimsSet claimsSet, String claimName, String settingKey) {
        Collection<String> values;
        Object claimValueObject = claimsSet.getClaim(claimName);
        if (claimValueObject == null) {
            values = List.of();
        } else if (claimValueObject instanceof String) {
            values = List.of((String)claimValueObject);
        } else if (claimValueObject instanceof Collection && ((Collection)claimValueObject).stream().allMatch(c -> c instanceof String)) {
            values = (Collection)claimValueObject;
        } else {
            throw new SettingsException("Setting [ " + settingKey + " expects a claim with String or a String Array value");
        }
        return values;
    }

    public static ClaimParser forSetting(Logger logger, ClaimSetting setting, RealmConfig realmConfig, boolean required) {
        if (realmConfig.hasSetting(setting.getClaim())) {
            String claimName = (String)realmConfig.getSetting(setting.getClaim());
            if (realmConfig.hasSetting(setting.getPattern())) {
                Pattern regex = Pattern.compile((String)realmConfig.getSetting(setting.getPattern()));
                return new ClaimParser("Claim [" + claimName + "] with pattern [" + regex.pattern() + "] for [" + setting.name(realmConfig) + "]", claims -> {
                    Collection<String> values = ClaimParser.parseClaimValues(claims, claimName, RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getClaim()));
                    return values.stream().map(s -> {
                        if (s == null) {
                            logger.debug("Claim [{}] is null", (Object)claimName);
                            return null;
                        }
                        Matcher matcher = regex.matcher((CharSequence)s);
                        if (!matcher.find()) {
                            logger.debug("Claim [{}] is [{}], which does not match [{}]", (Object)claimName, s, (Object)regex.pattern());
                            return null;
                        }
                        String value = matcher.group(1);
                        if (Strings.isNullOrEmpty((String)value)) {
                            logger.debug("Claim [{}] is [{}], which does match [{}] but group(1) is empty", (Object)claimName, s, (Object)regex.pattern());
                            return null;
                        }
                        return value;
                    }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
                });
            }
            return new ClaimParser("Claim [" + claimName + "] for [" + setting.name(realmConfig) + "]", claims -> ClaimParser.parseClaimValues(claims, claimName, RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getClaim())).stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableList()));
        }
        if (required) {
            throw new SettingsException("Setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getClaim()) + "] is required");
        }
        if (realmConfig.hasSetting(setting.getPattern())) {
            throw new SettingsException("Setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getPattern()) + "] cannot be set unless [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getClaim()) + "] is also set");
        }
        return new ClaimParser("No Claim for [" + setting.name(realmConfig) + "]", attributes -> List.of());
    }
}

