/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.util.Collection;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationContext;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.support.DLSRoleQueryValidator;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public class ApiKeyGenerator {
    private final ApiKeyService apiKeyService;
    private final CompositeRolesStore rolesStore;
    private final NamedXContentRegistry xContentRegistry;

    public ApiKeyGenerator(ApiKeyService apiKeyService, CompositeRolesStore rolesStore, NamedXContentRegistry xContentRegistry) {
        this.apiKeyService = apiKeyService;
        this.rolesStore = rolesStore;
        this.xContentRegistry = xContentRegistry;
    }

    public void generateApiKey(Authentication authentication, CreateApiKeyRequest request, ActionListener<CreateApiKeyResponse> listener) {
        if (authentication == null) {
            listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("no authentication available to generate API key", new Object[0])));
            return;
        }
        this.apiKeyService.ensureEnabled();
        ActionListener roleDescriptorsListener = ActionListener.wrap(roleDescriptors -> {
            for (RoleDescriptor rd : roleDescriptors) {
                try {
                    DLSRoleQueryValidator.validateQueryField((RoleDescriptor.IndicesPrivileges[])rd.getIndicesPrivileges(), (NamedXContentRegistry)this.xContentRegistry);
                }
                catch (IllegalArgumentException | ElasticsearchException e) {
                    listener.onFailure((Exception)e);
                    return;
                }
            }
            this.apiKeyService.createApiKey(authentication, request, (Set<RoleDescriptor>)roleDescriptors, listener);
        }, arg_0 -> listener.onFailure(arg_0));
        Subject effectiveSubject = AuthenticationContext.fromAuthentication((Authentication)authentication).getEffectiveSubject();
        if (effectiveSubject.getType() == Subject.Type.API_KEY) {
            roleDescriptorsListener.onResponse(Set.of());
            return;
        }
        this.rolesStore.getRoleDescriptorsList(effectiveSubject, (ActionListener<Collection<Set<RoleDescriptor>>>)ActionListener.wrap(roleDescriptorsList -> {
            assert (roleDescriptorsList.size() == 1);
            roleDescriptorsListener.onResponse((Object)((Set)roleDescriptorsList.iterator().next()));
        }, arg_0 -> ((ActionListener)roleDescriptorsListener).onFailure(arg_0)));
    }
}

