/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.auth.Secret;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.Environment;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.jwt.JwtRealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.jwt.JwtAuthenticationToken;
import org.elasticsearch.xpack.security.authc.support.ClaimParser;
import org.elasticsearch.xpack.security.authc.support.DelegatedAuthorizationSupport;

public class JwtRealm
extends Realm
implements CachingRealm,
Releasable {
    private static final Logger LOGGER = LogManager.getLogger(JwtRealm.class);
    private final ThreadPool threadPool;
    private final SSLService sslService;
    private final UserRoleMapper userRoleMapper;
    private final ResourceWatcherService resourceWatcherService;
    private final String allowedIssuer;
    private final List<String> allowedSignatureAlgorithms;
    private final TimeValue allowedClientSkew;
    private final String jwkSetPath;
    private final SecureString hmacSecretKey;
    private final List<String> allowedAudiences;
    private final Boolean populateUserMetadata;
    private final ClaimParser principalAttribute;
    private final ClaimParser groupsAttribute;
    private final String clientAuthorizationType;
    private final SecureString clientAuthorizationSharedSecret;
    private final TimeValue cacheTtl;
    private final Integer cacheMaxUsers;
    private final TimeValue httpConnectTimeout;
    private final TimeValue httpConnectionReadTimeout;
    private final TimeValue httpSocketTimeout;
    private final Integer httpMaxConnections;
    private final Integer httpMaxEndpointConnections;
    private final URL jwkSetPathUrl;
    private final Path jwkSetPathObj;
    private final Cache<String, ListenableFuture<CachedAuthenticationSuccess>> cachedAuthenticationSuccesses;
    private final Hasher hasher;
    private DelegatedAuthorizationSupport delegatedAuthorizationSupport;

    public JwtRealm(RealmConfig realmConfig, ThreadPool threadPool, SSLService sslService, UserRoleMapper userRoleMapper, ResourceWatcherService resourceWatcherService) {
        super(realmConfig);
        this.threadPool = threadPool;
        this.sslService = sslService;
        this.userRoleMapper = userRoleMapper;
        this.resourceWatcherService = resourceWatcherService;
        this.allowedIssuer = (String)realmConfig.getSetting(JwtRealmSettings.ALLOWED_ISSUER);
        this.allowedSignatureAlgorithms = (List)realmConfig.getSetting(JwtRealmSettings.ALLOWED_SIGNATURE_ALGORITHMS);
        this.allowedClientSkew = (TimeValue)realmConfig.getSetting(JwtRealmSettings.ALLOWED_CLOCK_SKEW);
        this.jwkSetPath = (String)realmConfig.getSetting(JwtRealmSettings.JWKSET_PATH);
        this.hmacSecretKey = (SecureString)realmConfig.getSetting(JwtRealmSettings.ISSUER_HMAC_SECRET_KEY);
        this.allowedAudiences = (List)realmConfig.getSetting(JwtRealmSettings.ALLOWED_AUDIENCES);
        this.principalAttribute = ClaimParser.forSetting(LOGGER, JwtRealmSettings.CLAIMS_PRINCIPAL, realmConfig, true);
        this.groupsAttribute = ClaimParser.forSetting(LOGGER, JwtRealmSettings.CLAIMS_GROUPS, realmConfig, false);
        this.populateUserMetadata = (Boolean)realmConfig.getSetting(JwtRealmSettings.POPULATE_USER_METADATA);
        this.clientAuthorizationType = (String)realmConfig.getSetting(JwtRealmSettings.CLIENT_AUTHORIZATION_TYPE);
        this.clientAuthorizationSharedSecret = (SecureString)realmConfig.getSetting(JwtRealmSettings.CLIENT_AUTHORIZATION_SHARED_SECRET);
        this.cacheTtl = (TimeValue)realmConfig.getSetting(JwtRealmSettings.CACHE_TTL);
        this.cacheMaxUsers = (Integer)realmConfig.getSetting(JwtRealmSettings.CACHE_MAX_USERS);
        String cacheHashAlgo = (String)realmConfig.getSetting(JwtRealmSettings.CACHE_HASH_ALGO);
        this.httpConnectTimeout = (TimeValue)realmConfig.getSetting(JwtRealmSettings.HTTP_CONNECT_TIMEOUT);
        this.httpConnectionReadTimeout = (TimeValue)realmConfig.getSetting(JwtRealmSettings.HTTP_CONNECTION_READ_TIMEOUT);
        this.httpSocketTimeout = (TimeValue)realmConfig.getSetting(JwtRealmSettings.HTTP_SOCKET_TIMEOUT);
        this.httpMaxConnections = (Integer)realmConfig.getSetting(JwtRealmSettings.HTTP_MAX_CONNECTIONS);
        this.httpMaxEndpointConnections = (Integer)realmConfig.getSetting(JwtRealmSettings.HTTP_MAX_ENDPOINT_CONNECTIONS);
        this.cachedAuthenticationSuccesses = this.cacheTtl.getNanos() > 0L ? CacheBuilder.builder().setExpireAfterWrite(this.cacheTtl).setMaximumWeight((long)this.cacheMaxUsers.intValue()).build() : null;
        this.hasher = Hasher.resolve((String)cacheHashAlgo);
        JwtRealm.validateClientAuthorizationSettings(this.clientAuthorizationType, this.clientAuthorizationSharedSecret, this.config);
        Tuple<URL, Path> urlOrPath = JwtRealm.validateJwkSetPathSetting(realmConfig, this.jwkSetPath);
        this.jwkSetPathUrl = urlOrPath == null ? null : (URL)urlOrPath.v1();
        this.jwkSetPathObj = urlOrPath == null ? null : (Path)urlOrPath.v2();
        JwtRealm.validateIssuerCredentialSettings(this.config, this.hmacSecretKey, this.jwkSetPath, this.allowedSignatureAlgorithms);
    }

    public static void validateClientAuthorizationSettings(String clientAuthorizationType, SecureString clientAuthorizationSharedSecret, RealmConfig realmConfig) throws SettingsException {
        switch (clientAuthorizationType) {
            case "SharedSecret": {
                if (Strings.hasText((CharSequence)clientAuthorizationSharedSecret)) break;
                throw new SettingsException("Missing setting for [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.CLIENT_AUTHORIZATION_SHARED_SECRET) + "]. It is required when setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.CLIENT_AUTHORIZATION_TYPE) + "] is [SharedSecret]");
            }
            default: {
                if (!Strings.hasText((CharSequence)clientAuthorizationSharedSecret)) break;
                throw new SettingsException("Setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.CLIENT_AUTHORIZATION_SHARED_SECRET) + "] is not supported, because setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.CLIENT_AUTHORIZATION_TYPE) + "] is [None]");
            }
        }
    }

    public static void validateIssuerCredentialSettings(RealmConfig realmConfig, SecureString hmacSecretKey, String jwkSetPath, List<String> allowedSignatureAlgorithms) throws SettingsException {
        boolean hasHmacSecretKey = Strings.hasText((CharSequence)hmacSecretKey);
        boolean hasJwkSetPath = Strings.hasText((String)jwkSetPath);
        if (!hasHmacSecretKey && !hasJwkSetPath) {
            throw new SettingsException("At least one setting is required for [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.ISSUER_HMAC_SECRET_KEY) + "] or [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.JWKSET_PATH) + "]");
        }
        if (hasHmacSecretKey) {
            try {
                Secret decodedHmacSecretKeyBytes = new Secret(hmacSecretKey.toString());
                Arrays.fill(decodedHmacSecretKeyBytes.getValueBytes(), (byte)0);
            }
            catch (Exception e) {
                throw new SettingsException("Validation failed for setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.ISSUER_HMAC_SECRET_KEY) + "]", (Throwable)e);
            }
        }
        boolean anySecretKeySignatureAlgorithms = allowedSignatureAlgorithms.stream().anyMatch(JwtRealmSettings.SUPPORTED_SECRET_KEY_SIGNATURE_ALGORITHMS::contains);
        if (hasHmacSecretKey && !anySecretKeySignatureAlgorithms) {
            throw new SettingsException("Issuer HMAC Secret Key is configured in setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.ISSUER_HMAC_SECRET_KEY) + "], but no HMAC signature algorithms were found in setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.ALLOWED_SIGNATURE_ALGORITHMS) + "]");
        }
        if (anySecretKeySignatureAlgorithms && !hasHmacSecretKey) {
            throw new SettingsException("HMAC signature algorithms were found in setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.ALLOWED_SIGNATURE_ALGORITHMS) + "], but no Issuer HMAC Secret Key is configured in setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.JWKSET_PATH) + "]");
        }
        boolean anyPublicKeySignatureAlgorithms = allowedSignatureAlgorithms.stream().anyMatch(JwtRealmSettings.SUPPORTED_PUBLIC_KEY_SIGNATURE_ALGORITHMS::contains);
        if (hasJwkSetPath && !anyPublicKeySignatureAlgorithms) {
            throw new SettingsException("JWT Set Path is configured in setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.JWKSET_PATH) + "], but no public key signature algorithms were found in setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.ALLOWED_SIGNATURE_ALGORITHMS) + "]");
        }
        if (anyPublicKeySignatureAlgorithms && !hasJwkSetPath) {
            throw new SettingsException("Public key signature algorithms were found in setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.ALLOWED_SIGNATURE_ALGORITHMS) + "], but no JWT Set Path is configured in setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.JWKSET_PATH) + "]");
        }
    }

    public static Tuple<URL, Path> validateJwkSetPathSetting(RealmConfig realmConfig, String jwkSetPath) {
        Exception urlException;
        if (!Strings.hasText((String)jwkSetPath)) {
            return null;
        }
        if (jwkSetPath.startsWith("https://")) {
            try {
                return new Tuple((Object)new URL(jwkSetPath), null);
            }
            catch (Exception e) {
                LOGGER.debug("HTTPS URL [" + jwkSetPath + "] parsing failed for setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.JWKSET_PATH) + "].", (Throwable)e);
                urlException = e;
            }
        } else {
            urlException = new Exception("Parse URL not attempted for [" + jwkSetPath + "] for setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.JWKSET_PATH) + "]. Only HTTPS URL or local file are supported.");
        }
        try {
            Environment environment = realmConfig.env();
            Path directoryPath = environment.configFile();
            Path filePath = directoryPath.resolve(jwkSetPath);
            String fileContents = Files.readString(filePath, StandardCharsets.UTF_8);
            if (!Strings.hasText((String)fileContents)) {
                throw new Exception("Empty file [" + jwkSetPath + "] for setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.JWKSET_PATH) + "].");
            }
            return new Tuple(null, (Object)filePath);
        }
        catch (Exception e) {
            Exception pathException = new Exception("Error loading local file [" + jwkSetPath + "] for setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.JWKSET_PATH) + "].", e);
            SettingsException settingsException = new SettingsException("Invalid value [" + jwkSetPath + "] for setting " + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.JWKSET_PATH));
            settingsException.addSuppressed((Throwable)urlException);
            settingsException.addSuppressed((Throwable)pathException);
            throw settingsException;
        }
    }

    public void initialize(Iterable<Realm> allRealms, XPackLicenseState xpackLicenseState) {
        if (this.delegatedAuthorizationSupport != null) {
            throw new IllegalStateException("Realm has already been initialized");
        }
        this.delegatedAuthorizationSupport = new DelegatedAuthorizationSupport(allRealms, this.config, xpackLicenseState);
    }

    private void ensureInitialized() {
        if (this.delegatedAuthorizationSupport == null) {
            throw new IllegalStateException("Realm has not been initialized");
        }
    }

    public boolean supports(AuthenticationToken jwtAuthenticationToken) {
        this.ensureInitialized();
        return jwtAuthenticationToken instanceof JwtAuthenticationToken;
    }

    public AuthenticationToken token(ThreadContext threadContext) {
        this.ensureInitialized();
        SecureString authorizationParameterValue = JwtRealm.getHeaderSchemeParameters(threadContext, "Authorization", "Bearer", false);
        if (authorizationParameterValue == null) {
            return null;
        }
        SecureString clientAuthorizationSharedSecretValue = JwtRealm.getHeaderSchemeParameters(threadContext, "X-Client-Authorization", "SharedSecret", true);
        return new JwtAuthenticationToken(authorizationParameterValue, clientAuthorizationSharedSecretValue);
    }

    public void authenticate(AuthenticationToken authenticationToken, ActionListener<AuthenticationResult<User>> listener) {
        block20: {
            block17: {
                String clientAuthorizationSharedSecretString;
                Map jwtClaimsMap;
                List<String> audiencesClaim;
                JWTClaimsSet jwtClaimsSet;
                JWSHeader jwsHeader;
                String tokenPrincipal;
                block19: {
                    block18: {
                        this.ensureInitialized();
                        if (!(authenticationToken instanceof JwtAuthenticationToken)) break block17;
                        JwtAuthenticationToken jwtAuthenticationToken = (JwtAuthenticationToken)authenticationToken;
                        tokenPrincipal = jwtAuthenticationToken.principal();
                        LOGGER.trace("Realm [{}] received JwtAuthenticationToken for tokenPrincipal [{}].", (Object)super.name(), (Object)tokenPrincipal);
                        jwsHeader = jwtAuthenticationToken.getJwsHeader();
                        jwtClaimsSet = jwtAuthenticationToken.getJwtClaimsSet();
                        String issuerClaim = jwtAuthenticationToken.getIssuerClaim();
                        audiencesClaim = jwtAuthenticationToken.getAudiencesClaim();
                        jwtClaimsMap = jwtClaimsSet.getClaims();
                        SecureString clientAuthorizationSharedSecret = jwtAuthenticationToken.getClientAuthorizationSharedSecret();
                        String string = clientAuthorizationSharedSecretString = clientAuthorizationSharedSecret == null ? null : clientAuthorizationSharedSecret.toString();
                        if (issuerClaim == null || !this.allowedIssuer.equals(issuerClaim)) {
                            String msg = String.format(Locale.ROOT, "Realm [%s] did not allow issuer [%s] for tokenPrincipal [%s]. Allowed issuer is [%s].", super.name(), issuerClaim, tokenPrincipal, this.allowedIssuer);
                            LOGGER.debug(msg);
                            listener.onResponse((Object)AuthenticationResult.unsuccessful((String)msg, null));
                            return;
                        }
                        LOGGER.trace("Realm [{}] allowed issuer [{}] for tokenPrincipal [{}]. Allowed issuer is [{}].", (Object)super.name(), (Object)issuerClaim, (Object)tokenPrincipal, (Object)this.allowedIssuer);
                        if (audiencesClaim == null) break block18;
                        if (this.allowedAudiences.stream().anyMatch(audiencesClaim::contains)) break block19;
                    }
                    String msg = String.format(Locale.ROOT, "Realm [%s] did not allow audiences [%s] for tokenPrincipal [%s]. Allowed audiences are [%s].", super.name(), audiencesClaim == null ? "null" : String.join((CharSequence)",", audiencesClaim), tokenPrincipal, String.join((CharSequence)",", this.allowedAudiences));
                    LOGGER.debug(msg);
                    listener.onResponse((Object)AuthenticationResult.unsuccessful((String)msg, null));
                    return;
                }
                LOGGER.trace("Realm [{}] allowed at least one audience [{}] for tokenPrincipal [{}]. Allowed audiences are [{}].", (Object)super.name(), (Object)String.join((CharSequence)",", audiencesClaim), (Object)tokenPrincipal, (Object)String.join((CharSequence)",", this.allowedAudiences));
                JWSAlgorithm jwsSignatureAlgorithm = jwsHeader.getAlgorithm();
                if (jwsSignatureAlgorithm == null || !this.allowedSignatureAlgorithms.contains(jwsSignatureAlgorithm.getName())) {
                    String msg = String.format(Locale.ROOT, "Realm [%s] did not allow signature algorithm [%s] for tokenPrincipal [%s]. Allowed signature algorithms are [%s].", super.name(), jwsSignatureAlgorithm, tokenPrincipal, String.join((CharSequence)",", this.allowedSignatureAlgorithms));
                    LOGGER.debug(msg);
                    listener.onResponse((Object)AuthenticationResult.unsuccessful((String)msg, null));
                    return;
                }
                LOGGER.trace("Realm [{}] allowed signature algorithm [{}] for tokenPrincipal [{}]. Allowed signature algorithms are [{}].", (Object)super.name(), (Object)jwsSignatureAlgorithm, (Object)tokenPrincipal, (Object)String.join((CharSequence)",", this.allowedSignatureAlgorithms));
                switch (this.clientAuthorizationType) {
                    case "SharedSecret": {
                        if (!Strings.hasText((String)clientAuthorizationSharedSecretString)) {
                            String msg = String.format(Locale.ROOT, "Realm [%s] client authentication [%s] failed for tokenPrincipal [%s] because request header is missing.", super.name(), this.clientAuthorizationType, tokenPrincipal);
                            LOGGER.debug(msg);
                            listener.onResponse((Object)AuthenticationResult.unsuccessful((String)msg, null));
                            return;
                        }
                        if (!this.clientAuthorizationSharedSecret.toString().equals(clientAuthorizationSharedSecretString)) {
                            String msg = String.format(Locale.ROOT, "Realm [%s] client authentication [%s] failed for tokenPrincipal [%s] because request header did not match.", super.name(), this.clientAuthorizationType, tokenPrincipal);
                            LOGGER.debug(msg);
                            listener.onResponse((Object)AuthenticationResult.unsuccessful((String)msg, null));
                            return;
                        }
                        LOGGER.trace("Realm [{}] client authentication [{}] succeeded for tokenPrincipal [{}] because request header matched.", (Object)super.name(), (Object)this.clientAuthorizationType, (Object)tokenPrincipal);
                        break;
                    }
                    default: {
                        if (Strings.hasText((String)clientAuthorizationSharedSecretString)) {
                            String msg = String.format(Locale.ROOT, "Realm [%s] client authentication [%s] failed for tokenPrincipal [%s] because request header is present.", super.name(), this.clientAuthorizationType, tokenPrincipal);
                            LOGGER.debug(msg);
                            listener.onResponse((Object)AuthenticationResult.unsuccessful((String)msg, null));
                            return;
                        }
                        LOGGER.trace("Realm [{}] client authentication [{}] succeeded for tokenPrincipal [{}] because request header is not present.", (Object)super.name(), (Object)this.clientAuthorizationType, (Object)tokenPrincipal);
                    }
                }
                String jwtPrincipal = this.principalAttribute.getClaimValue(jwtClaimsSet);
                String messageAboutPrincipalClaim = String.format(Locale.ROOT, "Realm [%s] got principal claim [%s] using parser [%s]. JWTClaimsSet is %s.", super.name(), jwtPrincipal, this.principalAttribute.getName(), jwtClaimsMap);
                if (jwtPrincipal == null) {
                    LOGGER.debug(messageAboutPrincipalClaim);
                    listener.onResponse((Object)AuthenticationResult.unsuccessful((String)messageAboutPrincipalClaim, null));
                    return;
                }
                LOGGER.trace(messageAboutPrincipalClaim);
                List<String> jwtGroups = this.groupsAttribute.getClaimValues(jwtClaimsSet);
                LOGGER.trace(String.format(Locale.ROOT, "Realm [%s] principal [%s] got groups [%s] using parser [%s]. JWTClaimsSet is %s.", super.name(), jwtPrincipal, jwtGroups == null ? "null" : String.join((CharSequence)",", jwtGroups), this.groupsAttribute.getName() == null ? "null" : this.groupsAttribute.getName(), jwtClaimsMap));
                String jwtDn = null;
                String jwtFullName = null;
                String jwtEmail = null;
                Map userMetadata = this.populateUserMetadata != false ? jwtClaimsMap : Map.of();
                LOGGER.trace(String.format(Locale.ROOT, "Realm [%s] principal [%s] populateUserMetadata [%s] got metadata [%s] from JWTClaimsSet.", super.name(), jwtPrincipal, this.populateUserMetadata, userMetadata));
                if (this.delegatedAuthorizationSupport.hasDelegation()) {
                    String delegatedAuthorizationSupportDetails = this.delegatedAuthorizationSupport.toString();
                    this.delegatedAuthorizationSupport.resolve(jwtPrincipal, (ActionListener<AuthenticationResult<User>>)ActionListener.wrap(authenticationResultUser -> {
                        assert (authenticationResultUser != null) : "JWT delegated authz should return a non-null AuthenticationResult<User>";
                        User user = (User)authenticationResultUser.getValue();
                        assert (user != null) : "JWT delegated authz should return a non-null User";
                        Object[] roles = user.roles();
                        assert (roles != null) : "JWT delegated authz should return non-null Roles";
                        LOGGER.debug(String.format(Locale.ROOT, "Realm [%s] principal [%s] got lookup roles [%s] via delegated authorization [%s]", super.name(), jwtPrincipal, Arrays.toString(roles), delegatedAuthorizationSupportDetails));
                        listener.onResponse(authenticationResultUser);
                    }, e -> {
                        LOGGER.debug(String.format(Locale.ROOT, "Realm [%s] principal [%s] failed to get lookup roles via delegated authorization [%s]", super.name(), jwtPrincipal, delegatedAuthorizationSupportDetails), (Throwable)e);
                        listener.onFailure(e);
                    }));
                    return;
                }
                UserRoleMapper.UserData userData = new UserRoleMapper.UserData(jwtPrincipal, jwtDn, jwtGroups, userMetadata, this.config);
                this.userRoleMapper.resolveRoles(userData, ActionListener.wrap(setOfRoles -> {
                    assert (setOfRoles != null) : "JWT role mapping should return non-null set of roles.";
                    Object[] roles = new TreeSet(setOfRoles).toArray(new String[setOfRoles.size()]);
                    LOGGER.debug(String.format(Locale.ROOT, "Realm [%s] principal [%s] dn [%s] groups [%s] metadata [%s] got mapped roles [%s].", super.name(), jwtPrincipal, jwtDn, jwtGroups == null ? "null" : String.join((CharSequence)",", jwtGroups), userMetadata, Arrays.toString(roles)));
                    User user = new User(jwtPrincipal, (String[])roles, jwtFullName, jwtEmail, userMetadata, true);
                    listener.onResponse((Object)AuthenticationResult.success((Object)user));
                }, e -> {
                    LOGGER.debug(String.format(Locale.ROOT, "Realm [%s] principal [%s] dn [%s] groups [%s] metadata [%s] failed to get mapped roles.", super.name(), jwtPrincipal, jwtDn, jwtGroups == null ? "null" : String.join((CharSequence)",", jwtGroups), userMetadata), (Throwable)e);
                    listener.onFailure(e);
                }));
                break block20;
            }
            String msg = String.format(Locale.ROOT, "Realm [%s] does not support AuthenticationToken [%s].", super.name(), authenticationToken == null ? "null" : authenticationToken.getClass().getCanonicalName());
            LOGGER.trace(msg);
            listener.onResponse((Object)AuthenticationResult.unsuccessful((String)msg, null));
        }
    }

    public void expire(String username) {
        this.ensureInitialized();
        if (this.cachedAuthenticationSuccesses != null) {
            LOGGER.trace("invalidating cache for user [{}] in realm [{}]", (Object)username, (Object)this.name());
            this.cachedAuthenticationSuccesses.invalidate((Object)username);
        }
    }

    public void expireAll() {
        this.ensureInitialized();
        if (this.cachedAuthenticationSuccesses != null) {
            LOGGER.trace("invalidating cache for all users in realm [{}]", (Object)this.name());
            this.cachedAuthenticationSuccesses.invalidateAll();
        }
    }

    public void close() {
        this.ensureInitialized();
        this.expireAll();
    }

    public void lookupUser(String username, ActionListener<User> listener) {
        this.ensureInitialized();
        listener.onResponse(null);
    }

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        this.ensureInitialized();
        super.usageStats(ActionListener.wrap(stats -> {
            stats.put("cache", Collections.singletonMap("size", this.getCacheSize()));
            listener.onResponse(stats);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private int getCacheSize() {
        this.ensureInitialized();
        return this.cachedAuthenticationSuccesses == null ? -1 : this.cachedAuthenticationSuccesses.count();
    }

    public static SecureString getHeaderSchemeParameters(ThreadContext threadContext, String headerName, String schemeValue, boolean ignoreCase) {
        String trimmedSchemeParameters;
        String schemeValuePlusSpace;
        String headerValue = threadContext.getHeader(headerName);
        if (Strings.hasText((String)headerValue) && headerValue.regionMatches(ignoreCase, 0, schemeValuePlusSpace = schemeValue + " ", 0, schemeValuePlusSpace.length()) && Strings.hasText((String)(trimmedSchemeParameters = headerValue.substring(schemeValuePlusSpace.length()).trim()))) {
            return new SecureString(trimmedSchemeParameters.toCharArray());
        }
        return null;
    }

    private static class CachedAuthenticationSuccess {
        private final String cacheKey;
        private final AuthenticationResult<User> authenticationResult;

        private CachedAuthenticationSuccess(@Nullable String cacheKey, AuthenticationResult<User> authenticationResult) {
            assert (cacheKey != null) : "Cache key must be non-null";
            assert (authenticationResult != null) : "AuthenticationResult must be non-null";
            assert (authenticationResult.isAuthenticated()) : "AuthenticationResult.isAuthenticated must be true";
            assert (authenticationResult.getValue() != null) : "AuthenticationResult.getValue=User must be non-null";
            this.cacheKey = cacheKey;
            this.authenticationResult = authenticationResult;
        }

        private boolean verify(SecureString lookupKey) {
            return this.cacheKey.equals(lookupKey.toString());
        }
    }
}

