/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.jwt;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;

public class JwtAuthenticationToken
implements AuthenticationToken {
    private static final List<String> CLAIMS_TO_REMOVE = List.of("iss", "aud", "exp", "iat", "nbf", "auth_time", "nonce", "jti");
    protected final SecureString endUserSignedJwt;
    protected final SecureString clientAuthorizationSharedSecret;
    protected SignedJWT signedJwt;
    protected JWSHeader jwsHeader;
    protected JWTClaimsSet jwtClaimsSet;
    protected byte[] jwtSignature;
    protected String issuerClaim;
    protected List<String> audiencesClaim;
    protected String subjectClaim;
    protected String principal;

    public JwtAuthenticationToken(SecureString endUserSignedJwt, @Nullable SecureString clientAuthorizationSharedSecret) {
        String computedSubject;
        if (endUserSignedJwt == null) {
            throw new IllegalArgumentException("JWT bearer token must be non-null");
        }
        if (endUserSignedJwt.isEmpty()) {
            throw new IllegalArgumentException("JWT bearer token must be non-empty");
        }
        if (clientAuthorizationSharedSecret != null && clientAuthorizationSharedSecret.isEmpty()) {
            throw new IllegalArgumentException("Client shared secret must be non-empty");
        }
        this.endUserSignedJwt = endUserSignedJwt;
        this.clientAuthorizationSharedSecret = clientAuthorizationSharedSecret;
        try {
            SignedJWT parsed;
            this.signedJwt = parsed = SignedJWT.parse((String)this.endUserSignedJwt.toString());
            this.jwsHeader = parsed.getHeader();
            this.jwtClaimsSet = parsed.getJWTClaimsSet();
            this.jwtSignature = parsed.getSignature().decode();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse JWT bearer token", e);
        }
        JWTClaimsSet jwtClaimsSet = this.jwtClaimsSet;
        this.issuerClaim = jwtClaimsSet.getIssuer();
        this.audiencesClaim = jwtClaimsSet.getAudience();
        this.subjectClaim = jwtClaimsSet.getSubject();
        if (!Strings.hasText((String)this.issuerClaim)) {
            throw new IllegalArgumentException("Issuer claim is missing.");
        }
        if (this.audiencesClaim == null || this.audiencesClaim.isEmpty()) {
            throw new IllegalArgumentException("Audiences claim is missing.");
        }
        String orderedAudiences = String.join((CharSequence)",", new TreeSet<String>(this.audiencesClaim));
        if (Strings.hasText((String)this.subjectClaim)) {
            computedSubject = this.subjectClaim;
        } else {
            TreeMap orderedClaimsSubset = new TreeMap(jwtClaimsSet.getClaims());
            for (String claimToRemove : CLAIMS_TO_REMOVE) {
                orderedClaimsSubset.remove(claimToRemove);
            }
            if (orderedClaimsSubset.isEmpty()) {
                throw new IllegalArgumentException("Claim [sub] is absent, and no other claims found besides [" + String.join((CharSequence)",", CLAIMS_TO_REMOVE) + "].");
            }
            computedSubject = ((Object)orderedClaimsSubset).toString();
        }
        this.principal = this.issuerClaim + "/" + orderedAudiences + "/" + computedSubject;
    }

    public String principal() {
        return this.principal;
    }

    public SecureString credentials() {
        return this.endUserSignedJwt;
    }

    public SecureString getEndUserSignedJwt() {
        return this.endUserSignedJwt;
    }

    public SecureString getClientAuthorizationSharedSecret() {
        return this.clientAuthorizationSharedSecret;
    }

    public SignedJWT getSignedJwt() {
        return this.signedJwt;
    }

    public JWSHeader getJwsHeader() {
        return this.jwsHeader;
    }

    public JWTClaimsSet getJwtClaimsSet() {
        return this.jwtClaimsSet;
    }

    public byte[] getSignatureBytes() {
        return this.jwtSignature;
    }

    public String getIssuerClaim() {
        return this.issuerClaim;
    }

    public List<String> getAudiencesClaim() {
        return this.audiencesClaim;
    }

    public String getSubjectClaim() {
        return this.subjectClaim;
    }

    public void clearCredentials() {
        this.endUserSignedJwt.close();
        if (this.clientAuthorizationSharedSecret != null) {
            this.clientAuthorizationSharedSecret.close();
        }
        this.signedJwt = null;
        this.jwsHeader = null;
        this.jwtClaimsSet = null;
        Arrays.fill(this.jwtSignature, (byte)0);
        this.jwtSignature = null;
        this.issuerClaim = null;
        this.audiencesClaim = null;
        this.subjectClaim = null;
        this.principal = null;
    }
}

