/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.Authenticator;

class ApiKeyAuthenticator
implements Authenticator {
    private static final Logger logger = LogManager.getLogger(ApiKeyAuthenticator.class);
    private final ApiKeyService apiKeyService;
    private final String nodeName;

    ApiKeyAuthenticator(ApiKeyService apiKeyService, String nodeName) {
        this.apiKeyService = apiKeyService;
        this.nodeName = nodeName;
    }

    @Override
    public String name() {
        return "API key";
    }

    @Override
    public AuthenticationToken extractCredentials(Authenticator.Context context) {
        return this.apiKeyService.getCredentialsFromHeader(context.getThreadContext());
    }

    @Override
    public void authenticate(Authenticator.Context context, ActionListener<AuthenticationResult<Authentication>> listener) {
        AuthenticationToken authenticationToken = context.getMostRecentAuthenticationToken();
        if (!(authenticationToken instanceof ApiKeyService.ApiKeyCredentials)) {
            listener.onResponse((Object)AuthenticationResult.notHandled());
            return;
        }
        ApiKeyService.ApiKeyCredentials apiKeyCredentials = (ApiKeyService.ApiKeyCredentials)authenticationToken;
        this.apiKeyService.tryAuthenticate(context.getThreadContext(), apiKeyCredentials, (ActionListener<AuthenticationResult<User>>)ActionListener.wrap(authResult -> {
            if (authResult.isAuthenticated()) {
                Authentication authentication = this.apiKeyService.createApiKeyAuthentication((AuthenticationResult<User>)authResult, this.nodeName);
                listener.onResponse((Object)AuthenticationResult.success((Object)authentication));
            } else if (authResult.getStatus() == AuthenticationResult.Status.TERMINATE) {
                Exception e = authResult.getException() != null ? authResult.getException() : Exceptions.authenticationError((String)authResult.getMessage(), (Object[])new Object[0]);
                logger.debug((Message)new ParameterizedMessage("API key service terminated authentication for request [{}]", (Object)context.getRequest()), (Throwable)e);
                listener.onFailure(e);
            } else {
                if (authResult.getMessage() != null) {
                    if (authResult.getException() != null) {
                        logger.warn((Message)new ParameterizedMessage("Authentication using apikey failed - {}", (Object)authResult.getMessage()), (Throwable)authResult.getException());
                    } else {
                        logger.warn("Authentication using apikey failed - {}", (Object)authResult.getMessage());
                    }
                }
                listener.onResponse((Object)AuthenticationResult.unsuccessful((String)authResult.getMessage(), (Exception)authResult.getException()));
            }
        }, e -> listener.onFailure((Exception)((Object)context.getRequest().exceptionProcessingRequest((Exception)e, null)))));
    }
}

