/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.AuthenticateRequest;
import org.elasticsearch.xpack.core.security.action.user.AuthenticateResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.User;

public class TransportAuthenticateAction
extends HandledTransportAction<AuthenticateRequest, AuthenticateResponse> {
    private final SecurityContext securityContext;
    private final AnonymousUser anonymousUser;

    @Inject
    public TransportAuthenticateAction(TransportService transportService, ActionFilters actionFilters, SecurityContext securityContext, AnonymousUser anonymousUser) {
        super("cluster:admin/xpack/security/user/authenticate", transportService, actionFilters, AuthenticateRequest::new);
        this.securityContext = securityContext;
        this.anonymousUser = anonymousUser;
    }

    protected void doExecute(Task task, AuthenticateRequest request, ActionListener<AuthenticateResponse> listener) {
        User authUser;
        Authentication authentication = this.securityContext.getAuthentication();
        User runAsUser = authentication == null ? null : authentication.getUser();
        User user = authUser = runAsUser == null ? null : runAsUser.authenticatedUser();
        if (authUser == null) {
            listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("did not find an authenticated user", new Object[0])));
        } else if (User.isInternal((User)authUser)) {
            listener.onFailure((Exception)new IllegalArgumentException("user [" + authUser.principal() + "] is internal"));
        } else if (User.isInternal((User)runAsUser)) {
            listener.onFailure((Exception)new IllegalArgumentException("user [" + runAsUser.principal() + "] is internal"));
        } else {
            boolean shouldAddAnonymousRoleNames;
            User user2 = authentication.getUser();
            boolean bl = shouldAddAnonymousRoleNames = this.anonymousUser.enabled() && false == this.anonymousUser.equals((Object)user2) && false == authentication.isApiKey() && false == authentication.isServiceAccount();
            if (shouldAddAnonymousRoleNames) {
                String[] allRoleNames = (String[])Stream.concat(Stream.of(user2.roles()), Stream.of(this.anonymousUser.roles())).toArray(String[]::new);
                listener.onResponse((Object)new AuthenticateResponse(new Authentication(new User(new User(user2.principal(), allRoleNames, user2.fullName(), user2.email(), user2.metadata(), user2.enabled()), user2.authenticatedUser()), authentication.getAuthenticatedBy(), authentication.getLookedUpBy(), authentication.getVersion(), authentication.getAuthenticationType(), authentication.getMetadata())));
            } else {
                listener.onResponse((Object)new AuthenticateResponse(authentication));
            }
        }
    }
}

