/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.profile;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.profile.GetProfileRequest;
import org.elasticsearch.xpack.core.security.action.profile.GetProfilesResponse;
import org.elasticsearch.xpack.core.security.action.profile.Profile;
import org.elasticsearch.xpack.security.profile.ProfileService;

public class TransportGetProfileAction
extends HandledTransportAction<GetProfileRequest, GetProfilesResponse> {
    private final ProfileService profileService;

    @Inject
    public TransportGetProfileAction(TransportService transportService, ActionFilters actionFilters, ProfileService profileService) {
        super("cluster:admin/xpack/security/profile/get", transportService, actionFilters, GetProfileRequest::new);
        this.profileService = profileService;
    }

    protected void doExecute(Task task, GetProfileRequest request, ActionListener<GetProfilesResponse> listener) {
        this.profileService.getProfile(request.getUid(), request.getDatKeys(), (ActionListener<Profile>)listener.map(GetProfilesResponse::new));
    }
}

