/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.apikey;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.security.action.GrantRequest;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyResponse;
import org.elasticsearch.xpack.core.security.action.apikey.GrantApiKeyRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.security.action.TransportGrantAction;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.support.ApiKeyGenerator;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public final class TransportGrantApiKeyAction
extends TransportGrantAction<GrantApiKeyRequest, CreateApiKeyResponse> {
    private final ApiKeyGenerator generator;

    @Inject
    public TransportGrantApiKeyAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, ApiKeyService apiKeyService, AuthenticationService authenticationService, CompositeRolesStore rolesStore, NamedXContentRegistry xContentRegistry) {
        this(transportService, actionFilters, threadPool.getThreadContext(), new ApiKeyGenerator(apiKeyService, rolesStore, xContentRegistry), authenticationService);
    }

    TransportGrantApiKeyAction(TransportService transportService, ActionFilters actionFilters, ThreadContext threadContext, ApiKeyGenerator generator, AuthenticationService authenticationService) {
        super("cluster:admin/xpack/security/api_key/grant", transportService, actionFilters, GrantApiKeyRequest::new, authenticationService, threadContext);
        this.generator = generator;
    }

    protected void doExecute(Task task, GrantApiKeyRequest request, ActionListener<CreateApiKeyResponse> listener) {
        this.executeWithGrantAuthentication((GrantRequest)request, (ActionListener<Authentication>)listener.delegateFailure((l, authentication) -> this.generator.generateApiKey((Authentication)authentication, request.getApiKeyRequest(), listener)));
    }
}

