/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.apikey;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.support.ApiKeyGenerator;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public final class TransportCreateApiKeyAction
extends HandledTransportAction<CreateApiKeyRequest, CreateApiKeyResponse> {
    private final ApiKeyGenerator generator;
    private final SecurityContext securityContext;

    @Inject
    public TransportCreateApiKeyAction(TransportService transportService, ActionFilters actionFilters, ApiKeyService apiKeyService, SecurityContext context, CompositeRolesStore rolesStore, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/security/api_key/create", transportService, actionFilters, CreateApiKeyRequest::new);
        this.generator = new ApiKeyGenerator(apiKeyService, rolesStore, xContentRegistry);
        this.securityContext = context;
    }

    protected void doExecute(Task task, CreateApiKeyRequest request, ActionListener<CreateApiKeyResponse> listener) {
        Authentication authentication = this.securityContext.getAuthentication();
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalStateException("authentication is required"));
        } else {
            if (authentication.isApiKey() && this.grantsAnyPrivileges(request)) {
                listener.onFailure((Exception)new IllegalArgumentException("creating derived api keys requires an explicit role descriptor that is empty (has no privileges)"));
                return;
            }
            this.generator.generateApiKey(authentication, request, listener);
        }
    }

    private boolean grantsAnyPrivileges(CreateApiKeyRequest request) {
        return request.getRoleDescriptors() == null || request.getRoleDescriptors().isEmpty() || false == request.getRoleDescriptors().stream().allMatch(RoleDescriptor::isEmpty);
    }
}

