/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.extras;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.shingle.FixedShingleFilter;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.spans.FieldMaskingSpanQuery;
import org.apache.lucene.queries.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.TextParams;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class SearchAsYouTypeFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "search_as_you_type";
    private static final int MAX_SHINGLE_SIZE_LOWER_BOUND = 2;
    private static final int MAX_SHINGLE_SIZE_UPPER_BOUND = 4;
    private static final String PREFIX_FIELD_SUFFIX = "._index_prefix";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getIndexAnalyzers()));
    private final int maxShingleSize;
    private final PrefixFieldMapper prefixField;
    private final ShingleFieldMapper[] shingleFields;
    private final Builder builder;

    private static Builder builder(FieldMapper in) {
        return ((SearchAsYouTypeFieldMapper)in).builder;
    }

    private static int countPosition(TokenStream stream) throws IOException {
        assert (stream instanceof CachingTokenFilter);
        PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
        stream.reset();
        int positionCount = 0;
        while (stream.incrementToken()) {
            if (posIncAtt.getPositionIncrement() == 0) continue;
            positionCount += posIncAtt.getPositionIncrement();
        }
        return positionCount;
    }

    public SearchAsYouTypeFieldMapper(String simpleName, SearchAsYouTypeFieldType mappedFieldType, FieldMapper.CopyTo copyTo, Map<String, NamedAnalyzer> indexAnalyzers, PrefixFieldMapper prefixField, ShingleFieldMapper[] shingleFields, FieldMapper.MultiFields multiFields, Builder builder) {
        super(simpleName, (MappedFieldType)mappedFieldType, indexAnalyzers, multiFields, copyTo, false, null);
        this.prefixField = prefixField;
        this.shingleFields = shingleFields;
        this.maxShingleSize = (Integer)builder.maxShingleSize.getValue();
        this.builder = builder;
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        String value = context.parser().textOrNull();
        if (value == null) {
            return;
        }
        if (!((Boolean)this.builder.index.get()).booleanValue() && !((Boolean)this.builder.store.get()).booleanValue()) {
            return;
        }
        context.doc().add((IndexableField)new Field(this.fieldType().name(), (CharSequence)value, (IndexableFieldType)this.fieldType().fieldType));
        if (((Boolean)this.builder.index.get()).booleanValue()) {
            for (ShingleFieldMapper subFieldMapper : this.shingleFields) {
                context.doc().add((IndexableField)new Field(subFieldMapper.fieldType().name(), (CharSequence)value, (IndexableFieldType)subFieldMapper.getLuceneFieldType()));
            }
            context.doc().add((IndexableField)new Field(this.prefixField.fieldType().name(), (CharSequence)value, (IndexableFieldType)this.prefixField.getLuceneFieldType()));
        }
        if (this.fieldType().fieldType.omitNorms()) {
            context.addToFieldNames(this.fieldType().name());
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.builder.analyzers.indexAnalyzers).init(this);
    }

    public static String getShingleFieldName(String parentField, int shingleSize) {
        return parentField + "._" + shingleSize + "gram";
    }

    public SearchAsYouTypeFieldType fieldType() {
        return (SearchAsYouTypeFieldType)super.fieldType();
    }

    public int maxShingleSize() {
        return this.maxShingleSize;
    }

    public PrefixFieldMapper prefixField() {
        return this.prefixField;
    }

    public ShingleFieldMapper[] shingleFields() {
        return this.shingleFields;
    }

    public Iterator<Mapper> iterator() {
        ArrayList<FieldMapper> subIterators = new ArrayList<FieldMapper>();
        subIterators.add(this.prefixField);
        subIterators.addAll(Arrays.asList(this.shingleFields));
        Iterator concat = Iterators.concat((Iterator[])new Iterator[]{super.iterator(), subIterators.iterator()});
        return concat;
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> index = FieldMapper.Parameter.indexParam(m -> (Boolean)SearchAsYouTypeFieldMapper.builder((FieldMapper)m).index.get(), (boolean)true);
        private final FieldMapper.Parameter<Boolean> store = FieldMapper.Parameter.storeParam(m -> (Boolean)SearchAsYouTypeFieldMapper.builder((FieldMapper)m).store.get(), (boolean)false);
        private final FieldMapper.Parameter<Boolean> docValues = FieldMapper.Parameter.docValuesParam(m -> false, (boolean)false).addValidator(v -> {
            if (v.booleanValue()) {
                throw new MapperParsingException("Cannot set [doc_values] on field of type [search_as_you_type]");
            }
        }).alwaysSerialize();
        private final FieldMapper.Parameter<Integer> maxShingleSize = FieldMapper.Parameter.intParam((String)"max_shingle_size", (boolean)false, m -> (Integer)SearchAsYouTypeFieldMapper.builder((FieldMapper)m).maxShingleSize.get(), (int)3).addValidator(v -> {
            if (v < 2 || v > 4) {
                throw new MapperParsingException("[max_shingle_size] must be at least [2] and at most [4], got [" + v + "]");
            }
        }).alwaysSerialize();
        final TextParams.Analyzers analyzers;
        final FieldMapper.Parameter<SimilarityProvider> similarity = TextParams.similarity(m -> (SimilarityProvider)SearchAsYouTypeFieldMapper.builder((FieldMapper)m).similarity.get());
        final FieldMapper.Parameter<String> indexOptions = TextParams.indexOptions(m -> (String)SearchAsYouTypeFieldMapper.builder((FieldMapper)m).indexOptions.get());
        final FieldMapper.Parameter<Boolean> norms = TextParams.norms((boolean)true, m -> (Boolean)SearchAsYouTypeFieldMapper.builder((FieldMapper)m).norms.get());
        final FieldMapper.Parameter<String> termVectors = TextParams.termVectors(m -> (String)SearchAsYouTypeFieldMapper.builder((FieldMapper)m).termVectors.get());
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name, IndexAnalyzers indexAnalyzers) {
            super(name);
            this.analyzers = new TextParams.Analyzers(indexAnalyzers, m -> SearchAsYouTypeFieldMapper.builder((FieldMapper)m).analyzers.getIndexAnalyzer(), m -> (Integer)SearchAsYouTypeFieldMapper.builder((FieldMapper)m).analyzers.positionIncrementGap.getValue());
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return List.of(this.index, this.store, this.docValues, this.maxShingleSize, this.analyzers.indexAnalyzer, this.analyzers.searchAnalyzer, this.analyzers.searchQuoteAnalyzer, this.similarity, this.indexOptions, this.norms, this.termVectors, this.meta);
        }

        public SearchAsYouTypeFieldMapper build(MapperBuilderContext context) {
            FieldType fieldType = new FieldType();
            fieldType.setIndexOptions(TextParams.toIndexOptions((boolean)((Boolean)this.index.getValue()), (String)((String)this.indexOptions.getValue())));
            fieldType.setOmitNorms((Boolean)this.norms.getValue() == false);
            fieldType.setStored(((Boolean)this.store.getValue()).booleanValue());
            TextParams.setTermVectorParams((String)((String)this.termVectors.getValue()), (FieldType)fieldType);
            HashMap<String, NamedAnalyzer> indexAnalyzers = new HashMap<String, NamedAnalyzer>();
            NamedAnalyzer indexAnalyzer = this.analyzers.getIndexAnalyzer();
            NamedAnalyzer searchAnalyzer = this.analyzers.getSearchAnalyzer();
            SearchAsYouTypeFieldType ft = new SearchAsYouTypeFieldType(context.buildFullName(this.name), fieldType, (SimilarityProvider)this.similarity.getValue(), this.analyzers.getSearchAnalyzer(), this.analyzers.getSearchQuoteAnalyzer(), (Map)this.meta.getValue());
            indexAnalyzers.put(ft.name(), indexAnalyzer);
            FieldType prefixft = new FieldType();
            prefixft.setIndexOptions(fieldType.indexOptions());
            prefixft.setOmitNorms(true);
            prefixft.setStored(false);
            String fullName = context.buildFullName(this.name);
            SearchAsYouTypeAnalyzer prefixIndexWrapper = SearchAsYouTypeAnalyzer.withShingleAndPrefix(indexAnalyzer.analyzer(), (Integer)this.maxShingleSize.getValue());
            NamedAnalyzer prefixSearchWrapper = new NamedAnalyzer(searchAnalyzer.name(), searchAnalyzer.scope(), (Analyzer)SearchAsYouTypeAnalyzer.withShingle(searchAnalyzer.analyzer(), (Integer)this.maxShingleSize.getValue()));
            TextSearchInfo prefixSearchInfo = new TextSearchInfo(prefixft, (SimilarityProvider)this.similarity.getValue(), prefixSearchWrapper, searchAnalyzer);
            PrefixFieldType prefixFieldType = new PrefixFieldType(fullName, prefixSearchInfo, 1, 20);
            NamedAnalyzer prefixAnalyzer = new NamedAnalyzer(indexAnalyzer.name(), AnalyzerScope.INDEX, (Analyzer)prefixIndexWrapper);
            PrefixFieldMapper prefixFieldMapper = new PrefixFieldMapper(prefixft, prefixFieldType);
            indexAnalyzers.put(prefixFieldType.name(), prefixAnalyzer);
            ShingleFieldMapper[] shingleFieldMappers = new ShingleFieldMapper[(Integer)this.maxShingleSize.getValue() - 1];
            ShingleFieldType[] shingleFieldTypes = new ShingleFieldType[(Integer)this.maxShingleSize.getValue() - 1];
            for (int i = 0; i < shingleFieldMappers.length; ++i) {
                int shingleSize = i + 2;
                FieldType shingleft = new FieldType((IndexableFieldType)fieldType);
                shingleft.setStored(false);
                String fieldName = SearchAsYouTypeFieldMapper.getShingleFieldName(context.buildFullName(this.name), shingleSize);
                SearchAsYouTypeAnalyzer shingleIndexWrapper = SearchAsYouTypeAnalyzer.withShingle(indexAnalyzer.analyzer(), shingleSize);
                NamedAnalyzer shingleSearchWrapper = new NamedAnalyzer(searchAnalyzer.name(), searchAnalyzer.scope(), (Analyzer)SearchAsYouTypeAnalyzer.withShingle(searchAnalyzer.analyzer(), shingleSize));
                NamedAnalyzer shingleSearchQuoteWrapper = new NamedAnalyzer(searchAnalyzer.name(), searchAnalyzer.scope(), (Analyzer)SearchAsYouTypeAnalyzer.withShingle(searchAnalyzer.analyzer(), shingleSize));
                TextSearchInfo textSearchInfo = new TextSearchInfo(shingleft, (SimilarityProvider)this.similarity.getValue(), shingleSearchWrapper, shingleSearchQuoteWrapper);
                ShingleFieldType shingleFieldType = new ShingleFieldType(fieldName, shingleSize, textSearchInfo);
                shingleFieldType.setPrefixFieldType(prefixFieldType);
                shingleFieldTypes[i] = shingleFieldType;
                NamedAnalyzer shingleAnalyzer = new NamedAnalyzer(indexAnalyzer.name(), AnalyzerScope.INDEX, (Analyzer)shingleIndexWrapper);
                shingleFieldMappers[i] = new ShingleFieldMapper(shingleft, shingleFieldType);
                indexAnalyzers.put(shingleFieldType.name(), shingleAnalyzer);
            }
            ft.setPrefixField(prefixFieldType);
            ft.setShingleFields(shingleFieldTypes);
            return new SearchAsYouTypeFieldMapper(this.name, ft, this.copyTo.build(), indexAnalyzers, prefixFieldMapper, shingleFieldMappers, this.multiFieldsBuilder.build((Mapper.Builder)this, context), this);
        }
    }

    static final class PrefixFieldMapper
    extends FieldMapper {
        final FieldType fieldType;

        PrefixFieldMapper(FieldType fieldType, PrefixFieldType mappedFieldType) {
            super(mappedFieldType.name(), (MappedFieldType)mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
            this.fieldType = fieldType;
        }

        public PrefixFieldType fieldType() {
            return (PrefixFieldType)super.fieldType();
        }

        FieldType getLuceneFieldType() {
            return this.fieldType;
        }

        protected void parseCreateField(DocumentParserContext context) {
            throw new UnsupportedOperationException();
        }

        public FieldMapper.Builder getMergeBuilder() {
            return null;
        }

        protected String contentType() {
            return "prefix";
        }

        public String toString() {
            return this.fieldType().toString();
        }
    }

    static final class ShingleFieldMapper
    extends FieldMapper {
        private final FieldType fieldType;

        ShingleFieldMapper(FieldType fieldType, ShingleFieldType mappedFieldtype) {
            super(mappedFieldtype.name(), (MappedFieldType)mappedFieldtype, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
            this.fieldType = fieldType;
        }

        FieldType getLuceneFieldType() {
            return this.fieldType;
        }

        public ShingleFieldType fieldType() {
            return (ShingleFieldType)super.fieldType();
        }

        protected void parseCreateField(DocumentParserContext context) {
            throw new UnsupportedOperationException();
        }

        public FieldMapper.Builder getMergeBuilder() {
            return null;
        }

        protected String contentType() {
            return "shingle";
        }
    }

    static class SearchAsYouTypeFieldType
    extends StringFieldType {
        final FieldType fieldType;
        PrefixFieldType prefixField;
        ShingleFieldType[] shingleFields = new ShingleFieldType[0];

        SearchAsYouTypeFieldType(String name, FieldType fieldType, SimilarityProvider similarity, NamedAnalyzer searchAnalyzer, NamedAnalyzer searchQuoteAnalyzer, Map<String, String> meta) {
            super(name, fieldType.indexOptions() != IndexOptions.NONE, fieldType.stored(), false, new TextSearchInfo(fieldType, similarity, searchAnalyzer, searchQuoteAnalyzer), meta);
            this.fieldType = fieldType;
        }

        public void setPrefixField(PrefixFieldType prefixField) {
            this.prefixField = prefixField;
        }

        public void setShingleFields(ShingleFieldType[] shingleFields) {
            this.shingleFields = shingleFields;
        }

        public String typeName() {
            return SearchAsYouTypeFieldMapper.CONTENT_TYPE;
        }

        private ShingleFieldType shingleFieldForPositions(int positions) {
            int indexFromShingleSize = Math.max(positions - 2, 0);
            return this.shingleFields[Math.min(indexFromShingleSize, this.shingleFields.length - 1)];
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.toString((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            if (this.prefixField == null || !this.prefixField.termLengthWithinBounds(value.length())) {
                return super.prefixQuery(value, method, caseInsensitive, context);
            }
            Query query = this.prefixField.prefixQuery(value, method, caseInsensitive, context);
            if (method == null || method == MultiTermQuery.CONSTANT_SCORE_REWRITE || method == MultiTermQuery.CONSTANT_SCORE_BOOLEAN_REWRITE) {
                return new ConstantScoreQuery(query);
            }
            return query;
        }

        private void checkForPositions() {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalStateException("field:[" + this.name() + "] was indexed without position data; cannot run PhraseQuery");
            }
        }

        public Query phraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext context) throws IOException {
            this.checkForPositions();
            int numPos = SearchAsYouTypeFieldMapper.countPosition(stream);
            if (this.shingleFields.length == 0 || slop > 0 || TextFieldMapper.TextFieldType.hasGaps((TokenStream)stream) || numPos <= 1) {
                return TextFieldMapper.createPhraseQuery((TokenStream)stream, (String)this.name(), (int)slop, (boolean)enablePositionIncrements);
            }
            ShingleFieldType shingleField = this.shingleFieldForPositions(numPos);
            stream = new FixedShingleFilter(stream, shingleField.shingleSize);
            return shingleField.phraseQuery(stream, 0, true, context);
        }

        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext context) throws IOException {
            this.checkForPositions();
            int numPos = SearchAsYouTypeFieldMapper.countPosition(stream);
            if (this.shingleFields.length == 0 || slop > 0 || TextFieldMapper.TextFieldType.hasGaps((TokenStream)stream) || numPos <= 1) {
                return TextFieldMapper.createPhraseQuery((TokenStream)stream, (String)this.name(), (int)slop, (boolean)enablePositionIncrements);
            }
            ShingleFieldType shingleField = this.shingleFieldForPositions(numPos);
            stream = new FixedShingleFilter(stream, shingleField.shingleSize);
            return shingleField.multiPhraseQuery(stream, 0, true, context);
        }

        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions, SearchExecutionContext context) throws IOException {
            int numPos = SearchAsYouTypeFieldMapper.countPosition(stream);
            if (numPos > 1) {
                this.checkForPositions();
            }
            if (this.shingleFields.length == 0 || slop > 0 || TextFieldMapper.TextFieldType.hasGaps((TokenStream)stream) || numPos <= 1) {
                return TextFieldMapper.createPhrasePrefixQuery((TokenStream)stream, (String)this.name(), (int)slop, (int)maxExpansions, null, null);
            }
            ShingleFieldType shingleField = this.shingleFieldForPositions(numPos);
            stream = new FixedShingleFilter(stream, shingleField.shingleSize);
            return shingleField.phrasePrefixQuery(stream, 0, maxExpansions, context);
        }

        public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, SearchExecutionContext context) {
            if (this.prefixField != null && this.prefixField.termLengthWithinBounds(value.length())) {
                return new FieldMaskingSpanQuery((SpanQuery)new SpanTermQuery(new Term(this.prefixField.name(), this.indexedValueForSearch(value))), this.name());
            }
            SpanMultiTermQueryWrapper spanMulti = new SpanMultiTermQueryWrapper((MultiTermQuery)new PrefixQuery(new Term(this.name(), this.indexedValueForSearch(value))));
            spanMulti.setRewriteMethod(method);
            return spanMulti;
        }
    }

    static class ShingleFieldType
    extends StringFieldType {
        final int shingleSize;
        PrefixFieldType prefixFieldType;

        ShingleFieldType(String name, int shingleSize, TextSearchInfo textSearchInfo) {
            super(name, true, false, false, textSearchInfo, Collections.emptyMap());
            this.shingleSize = shingleSize;
        }

        void setPrefixFieldType(PrefixFieldType prefixFieldType) {
            this.prefixFieldType = prefixFieldType;
        }

        public boolean mayExistInIndex(SearchExecutionContext context) {
            return false;
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.toString((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        public String typeName() {
            return SearchAsYouTypeFieldMapper.CONTENT_TYPE;
        }

        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            if (this.prefixFieldType == null || !this.prefixFieldType.termLengthWithinBounds(value.length())) {
                return super.prefixQuery(value, method, caseInsensitive, context);
            }
            Query query = this.prefixFieldType.prefixQuery(value, method, caseInsensitive, context);
            if (method == null || method == MultiTermQuery.CONSTANT_SCORE_REWRITE || method == MultiTermQuery.CONSTANT_SCORE_BOOLEAN_REWRITE) {
                return new ConstantScoreQuery(query);
            }
            return query;
        }

        public Query phraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext context) throws IOException {
            return TextFieldMapper.createPhraseQuery((TokenStream)stream, (String)this.name(), (int)slop, (boolean)enablePositionIncrements);
        }

        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext context) throws IOException {
            return TextFieldMapper.createPhraseQuery((TokenStream)stream, (String)this.name(), (int)slop, (boolean)enablePositionIncrements);
        }

        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions, SearchExecutionContext context) throws IOException {
            String prefixFieldName = slop > 0 ? null : this.prefixFieldType.name();
            return TextFieldMapper.createPhrasePrefixQuery((TokenStream)stream, (String)this.name(), (int)slop, (int)maxExpansions, (String)prefixFieldName, this.prefixFieldType::termLengthWithinBounds);
        }

        public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, SearchExecutionContext context) {
            if (this.prefixFieldType != null && this.prefixFieldType.termLengthWithinBounds(value.length())) {
                return new FieldMaskingSpanQuery((SpanQuery)new SpanTermQuery(new Term(this.prefixFieldType.name(), this.indexedValueForSearch(value))), this.name());
            }
            SpanMultiTermQueryWrapper spanMulti = new SpanMultiTermQueryWrapper((MultiTermQuery)new PrefixQuery(new Term(this.name(), this.indexedValueForSearch(value))));
            spanMulti.setRewriteMethod(method);
            return spanMulti;
        }
    }

    static final class PrefixFieldType
    extends StringFieldType {
        final int minChars;
        final int maxChars;
        final String parentField;

        PrefixFieldType(String parentField, TextSearchInfo textSearchInfo, int minChars, int maxChars) {
            super(parentField + SearchAsYouTypeFieldMapper.PREFIX_FIELD_SUFFIX, true, false, false, textSearchInfo, Collections.emptyMap());
            this.minChars = minChars;
            this.maxChars = maxChars;
            this.parentField = parentField;
        }

        boolean termLengthWithinBounds(int length) {
            return length >= this.minChars - 1 && length <= this.maxChars;
        }

        public boolean mayExistInIndex(SearchExecutionContext context) {
            return false;
        }

        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            if (value.length() >= this.minChars) {
                if (caseInsensitive) {
                    return super.termQueryCaseInsensitive((Object)value, context);
                }
                return super.termQuery((Object)value, context);
            }
            ArrayList<Automaton> automata = new ArrayList<Automaton>();
            automata.add(Automata.makeString((String)value));
            for (int i = value.length(); i < this.minChars; ++i) {
                automata.add(Automata.makeAnyChar());
            }
            Automaton automaton = Operations.concatenate(automata);
            AutomatonQuery query = new AutomatonQuery(new Term(this.name(), value + "*"), automaton);
            query.setRewriteMethod(method);
            return new BooleanQuery.Builder().add((Query)query, BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term(this.parentField, value)), BooleanClause.Occur.SHOULD).build();
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.toString((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        public String typeName() {
            return "prefix";
        }

        public String toString() {
            return super.toString() + ",prefixChars=" + this.minChars + ":" + this.maxChars;
        }
    }

    static class SearchAsYouTypeAnalyzer
    extends AnalyzerWrapper {
        private final Analyzer delegate;
        private final int shingleSize;
        private final boolean indexPrefixes;

        private SearchAsYouTypeAnalyzer(Analyzer delegate, int shingleSize, boolean indexPrefixes) {
            super(delegate.getReuseStrategy());
            this.delegate = Objects.requireNonNull(delegate);
            this.shingleSize = shingleSize;
            this.indexPrefixes = indexPrefixes;
        }

        static SearchAsYouTypeAnalyzer withShingle(Analyzer delegate, int shingleSize) {
            return new SearchAsYouTypeAnalyzer(delegate, shingleSize, false);
        }

        static SearchAsYouTypeAnalyzer withShingleAndPrefix(Analyzer delegate, int shingleSize) {
            return new SearchAsYouTypeAnalyzer(delegate, shingleSize, true);
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            Object tokenStream = components.getTokenStream();
            if (this.indexPrefixes) {
                tokenStream = new TrailingShingleTokenFilter((TokenStream)tokenStream, this.shingleSize - 1);
            }
            tokenStream = new FixedShingleFilter(tokenStream, this.shingleSize, " ", "");
            if (this.indexPrefixes) {
                tokenStream = new EdgeNGramTokenFilter(tokenStream, 1, 20, true);
            }
            return new Analyzer.TokenStreamComponents(components.getSource(), tokenStream);
        }

        public int shingleSize() {
            return this.shingleSize;
        }

        public boolean indexPrefixes() {
            return this.indexPrefixes;
        }

        public String toString() {
            return "<" + ((Object)((Object)this)).getClass().getCanonicalName() + " shingleSize=[" + this.shingleSize + "] indexPrefixes=[" + this.indexPrefixes + "]>";
        }

        private static class TrailingShingleTokenFilter
        extends TokenFilter {
            private final int extraPositionIncrements;
            private final PositionIncrementAttribute positionIncrementAttribute;

            TrailingShingleTokenFilter(TokenStream input, int extraPositionIncrements) {
                super(input);
                this.extraPositionIncrements = extraPositionIncrements;
                this.positionIncrementAttribute = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
            }

            public boolean incrementToken() throws IOException {
                return this.input.incrementToken();
            }

            public void end() throws IOException {
                super.end();
                this.positionIncrementAttribute.setPositionIncrement(this.extraPositionIncrements);
            }
        }
    }

    public static class Defaults {
        public static final int MIN_GRAM = 1;
        public static final int MAX_GRAM = 20;
        public static final int MAX_SHINGLE_SIZE = 3;
    }
}

