/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.eql.parser.EqlBaseParser;
import org.elasticsearch.xpack.eql.parser.ExpressionBuilder;
import org.elasticsearch.xpack.eql.parser.ParserParams;
import org.elasticsearch.xpack.eql.parser.ParsingException;
import org.elasticsearch.xpack.eql.plan.logical.Head;
import org.elasticsearch.xpack.eql.plan.logical.Join;
import org.elasticsearch.xpack.eql.plan.logical.KeyedFilter;
import org.elasticsearch.xpack.eql.plan.logical.LimitWithOffset;
import org.elasticsearch.xpack.eql.plan.logical.Sequence;
import org.elasticsearch.xpack.eql.plan.logical.Tail;
import org.elasticsearch.xpack.eql.plan.physical.LocalRelation;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.EmptyAttribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.predicate.logical.And;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.ql.parser.ParserUtils;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.ql.util.StringUtils;

public abstract class LogicalPlanBuilder
extends ExpressionBuilder {
    static final String FILTER_PIPE = "filter";
    static final String HEAD_PIPE = "head";
    static final String TAIL_PIPE = "tail";
    static final String RUNS = "runs";
    static final Set<String> SUPPORTED_PIPES = Sets.newHashSet((Object[])new String[]{"count", "filter", "head", "sort", "tail", "unique", "unique_count"});
    private final UnresolvedRelation RELATION = new UnresolvedRelation(Source.synthetic((String)"<relation>"), null, "", false, "");
    private final EmptyAttribute UNSPECIFIED_FIELD = new EmptyAttribute(Source.synthetic((String)"<unspecified>"));

    public LogicalPlanBuilder(ParserParams params) {
        super(params);
    }

    private Attribute fieldTimestamp() {
        return new UnresolvedAttribute(Source.synthetic((String)"<timestamp>"), this.params.fieldTimestamp());
    }

    private Attribute fieldTiebreaker() {
        return this.params.fieldTiebreaker() != null ? new UnresolvedAttribute(Source.synthetic((String)"<tiebreaker>"), this.params.fieldTiebreaker()) : this.UNSPECIFIED_FIELD;
    }

    private Order.OrderDirection resultPosition() {
        return this.params.resultPosition();
    }

    @Override
    public Object visitStatement(EqlBaseParser.StatementContext ctx) {
        Object plan = this.plan((ParseTree)ctx.query());
        boolean asc = this.resultPosition() == Order.OrderDirection.ASC;
        Order.NullsPosition position = asc ? Order.NullsPosition.FIRST : Order.NullsPosition.LAST;
        ArrayList<Order> orders = new ArrayList<Order>(2);
        Source defaultOrderSource = Source.synthetic((String)"<default-order>");
        orders.add(new Order(defaultOrderSource, (Expression)this.fieldTimestamp(), this.resultPosition(), position));
        Attribute tiebreaker = this.fieldTiebreaker();
        if (Expressions.isPresent((NamedExpression)tiebreaker)) {
            orders.add(new Order(defaultOrderSource, (Expression)tiebreaker, this.resultPosition(), position));
        }
        plan = new OrderBy(defaultOrderSource, plan, orders);
        Literal defaultSize = new Literal(Source.synthetic((String)"<default-size>"), (Object)this.params.size(), DataTypes.INTEGER);
        Source defaultLimitSource = Source.synthetic((String)"<default-limit>");
        Object previous = plan;
        boolean missingLimit = true;
        for (EqlBaseParser.PipeContext pipeCtx : ctx.pipe()) {
            plan = this.pipe(pipeCtx, (LogicalPlan)previous);
            if (missingLimit && plan instanceof LimitWithOffset) {
                missingLimit = false;
                previous = plan instanceof Head ? new Head(defaultLimitSource, (Expression)defaultSize, (LogicalPlan)previous) : new Tail(defaultLimitSource, (Expression)defaultSize, (LogicalPlan)previous);
                plan = (LogicalPlan)plan.replaceChildrenSameSize(Collections.singletonList(previous));
            }
            previous = plan;
        }
        if (missingLimit) {
            plan = asc ? new Head(defaultLimitSource, (Expression)defaultSize, (LogicalPlan)plan) : new Tail(defaultLimitSource, (Expression)defaultSize, (LogicalPlan)plan);
        }
        return plan;
    }

    @Override
    public LogicalPlan visitEventQuery(EqlBaseParser.EventQueryContext ctx) {
        return this.visitEventFilter(ctx.eventFilter());
    }

    @Override
    public LogicalPlan visitEventFilter(EqlBaseParser.EventFilterContext ctx) {
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        Expression condition = this.expression((ParseTree)ctx.expression());
        if (ctx.event != null) {
            Source eventSource = ParserUtils.source((ParserRuleContext)ctx.event);
            String eventName = ctx.event.getText();
            if (eventName.startsWith("\"") || eventName.startsWith("'") || eventName.startsWith("?")) {
                eventName = LogicalPlanBuilder.unquoteString(ParserUtils.source((ParserRuleContext)ctx.event));
            }
            Literal eventValue = new Literal(eventSource, (Object)eventName, DataTypes.KEYWORD);
            UnresolvedAttribute eventField = new UnresolvedAttribute(eventSource, this.params.fieldEventCategory());
            Equals eventMatch = new Equals(eventSource, (Expression)eventField, (Expression)eventValue, this.params.zoneId());
            condition = new And(source, (Expression)eventMatch, condition);
        }
        return new Filter(source, (LogicalPlan)this.RELATION, condition);
    }

    @Override
    public Join visitJoin(EqlBaseParser.JoinContext ctx) {
        Object parentJoinKeys = this.visitJoinKeys(ctx.by);
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        int numberOfKeys = -1;
        ArrayList<KeyedFilter> queries = new ArrayList<KeyedFilter>(ctx.joinTerm().size());
        for (EqlBaseParser.JoinTermContext joinTermCtx : ctx.joinTerm()) {
            KeyedFilter joinTerm = this.visitJoinTerm(joinTermCtx, (List<Attribute>)parentJoinKeys);
            int keySize = joinTerm.keys().size();
            if (numberOfKeys < 0) {
                numberOfKeys = keySize;
            } else if (numberOfKeys != keySize) {
                Source src = ParserUtils.source((ParserRuleContext)(joinTermCtx.by != null ? joinTermCtx.by : joinTermCtx));
                int expected = numberOfKeys - parentJoinKeys.size();
                int found = keySize - parentJoinKeys.size();
                throw new ParsingException(src, "Inconsistent number of join keys specified; expected [{}] but found [{}]", expected, found);
            }
            queries.add(joinTerm);
        }
        KeyedFilter until = ctx.until != null ? (KeyedFilter)((Object)queries.remove(queries.size() - 1)) : this.defaultUntil(source);
        return new Join(source, queries, until, this.fieldTimestamp(), this.fieldTiebreaker(), this.resultPosition());
    }

    private KeyedFilter defaultUntil(Source source) {
        return new KeyedFilter(source, new LocalRelation(source, Collections.emptyList()), Collections.emptyList(), (Attribute)this.UNSPECIFIED_FIELD, (Attribute)this.UNSPECIFIED_FIELD);
    }

    public KeyedFilter visitJoinTerm(EqlBaseParser.JoinTermContext ctx, List<Attribute> joinKeys) {
        return this.keyedFilter(joinKeys, (ParseTree)ctx, ctx.by, ctx.subquery());
    }

    private KeyedFilter keyedFilter(List<Attribute> joinKeys, ParseTree ctx, EqlBaseParser.JoinKeysContext joinCtx, EqlBaseParser.SubqueryContext subqueryCtx) {
        List keys = CollectionUtils.combine(joinKeys, (List)this.visitJoinKeys(joinCtx));
        LogicalPlan eventQuery = this.visitEventFilter(subqueryCtx.eventFilter());
        return new KeyedFilter(ParserUtils.source((ParseTree)ctx), eventQuery, keys, this.fieldTimestamp(), this.fieldTiebreaker());
    }

    @Override
    public Sequence visitSequence(EqlBaseParser.SequenceContext ctx) {
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        if (ctx.disallowed != null && ctx.sequenceParams() != null) {
            throw new ParsingException(source, "Please specify sequence [by] before [with] not after", new Object[0]);
        }
        Object parentJoinKeys = this.visitJoinKeys(ctx.by);
        TimeValue maxSpan = this.visitSequenceParams(ctx.sequenceParams());
        int numberOfKeys = -1;
        ArrayList<KeyedFilter> queries = new ArrayList<KeyedFilter>(ctx.sequenceTerm().size());
        for (EqlBaseParser.SequenceTermContext sequenceTermCtx : ctx.sequenceTerm()) {
            int numberOfQueries;
            String k;
            KeyedFilter sequenceTerm = this.visitSequenceTerm(sequenceTermCtx, (List<Attribute>)parentJoinKeys);
            int keySize = sequenceTerm.keys().size();
            if (numberOfKeys < 0) {
                numberOfKeys = keySize;
            } else if (numberOfKeys != keySize) {
                Source src = ParserUtils.source((ParserRuleContext)(sequenceTermCtx.by != null ? sequenceTermCtx.by : sequenceTermCtx));
                int expected = numberOfKeys - parentJoinKeys.size();
                int found = keySize - parentJoinKeys.size();
                throw new ParsingException(src, "Inconsistent number of join keys specified; expected [{}] but found [{}]", expected, found);
            }
            Token key = sequenceTermCtx.key;
            if (key != null && !RUNS.equals(k = key.getText())) {
                throw new ParsingException(ParserUtils.source((Token)key), "Unrecognized option [{}], expecting [{}]", k, RUNS);
            }
            int runs = 1;
            EqlBaseParser.NumberContext numberCtx = sequenceTermCtx.number();
            if (numberCtx instanceof EqlBaseParser.IntegerLiteralContext) {
                Number number = (Number)this.visitIntegerLiteral((EqlBaseParser.IntegerLiteralContext)numberCtx).fold();
                long value = number.longValue();
                if (value < 1L) {
                    throw new ParsingException(ParserUtils.source((ParserRuleContext)numberCtx), "A positive runs value is required; found [{}]", value);
                }
                if (value > 100L) {
                    throw new ParsingException(ParserUtils.source((ParserRuleContext)numberCtx), "A query cannot be repeated more than 100 times; found [{}]", value);
                }
                runs = (int)value;
            }
            if ((numberOfQueries = queries.size() + runs) > 256) {
                throw new ParsingException(ParserUtils.source((ParserRuleContext)sequenceTermCtx), "Sequence cannot contain more than 256 queries; found [{}]", numberOfQueries);
            }
            for (int i = 0; i < runs; ++i) {
                queries.add(sequenceTerm);
            }
        }
        if (queries.size() < 2) {
            throw new ParsingException(source, "A sequence requires a minimum of 2 queries, found [{}]", queries.size());
        }
        KeyedFilter until = ctx.until != null ? (KeyedFilter)((Object)queries.remove(queries.size() - 1)) : this.defaultUntil(source);
        return new Sequence(source, queries, until, maxSpan, this.fieldTimestamp(), this.fieldTiebreaker(), this.resultPosition());
    }

    private KeyedFilter visitSequenceTerm(EqlBaseParser.SequenceTermContext ctx, List<Attribute> joinKeys) {
        return this.keyedFilter(joinKeys, (ParseTree)ctx, ctx.by, ctx.subquery());
    }

    @Override
    public TimeValue visitSequenceParams(EqlBaseParser.SequenceParamsContext ctx) {
        if (ctx == null) {
            return TimeValue.MINUS_ONE;
        }
        EqlBaseParser.NumberContext numberCtx = ctx.timeUnit().number();
        if (numberCtx instanceof EqlBaseParser.IntegerLiteralContext) {
            Number number = (Number)this.visitIntegerLiteral((EqlBaseParser.IntegerLiteralContext)numberCtx).fold();
            long value = number.longValue();
            if (value <= 0L) {
                throw new ParsingException(ParserUtils.source((ParserRuleContext)numberCtx), "A positive maxspan value is required; found [{}]", value);
            }
            String timeString = ParserUtils.text((ParseTree)ctx.timeUnit().IDENTIFIER());
            if (timeString == null) {
                throw new ParsingException(ParserUtils.source((ParserRuleContext)ctx.timeUnit()), "No time unit specified, did you mean [s] as in [{}s]?", ParserUtils.text((ParseTree)ctx.timeUnit()));
            }
            TimeUnit timeUnit = switch (timeString) {
                case "ms" -> TimeUnit.MILLISECONDS;
                case "s" -> TimeUnit.SECONDS;
                case "m" -> TimeUnit.MINUTES;
                case "h" -> TimeUnit.HOURS;
                case "d" -> TimeUnit.DAYS;
                default -> throw new ParsingException(ParserUtils.source((TerminalNode)ctx.timeUnit().IDENTIFIER()), "Unrecognized time unit [{}] in [{}], please specify one of [ms, s, m, h, d]", timeString, ParserUtils.text((ParseTree)ctx.timeUnit()));
            };
            return new TimeValue(value, timeUnit);
        }
        throw new ParsingException(ParserUtils.source((ParserRuleContext)numberCtx), "Decimal time interval [{}] not supported; please use an positive integer", ParserUtils.text((ParseTree)numberCtx));
    }

    private LogicalPlan pipe(EqlBaseParser.PipeContext ctx, LogicalPlan plan) {
        String name = ParserUtils.text((ParseTree)ctx.IDENTIFIER());
        if (!SUPPORTED_PIPES.contains(name)) {
            List potentialMatches = StringUtils.findSimilar((String)name, SUPPORTED_PIPES);
            Object msg = "Unrecognized pipe [{}]";
            if (!potentialMatches.isEmpty()) {
                String matchString = potentialMatches.toString();
                msg = (String)msg + ", did you mean " + (String)(potentialMatches.size() == 1 ? matchString : "any of " + matchString) + "?";
            }
            throw new ParsingException(ParserUtils.source((TerminalNode)ctx.IDENTIFIER()), (String)msg, name);
        }
        switch (name) {
            case "head": {
                Expression headLimit = this.pipeIntArgument(ParserUtils.source((ParserRuleContext)ctx), name, ctx.booleanExpression());
                return new Head(ParserUtils.source((ParserRuleContext)ctx), headLimit, plan);
            }
            case "tail": {
                Expression tailLimit = this.pipeIntArgument(ParserUtils.source((ParserRuleContext)ctx), name, ctx.booleanExpression());
                return new Tail(ParserUtils.source((ParserRuleContext)ctx), tailLimit, plan);
            }
        }
        throw new ParsingException(ParserUtils.source((ParserRuleContext)ctx), "Pipe [{}] is not supported", name);
    }

    private Expression onlyOnePipeArgument(Source source, String pipeName, List<EqlBaseParser.BooleanExpressionContext> exps) {
        int size;
        int n = size = CollectionUtils.isEmpty(exps) ? 0 : exps.size();
        if (size != 1) {
            throw new ParsingException(source, "Pipe [{}] expects exactly one argument but found [{}]", pipeName, size);
        }
        return this.expression((ParseTree)exps.get(0));
    }

    private Expression pipeIntArgument(Source source, String pipeName, List<EqlBaseParser.BooleanExpressionContext> exps) {
        Expression expression = this.onlyOnePipeArgument(source, pipeName, exps);
        if (!expression.dataType().isInteger() || !expression.foldable() || (Integer)expression.fold() < 0) {
            throw new ParsingException(expression.source(), "Pipe [{}] expects a positive integer but found [{}]", pipeName, expression.sourceText());
        }
        return expression;
    }
}

