/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchRequestBuilder;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.execution.search.HitReference;
import org.elasticsearch.xpack.eql.execution.search.QueryClient;
import org.elasticsearch.xpack.eql.execution.search.QueryRequest;
import org.elasticsearch.xpack.eql.execution.search.RuntimeUtils;
import org.elasticsearch.xpack.eql.session.EqlConfiguration;
import org.elasticsearch.xpack.eql.session.EqlSession;
import org.elasticsearch.xpack.ql.util.StringUtils;

public class BasicQueryClient
implements QueryClient {
    private static final Logger log = RuntimeUtils.QUERY_LOG;
    final EqlConfiguration cfg;
    final Client client;
    final String[] indices;
    final List<FieldAndFormat> fetchFields;

    public BasicQueryClient(EqlSession eqlSession) {
        this.cfg = eqlSession.configuration();
        this.client = eqlSession.client();
        this.indices = this.cfg.indices();
        this.fetchFields = this.cfg.fetchFields();
    }

    @Override
    public void query(QueryRequest request, ActionListener<SearchResponse> listener) {
        SearchSourceBuilder searchSource = request.searchSource();
        searchSource.timeout(this.cfg.requestTimeout());
        SearchRequest search = RuntimeUtils.prepareRequest(searchSource, false, this.indices);
        this.search(search, RuntimeUtils.searchLogListener(listener, log));
    }

    protected void search(SearchRequest search, ActionListener<SearchResponse> listener) {
        if (this.cfg.isCancelled()) {
            listener.onFailure((Exception)new TaskCancelledException("cancelled"));
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("About to execute query {} on {}", (Object)StringUtils.toString((SearchSourceBuilder)search.source()), (Object)this.indices);
        }
        this.client.search(search, listener);
    }

    protected void search(MultiSearchRequest search, ActionListener<MultiSearchResponse> listener) {
        if (this.cfg.isCancelled()) {
            listener.onFailure((Exception)new TaskCancelledException("cancelled"));
            return;
        }
        if (log.isTraceEnabled()) {
            StringJoiner sj = new StringJoiner("\n");
            for (SearchRequest request : search.requests()) {
                sj.add(StringUtils.toString((SearchSourceBuilder)request.source()));
            }
            log.trace("About to execute multi-queries {} on {}", (Object)sj, (Object)this.indices);
        }
        this.client.multiSearch(search, RuntimeUtils.multiSearchLogListener(listener, log));
    }

    @Override
    public void fetchHits(Iterable<List<HitReference>> refs, ActionListener<List<List<SearchHit>>> listener) {
        int innerListSize = 0;
        HashMap<String, IdsQueryBuilder> queries = new HashMap<String, IdsQueryBuilder>();
        HashMap<HitReference, List> referenceToPosition = new HashMap<HitReference, List>();
        int counter = 0;
        for (List<HitReference> list : refs) {
            innerListSize = list.size();
            for (HitReference ref : list) {
                IdsQueryBuilder query = queries.computeIfAbsent(ref.index(), v -> QueryBuilders.idsQuery());
                query.addIds(new String[]{ref.id()});
                List positions = referenceToPosition.computeIfAbsent(ref, v -> new ArrayList(1));
                positions.add(counter++);
            }
        }
        int listSize = innerListSize;
        int topListSize = counter / listSize;
        List[] hits = new List[topListSize];
        for (int i = 0; i < hits.length; ++i) {
            hits[i] = Arrays.asList(new SearchHit[listSize]);
        }
        List<List> seq = Arrays.asList(hits);
        MultiSearchRequestBuilder multiSearchBuilder = this.client.prepareMultiSearch();
        for (Map.Entry entry : queries.entrySet()) {
            IdsQueryBuilder idQuery = (IdsQueryBuilder)entry.getValue();
            SearchSourceBuilder builder = SearchSourceBuilder.searchSource().fetchSource(FetchSourceContext.FETCH_SOURCE).trackTotalHits(false).trackScores(false).query((QueryBuilder)idQuery).size(idQuery.ids().size());
            if (this.fetchFields != null) {
                this.fetchFields.forEach(arg_0 -> ((SearchSourceBuilder)builder).fetchField(arg_0));
            }
            if (this.cfg.runtimeMappings() != null) {
                builder.runtimeMappings(this.cfg.runtimeMappings());
            }
            SearchRequest search = RuntimeUtils.prepareRequest(builder, false, (String)entry.getKey());
            multiSearchBuilder.add(search);
        }
        this.search((MultiSearchRequest)multiSearchBuilder.request(), (ActionListener<MultiSearchResponse>)ActionListener.wrap(r -> {
            for (MultiSearchResponse.Item item : r.getResponses()) {
                if (item.isFailure()) {
                    listener.onFailure(item.getFailure());
                    return;
                }
                List<SearchHit> docs = RuntimeUtils.searchHits(item.getResponse());
                for (SearchHit doc : docs) {
                    HitReference docRef = new HitReference(doc);
                    List positions = (List)referenceToPosition.get(docRef);
                    positions.forEach(pos -> {
                        SearchHit previous = ((List)seq.get(pos / listSize)).set(pos % listSize, doc);
                        if (previous != null) {
                            throw new EqlIllegalArgumentException("Overriding sequence match [{}] with [{}]", new HitReference(previous), docRef);
                        }
                    });
                }
            }
            listener.onResponse((Object)seq);
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

