/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.h3;

import org.elasticsearch.h3.Constants;
import org.elasticsearch.h3.FaceIJK;
import org.elasticsearch.h3.H3Index;
import org.elasticsearch.h3.Vec2d;
import org.elasticsearch.h3.Vec3d;

public final class LatLng {
    private final double lon;
    private final double lat;

    LatLng(double lat, double lon) {
        this.lon = lon;
        this.lat = lat;
    }

    public double getLatRad() {
        return this.lat;
    }

    public double getLonRad() {
        return this.lon;
    }

    public double getLatDeg() {
        return Math.toDegrees(this.getLatRad());
    }

    public double getLonDeg() {
        return Math.toDegrees(this.getLonRad());
    }

    FaceIJK geoToFaceIJK(int res) {
        Vec3d v3d = new Vec3d(this);
        int face = 0;
        double sqd = v3d.pointSquareDist(Vec3d.faceCenterPoint[0]);
        for (int i = 1; i < Vec3d.faceCenterPoint.length; ++i) {
            double sqdT = v3d.pointSquareDist(Vec3d.faceCenterPoint[i]);
            if (!(sqdT < sqd)) continue;
            face = i;
            sqd = sqdT;
        }
        double r = Math.acos(1.0 - sqd / 2.0);
        if (r < Constants.EPSILON) {
            return new FaceIJK(face, new Vec2d(0.0, 0.0).hex2dToCoordIJK());
        }
        double theta = Vec2d.posAngleRads(Vec2d.faceAxesAzRadsCII[face][0] - Vec2d.posAngleRads(Vec2d.faceCenterGeo[face].geoAzimuthRads(this)));
        if (H3Index.isResolutionClassIII(res)) {
            theta = Vec2d.posAngleRads(theta - Constants.M_AP7_ROT_RADS);
        }
        r = Math.tan(r);
        r /= Constants.RES0_U_GNOMONIC;
        for (int i = 0; i < res; ++i) {
            r *= 2.6457513110645907;
        }
        Vec2d vec2d = new Vec2d(r * Math.cos(theta), r * Math.sin(theta));
        return new FaceIJK(face, vec2d.hex2dToCoordIJK());
    }

    private double geoAzimuthRads(LatLng p) {
        return Math.atan2(Math.cos(p.lat) * Math.sin(p.lon - this.lon), Math.cos(this.lat) * Math.sin(p.lat) - Math.sin(this.lat) * Math.cos(p.lat) * Math.cos(p.lon - this.lon));
    }
}

