/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.h3.H3;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoGridAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.GeoGridAggregatorSupplier;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoHexGridAggregatorFactory;

public class GeoHexGridAggregationBuilder
extends GeoGridAggregationBuilder {
    public static final String NAME = "geohex_grid";
    private static final int DEFAULT_PRECISION = 5;
    private static final int DEFAULT_MAX_NUM_CELLS = 10000;
    public static final ValuesSourceRegistry.RegistryKey<GeoGridAggregatorSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey("geohex_grid", GeoGridAggregatorSupplier.class);
    public static final ObjectParser<GeoHexGridAggregationBuilder, String> PARSER = GeoHexGridAggregationBuilder.createParser((String)"geohex_grid", GeoHexGridAggregationBuilder::parsePrecision, GeoHexGridAggregationBuilder::new);

    static int parsePrecision(XContentParser parser) throws IOException, ElasticsearchParseException {
        Object node = parser.currentToken().equals((Object)XContentParser.Token.VALUE_NUMBER) ? Integer.valueOf(parser.intValue()) : parser.text();
        return XContentMapValues.nodeIntegerValue((Object)node);
    }

    public GeoHexGridAggregationBuilder(String name) {
        super(name);
        this.precision(5);
        this.size(10000);
        this.shardSize = -1;
    }

    public GeoHexGridAggregationBuilder(StreamInput in) throws IOException {
        super(in);
    }

    public GeoGridAggregationBuilder precision(int precision) {
        if (precision < 0 || precision > H3.MAX_H3_RES) {
            throw new IllegalArgumentException("Invalid geohex aggregation precision of " + precision + ". Must be between 0 and " + H3.MAX_H3_RES);
        }
        this.precision = precision;
        return this;
    }

    protected ValuesSourceAggregatorFactory createFactory(String name, ValuesSourceConfig config, int precision, int requiredSize, int shardSize, GeoBoundingBox geoBoundingBox, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        return new GeoHexGridAggregatorFactory(name, config, precision, requiredSize, shardSize, geoBoundingBox, context, parent, subFactoriesBuilder, metadata);
    }

    private GeoHexGridAggregationBuilder(GeoHexGridAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((GeoGridAggregationBuilder)clone, factoriesBuilder, metadata);
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new GeoHexGridAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public String getType() {
        return NAME;
    }

    protected ValuesSourceRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }
}

