/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.h3.CellBoundary;
import org.elasticsearch.h3.H3;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.bucket.geogrid.CellValues;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class GeoHexCellIdSource
extends ValuesSource.Numeric {
    private final ValuesSource.GeoPoint valuesSource;
    private final int precision;
    private final GeoBoundingBox geoBoundingBox;

    public GeoHexCellIdSource(ValuesSource.GeoPoint valuesSource, int precision, GeoBoundingBox geoBoundingBox) {
        this.valuesSource = valuesSource;
        this.precision = precision;
        this.geoBoundingBox = geoBoundingBox;
    }

    public int precision() {
        return this.precision;
    }

    public boolean isFloatingPoint() {
        return false;
    }

    public SortedNumericDocValues longValues(LeafReaderContext ctx) {
        return this.geoBoundingBox.isUnbounded() ? new UnboundedCellValues(this.valuesSource.geoPointValues(ctx), this.precision) : new BoundedCellValues(this.valuesSource.geoPointValues(ctx), this.precision, this.geoBoundingBox);
    }

    public SortedNumericDoubleValues doubleValues(LeafReaderContext ctx) {
        throw new UnsupportedOperationException();
    }

    public SortedBinaryDocValues bytesValues(LeafReaderContext ctx) {
        throw new UnsupportedOperationException();
    }

    private static class UnboundedCellValues
    extends CellValues {
        UnboundedCellValues(MultiGeoPointValues geoValues, int precision) {
            super(geoValues, precision);
        }

        protected int advanceValue(GeoPoint target, int valuesIdx) {
            this.values[valuesIdx] = H3.geoToH3((double)target.getLat(), (double)target.getLon(), (int)this.precision);
            return valuesIdx + 1;
        }
    }

    private static class BoundedCellValues
    extends CellValues {
        private final boolean crossesDateline;
        private final GeoBoundingBox bbox;

        protected BoundedCellValues(MultiGeoPointValues geoValues, int precision, GeoBoundingBox bbox) {
            super(geoValues, precision);
            this.crossesDateline = bbox.right() < bbox.left();
            this.bbox = bbox;
        }

        public int advanceValue(GeoPoint target, int valuesIdx) {
            double lat = target.getLat();
            double lon = target.getLon();
            long hex = H3.geoToH3((double)lat, (double)lon, (int)this.precision);
            if (this.validPoint(lat, lon) || this.validHex(hex)) {
                this.values[valuesIdx] = hex;
                return valuesIdx + 1;
            }
            return valuesIdx;
        }

        private boolean validPoint(double lat, double lon) {
            if (this.bbox.top() > lat && this.bbox.bottom() < lat) {
                if (this.crossesDateline) {
                    return this.bbox.left() < lon || this.bbox.right() > lon;
                }
                return this.bbox.left() < lon && this.bbox.right() > lon;
            }
            return false;
        }

        private boolean validHex(long hex) {
            CellBoundary boundary = H3.h3ToGeoBoundary((long)hex);
            double minLat = Double.POSITIVE_INFINITY;
            double minLon = Double.POSITIVE_INFINITY;
            double maxLat = Double.NEGATIVE_INFINITY;
            double maxLon = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < boundary.numPoints(); ++i) {
                double boundaryLat = boundary.getLatLon(i).getLatDeg();
                double boundaryLon = boundary.getLatLon(i).getLonDeg();
                minLon = Math.min(minLon, boundaryLon);
                maxLon = Math.max(maxLon, boundaryLon);
                minLat = Math.min(minLat, boundaryLat);
                maxLat = Math.max(maxLat, boundaryLat);
            }
            if (maxLon - minLon > 180.0) {
                return this.intersects(-180.0, minLon, minLat, maxLat) || this.intersects(maxLon, 180.0, minLat, maxLat);
            }
            return this.intersects(minLon, maxLon, minLat, maxLat);
        }

        private boolean intersects(double minLon, double maxLon, double minLat, double maxLat) {
            if (this.bbox.top() > minLat && this.bbox.bottom() < maxLat) {
                if (this.crossesDateline) {
                    return this.bbox.left() < maxLon || this.bbox.right() > minLon;
                }
                return this.bbox.left() < maxLon && this.bbox.right() > minLon;
            }
            return false;
        }
    }
}

