/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeometryFormatterFactory;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoShapeFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.spatial.index.mapper.ShapeIndexer;
import org.elasticsearch.xpack.spatial.index.mapper.ShapeParser;
import org.elasticsearch.xpack.spatial.index.mapper.ShapeQueryable;
import org.elasticsearch.xpack.spatial.index.query.ShapeQueryProcessor;

public class ShapeFieldMapper
extends AbstractShapeGeometryFieldMapper<Geometry> {
    public static final String CONTENT_TYPE = "shape";
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(GeoShapeFieldMapper.class);
    public static FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings()), (Boolean)COERCE_SETTING.get(c.getSettings())));
    private final Builder builder;
    private final ShapeIndexer indexer;

    private static Builder builder(FieldMapper in) {
        return ((ShapeFieldMapper)in).builder;
    }

    public ShapeFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, AbstractGeometryFieldMapper.Parser<Geometry> parser, Builder builder) {
        super(simpleName, mappedFieldType, (Explicit)builder.ignoreMalformed.get(), (Explicit)builder.coerce.get(), (Explicit)builder.ignoreZValue.get(), (Explicit)builder.orientation.get(), multiFields, copyTo, parser);
        this.builder = builder;
        this.indexer = new ShapeIndexer(mappedFieldType.name());
    }

    protected void index(DocumentParserContext context, Geometry geometry) throws IOException {
        if (geometry == null) {
            return;
        }
        context.doc().addAll(this.indexer.indexShape(geometry));
        context.addToFieldNames(this.fieldType().name());
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), (Boolean)((Explicit)this.builder.ignoreMalformed.getDefaultValue()).value(), (Boolean)((Explicit)this.builder.coerce.getDefaultValue()).value()).init((FieldMapper)this);
    }

    public ShapeFieldType fieldType() {
        return (ShapeFieldType)super.fieldType();
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> (Boolean)ShapeFieldMapper.builder((FieldMapper)m).indexed.get(), (boolean)true);
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> (Explicit)ShapeFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        final FieldMapper.Parameter<Explicit<Orientation>> orientation = AbstractShapeGeometryFieldMapper.orientationParam(m -> (Explicit)ShapeFieldMapper.builder((FieldMapper)m).orientation.get());
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name, boolean ignoreMalformedByDefault, boolean coerceByDefault) {
            super(name);
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> (Explicit)ShapeFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), (boolean)ignoreMalformedByDefault);
            this.coerce = AbstractShapeGeometryFieldMapper.coerceParam(m -> (Explicit)ShapeFieldMapper.builder((FieldMapper)m).coerce.get(), (boolean)coerceByDefault);
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.ignoreMalformed, this.ignoreZValue, this.coerce, this.orientation, this.meta);
        }

        public ShapeFieldMapper build(MapperBuilderContext context) {
            if (this.multiFieldsBuilder.hasMultiFields()) {
                DEPRECATION_LOGGER.warn(DeprecationCategory.MAPPINGS, "shape_multifields", "Adding multifields to [shape] mappers has no effect and will be forbidden in future", new Object[0]);
            }
            GeometryParser geometryParser = new GeometryParser(((Orientation)((Explicit)this.orientation.get()).value()).getAsBoolean(), ((Boolean)((Explicit)this.coerce.get()).value()).booleanValue(), ((Boolean)((Explicit)this.ignoreZValue.get()).value()).booleanValue());
            ShapeParser parser = new ShapeParser(geometryParser);
            ShapeFieldType ft = new ShapeFieldType(context.buildFullName(this.name), (Boolean)this.indexed.get(), (Orientation)((Explicit)this.orientation.get()).value(), parser, (Map)this.meta.get());
            return new ShapeFieldMapper(this.name, (MappedFieldType)ft, this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build(), parser, this);
        }
    }

    public static final class ShapeFieldType
    extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType<Geometry>
    implements ShapeQueryable {
        private final ShapeQueryProcessor queryProcessor = new ShapeQueryProcessor();

        public ShapeFieldType(String name, boolean indexed, Orientation orientation, AbstractGeometryFieldMapper.Parser<Geometry> parser, Map<String, String> meta) {
            super(name, indexed, false, false, parser, orientation, meta);
        }

        @Override
        public Query shapeQuery(Geometry shape, String fieldName, ShapeRelation relation, SearchExecutionContext context) {
            return this.queryProcessor.shapeQuery(shape, fieldName, relation, context);
        }

        public String typeName() {
            return ShapeFieldMapper.CONTENT_TYPE;
        }

        protected Function<List<Geometry>, List<Object>> getFormatter(String format) {
            return GeometryFormatterFactory.getFormatter((String)format, Function.identity());
        }
    }
}

