/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata.plain;

import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.SphericalMercatorUtils;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.script.field.DocValuesField;
import org.elasticsearch.script.field.ToScriptField;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.LeafGeoShapeFieldData;

public abstract class AbstractAtomicGeoShapeShapeFieldData
implements LeafGeoShapeFieldData {
    private final ToScriptField<GeoShapeValues> toScriptField;

    public AbstractAtomicGeoShapeShapeFieldData(ToScriptField<GeoShapeValues> toScriptField) {
        this.toScriptField = toScriptField;
    }

    public final SortedBinaryDocValues getBytesValues() {
        throw new UnsupportedOperationException("scripts and term aggs are not supported by geo_shape doc values");
    }

    public final DocValuesField<?> getScriptField(String name) {
        return this.toScriptField.getScriptField((Object)this.getGeoShapeValues(), name);
    }

    public static LeafGeoShapeFieldData empty(int maxDoc, ToScriptField<GeoShapeValues> toScriptField) {
        return new AbstractAtomicGeoShapeShapeFieldData((ToScriptField)toScriptField){

            public long ramBytesUsed() {
                return 0L;
            }

            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }

            public void close() {
            }

            @Override
            public GeoShapeValues getGeoShapeValues() {
                return GeoShapeValues.EMPTY;
            }
        };
    }

    public static final class GeoShapeScriptValues
    extends ScriptDocValues.Geometry<GeoShapeValues.GeoShapeValue> {
        private final ScriptDocValues.GeometrySupplier<GeoShapeValues.GeoShapeValue> gsSupplier;

        public GeoShapeScriptValues(ScriptDocValues.GeometrySupplier<GeoShapeValues.GeoShapeValue> supplier) {
            super(supplier);
            this.gsSupplier = supplier;
        }

        public int getDimensionalType() {
            return this.gsSupplier.getInternal(0) == null ? -1 : ((GeoShapeValues.GeoShapeValue)this.gsSupplier.getInternal(0)).dimensionalShapeType().ordinal();
        }

        public GeoPoint getCentroid() {
            return this.gsSupplier.getInternal(0) == null ? null : this.gsSupplier.getInternalCentroid();
        }

        public double getMercatorWidth() {
            return SphericalMercatorUtils.lonToSphericalMercator((double)this.getBoundingBox().right()) - SphericalMercatorUtils.lonToSphericalMercator((double)this.getBoundingBox().left());
        }

        public double getMercatorHeight() {
            return SphericalMercatorUtils.latToSphericalMercator((double)this.getBoundingBox().top()) - SphericalMercatorUtils.latToSphericalMercator((double)this.getBoundingBox().bottom());
        }

        public GeoBoundingBox getBoundingBox() {
            return this.gsSupplier.getInternal(0) == null ? null : this.gsSupplier.getInternalBoundingBox();
        }

        public GeoShapeValues.GeoShapeValue get(int index) {
            return (GeoShapeValues.GeoShapeValue)this.gsSupplier.getInternal(0);
        }

        public GeoShapeValues.GeoShapeValue getValue() {
            return (GeoShapeValues.GeoShapeValue)this.gsSupplier.getInternal(0);
        }

        public int size() {
            return this.supplier.size();
        }
    }
}

