/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import java.io.IOException;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;

class TriangleTreeReader {
    private TriangleTreeReader() {
    }

    public static void visit(ByteArrayStreamInput input, Visitor visitor, int thisMaxX, int thisMaxY) throws IOException {
        TriangleTreeReader.visit(input, visitor, true, thisMaxX, thisMaxY, true);
    }

    private static boolean visit(ByteArrayStreamInput input, Visitor visitor, boolean splitX, int thisMaxX, int thisMaxY, boolean isRoot) throws IOException {
        int thisMinY;
        int thisMinX;
        byte metadata = input.readByte();
        if ((metadata & 4) == 4) {
            int x = Math.toIntExact((long)thisMaxX - input.readVLong());
            int y = Math.toIntExact((long)thisMaxY - input.readVLong());
            visitor.visitPoint(x, y);
            if (!visitor.push()) {
                return false;
            }
            thisMinX = x;
            thisMinY = y;
        } else if ((metadata & 8) == 8) {
            aX = Math.toIntExact((long)thisMaxX - input.readVLong());
            int aY = Math.toIntExact((long)thisMaxY - input.readVLong());
            int bX = Math.toIntExact((long)thisMaxX - input.readVLong());
            int bY = Math.toIntExact((long)thisMaxY - input.readVLong());
            visitor.visitLine(aX, aY, bX, bY, metadata);
            if (!visitor.push()) {
                return false;
            }
            thisMinX = aX;
            thisMinY = Math.min(aY, bY);
        } else {
            aX = Math.toIntExact((long)thisMaxX - input.readVLong());
            int aY = Math.toIntExact((long)thisMaxY - input.readVLong());
            int bX = Math.toIntExact((long)thisMaxX - input.readVLong());
            int bY = Math.toIntExact((long)thisMaxY - input.readVLong());
            int cX = Math.toIntExact((long)thisMaxX - input.readVLong());
            int cY = Math.toIntExact((long)thisMaxY - input.readVLong());
            visitor.visitTriangle(aX, aY, bX, bY, cX, cY, metadata);
            if (!visitor.push()) {
                return false;
            }
            thisMinX = aX;
            thisMinY = Math.min(Math.min(aY, bY), cY);
        }
        if ((metadata & 1) == 1 && !TriangleTreeReader.pushLeft(input, visitor, thisMaxX, thisMaxY, splitX)) {
            return false;
        }
        if ((metadata & 2) == 2) {
            int rightSize;
            int n = rightSize = isRoot ? 0 : input.readVInt();
            if (!TriangleTreeReader.pushRight(input, visitor, thisMaxX, thisMaxY, thisMinX, thisMinY, splitX, rightSize)) {
                return false;
            }
        }
        return visitor.push();
    }

    private static boolean pushLeft(ByteArrayStreamInput input, Visitor visitor, int thisMaxX, int thisMaxY, boolean splitX) throws IOException {
        int nextMaxX = Math.toIntExact((long)thisMaxX - input.readVLong());
        int nextMaxY = Math.toIntExact((long)thisMaxY - input.readVLong());
        int size = input.readVInt();
        if (visitor.push(nextMaxX, nextMaxY)) {
            return TriangleTreeReader.visit(input, visitor, !splitX, nextMaxX, nextMaxY, false);
        }
        input.skipBytes((long)size);
        return visitor.push();
    }

    private static boolean pushRight(ByteArrayStreamInput input, Visitor visitor, int thisMaxX, int thisMaxY, int thisMinX, int thisMinY, boolean splitX, int rightSize) throws IOException {
        if (!splitX && visitor.pushY(thisMinY) || splitX && visitor.pushX(thisMinX)) {
            int nextMaxX = Math.toIntExact((long)thisMaxX - input.readVLong());
            int nextMaxY = Math.toIntExact((long)thisMaxY - input.readVLong());
            int size = input.readVInt();
            if (visitor.push(nextMaxX, nextMaxY)) {
                return TriangleTreeReader.visit(input, visitor, !splitX, nextMaxX, nextMaxY, false);
            }
            input.skipBytes((long)size);
        } else {
            input.skipBytes((long)rightSize);
        }
        return visitor.push();
    }

    static interface Visitor {
        public void visitPoint(int var1, int var2);

        public void visitLine(int var1, int var2, int var3, int var4, byte var5);

        public void visitTriangle(int var1, int var2, int var3, int var4, int var5, int var6, byte var7);

        public boolean push();

        public boolean pushX(int var1);

        public boolean pushY(int var1);

        public boolean push(int var1, int var2);

        public boolean push(int var1, int var2, int var3, int var4);
    }
}

