/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import java.io.IOException;
import java.text.ParseException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.GeographyValidator;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.spatial.index.fielddata.CoordinateEncoder;
import org.elasticsearch.xpack.spatial.index.fielddata.DimensionalShapeType;
import org.elasticsearch.xpack.spatial.index.fielddata.Extent;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;
import org.elasticsearch.xpack.spatial.index.fielddata.GeometryDocValueReader;
import org.elasticsearch.xpack.spatial.index.fielddata.Tile2DVisitor;
import org.elasticsearch.xpack.spatial.index.mapper.BinaryGeoShapeDocValuesField;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSourceType;

public abstract class GeoShapeValues {
    public static GeoShapeValues EMPTY = new GeoShapeValues(){
        private final GeoShapeValuesSourceType DEFAULT_VALUES_SOURCE_TYPE = GeoShapeValuesSourceType.instance();

        @Override
        public boolean advanceExact(int doc) {
            return false;
        }

        @Override
        public ValuesSourceType valuesSourceType() {
            return this.DEFAULT_VALUES_SOURCE_TYPE;
        }

        @Override
        public GeoShapeValue value() {
            throw new UnsupportedOperationException();
        }
    };

    protected GeoShapeValues() {
    }

    public abstract boolean advanceExact(int var1) throws IOException;

    public abstract ValuesSourceType valuesSourceType();

    public abstract GeoShapeValue value() throws IOException;

    public static class BoundingBox {
        public double top;
        public double bottom;
        public double negLeft;
        public double negRight;
        public double posLeft;
        public double posRight;

        private BoundingBox() {
        }

        private void reset(Extent extent, CoordinateEncoder coordinateEncoder) {
            this.top = coordinateEncoder.decodeY(extent.top);
            this.bottom = coordinateEncoder.decodeY(extent.bottom);
            if (extent.negLeft == Integer.MAX_VALUE && extent.negRight == Integer.MIN_VALUE) {
                this.negLeft = Double.POSITIVE_INFINITY;
                this.negRight = Double.NEGATIVE_INFINITY;
            } else {
                this.negLeft = coordinateEncoder.decodeX(extent.negLeft);
                this.negRight = coordinateEncoder.decodeX(extent.negRight);
            }
            if (extent.posLeft == Integer.MAX_VALUE && extent.posRight == Integer.MIN_VALUE) {
                this.posLeft = Double.POSITIVE_INFINITY;
                this.posRight = Double.NEGATIVE_INFINITY;
            } else {
                this.posLeft = coordinateEncoder.decodeX(extent.posLeft);
                this.posRight = coordinateEncoder.decodeX(extent.posRight);
            }
        }

        public double minY() {
            return this.bottom;
        }

        public double maxY() {
            return this.top;
        }

        public double minX() {
            return Math.min(this.negLeft, this.posLeft);
        }

        public double maxX() {
            return Math.max(this.negRight, this.posRight);
        }
    }

    public static class GeoShapeValue
    implements ToXContentFragment {
        private static final GeoShapeIndexer MISSING_GEOSHAPE_INDEXER = new GeoShapeIndexer(Orientation.CCW, "missing");
        private final GeometryDocValueReader reader = new GeometryDocValueReader();
        private final BoundingBox boundingBox = new BoundingBox();
        private final Tile2DVisitor tile2DVisitor = new Tile2DVisitor();

        public void reset(BytesRef bytesRef) throws IOException {
            this.reader.reset(bytesRef);
            this.boundingBox.reset(this.reader.getExtent(), CoordinateEncoder.GEO);
        }

        public BoundingBox boundingBox() {
            return this.boundingBox;
        }

        public GeoRelation relate(Rectangle rectangle) throws IOException {
            int minX = CoordinateEncoder.GEO.encodeX(rectangle.getMinX());
            int maxX = CoordinateEncoder.GEO.encodeX(rectangle.getMaxX());
            int minY = CoordinateEncoder.GEO.encodeY(rectangle.getMinY());
            int maxY = CoordinateEncoder.GEO.encodeY(rectangle.getMaxY());
            this.tile2DVisitor.reset(minX, minY, maxX, maxY);
            this.reader.visit(this.tile2DVisitor);
            return this.tile2DVisitor.relation();
        }

        public DimensionalShapeType dimensionalShapeType() {
            return this.reader.getDimensionalShapeType();
        }

        public double weight() throws IOException {
            return this.reader.getSumCentroidWeight();
        }

        public double lat() throws IOException {
            return CoordinateEncoder.GEO.decodeY(this.reader.getCentroidY());
        }

        public double lon() throws IOException {
            return CoordinateEncoder.GEO.decodeX(this.reader.getCentroidX());
        }

        public static GeoShapeValue missing(String missing) {
            try {
                Geometry geometry = WellKnownText.fromWKT((GeometryValidator)GeographyValidator.instance((boolean)true), (boolean)true, (String)missing);
                BinaryGeoShapeDocValuesField field = new BinaryGeoShapeDocValuesField("missing");
                field.add(MISSING_GEOSHAPE_INDEXER.indexShape(geometry), geometry);
                GeoShapeValue value = new GeoShapeValue();
                value.reset(field.binaryValue());
                return value;
            }
            catch (IOException | ParseException e) {
                throw new IllegalArgumentException("Can't apply missing value [" + missing + "]", e);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            throw new IllegalArgumentException("cannot write xcontent for geo_shape doc value");
        }
    }
}

