/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.frozen.rest.action;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.protocol.xpack.frozen.FreezeRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.frozen.action.FreezeIndexAction;

public final class RestFreezeIndexAction
extends BaseRestHandler {
    private static final String FREEZE_REMOVED = "It is no longer possible to freeze indices, but existing frozen indices can still be unfrozen";
    private static final String UNFREEZE_DEPRECATED = "Frozen indices are deprecated because they provide no benefit given improvements in heap memory utilization. They will be removed in a future release.";

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/{index}/_freeze").deprecated(FREEZE_REMOVED, RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/{index}/_unfreeze").deprecated(UNFREEZE_DEPRECATED, RestApiVersion.V_8).build());
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        if (request.getRestApiVersion() == RestApiVersion.V_7 && request.path().endsWith("/_freeze")) {
            GetIndexRequest getIndexRequest = new GetIndexRequest();
            getIndexRequest.indices(Strings.splitStringByCommaToArray((String)request.param("index")));
            getIndexRequest.masterNodeTimeout(request.paramAsTime("master_timeout", getIndexRequest.masterNodeTimeout()));
            getIndexRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)getIndexRequest.indicesOptions()));
            return channel -> client.admin().indices().getIndex(getIndexRequest, (ActionListener)new RestBuilderListener<GetIndexResponse>(channel){

                public RestResponse buildResponse(GetIndexResponse getIndexResponse, XContentBuilder builder) throws Exception {
                    builder.close();
                    return new BytesRestResponse(this.channel, RestStatus.GONE, (Exception)new UnsupportedOperationException(RestFreezeIndexAction.FREEZE_REMOVED));
                }
            });
        }
        FreezeRequest freezeRequest = new FreezeRequest(Strings.splitStringByCommaToArray((String)request.param("index")));
        freezeRequest.timeout(request.paramAsTime("timeout", freezeRequest.timeout()));
        freezeRequest.masterNodeTimeout(request.paramAsTime("master_timeout", freezeRequest.masterNodeTimeout()));
        freezeRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)freezeRequest.indicesOptions()));
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            freezeRequest.waitForActiveShards(ActiveShardCount.parseString((String)waitForActiveShards));
        }
        freezeRequest.setFreeze(false);
        return channel -> client.execute((ActionType)FreezeIndexAction.INSTANCE, (ActionRequest)freezeRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public String getName() {
        return "freeze_index";
    }
}

