/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.frozen.action;

import java.util.ArrayList;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexResponse;
import org.elasticsearch.action.admin.indices.open.OpenIndexClusterStateUpdateRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.frozen.FrozenEngine;
import org.elasticsearch.protocol.xpack.frozen.FreezeRequest;
import org.elasticsearch.protocol.xpack.frozen.FreezeResponse;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public final class TransportFreezeIndexAction
extends TransportMasterNodeAction<FreezeRequest, FreezeResponse> {
    private static final Logger logger = LogManager.getLogger(TransportFreezeIndexAction.class);
    private final DestructiveOperations destructiveOperations;
    private final MetadataIndexStateService indexStateService;

    @Inject
    public TransportFreezeIndexAction(MetadataIndexStateService indexStateService, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DestructiveOperations destructiveOperations) {
        super("indices:admin/freeze", transportService, clusterService, threadPool, actionFilters, FreezeRequest::new, indexNameExpressionResolver, FreezeResponse::new, "same");
        this.destructiveOperations = destructiveOperations;
        this.indexStateService = indexStateService;
    }

    protected void doExecute(Task task, FreezeRequest request, ActionListener<FreezeResponse> listener) {
        this.destructiveOperations.failDestructive(request.indices());
        super.doExecute(task, (MasterNodeRequest)request, listener);
    }

    private Index[] resolveIndices(FreezeRequest request, ClusterState state) {
        ArrayList<Index> indices = new ArrayList<Index>();
        for (Index index : this.indexNameExpressionResolver.concreteIndices(state, (IndicesRequest)request)) {
            IndexMetadata metadata = state.metadata().index(index);
            Settings settings = metadata.getSettings();
            if ((!request.freeze() || ((Boolean)FrozenEngine.INDEX_FROZEN.get(settings)).booleanValue()) && (request.freeze() || !((Boolean)FrozenEngine.INDEX_FROZEN.get(settings)).booleanValue())) continue;
            indices.add(index);
        }
        if (indices.isEmpty() && !request.indicesOptions().allowNoIndices()) {
            throw new ResourceNotFoundException("no index found to " + (request.freeze() ? "freeze" : "unfreeze"), new Object[0]);
        }
        return indices.toArray(Index.EMPTY_ARRAY);
    }

    protected void masterOperation(Task task, final FreezeRequest request, ClusterState state, final ActionListener<FreezeResponse> listener) {
        final Index[] concreteIndices = this.resolveIndices(request, state);
        if (concreteIndices.length == 0) {
            listener.onResponse((Object)new FreezeResponse(true, true));
            return;
        }
        CloseIndexClusterStateUpdateRequest closeRequest = (CloseIndexClusterStateUpdateRequest)((CloseIndexClusterStateUpdateRequest)((CloseIndexClusterStateUpdateRequest)new CloseIndexClusterStateUpdateRequest(task.getId()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).indices(concreteIndices);
        this.indexStateService.closeIndices(closeRequest, (ActionListener)new ActionListener<CloseIndexResponse>(){

            public void onResponse(CloseIndexResponse response) {
                if (response.isAcknowledged()) {
                    TransportFreezeIndexAction.this.toggleFrozenSettings(concreteIndices, request, (ActionListener<FreezeResponse>)listener);
                } else {
                    listener.onResponse((Object)new FreezeResponse(false, false));
                }
            }

            public void onFailure(Exception t) {
                logger.debug(() -> new ParameterizedMessage("failed to close indices [{}]", (Object)concreteIndices), (Throwable)t);
                listener.onFailure(t);
            }
        });
    }

    private void toggleFrozenSettings(final Index[] concreteIndices, final FreezeRequest request, ActionListener<FreezeResponse> listener) {
        this.clusterService.submitStateUpdateTask("toggle-frozen-settings", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask(Priority.URGENT, (AckedRequest)request, listener.delegateFailure((delegate, acknowledgedResponse) -> {
            OpenIndexClusterStateUpdateRequest updateRequest = ((OpenIndexClusterStateUpdateRequest)((OpenIndexClusterStateUpdateRequest)((OpenIndexClusterStateUpdateRequest)new OpenIndexClusterStateUpdateRequest().ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).indices(concreteIndices)).waitForActiveShards(request.waitForActiveShards());
            this.indexStateService.openIndex(updateRequest, delegate.delegateFailure((l, openIndexClusterStateUpdateResponse) -> l.onResponse((Object)new FreezeResponse(openIndexClusterStateUpdateResponse.isAcknowledged(), openIndexClusterStateUpdateResponse.isShardsAcknowledged()))));
        })){

            public ClusterState execute(ClusterState currentState) {
                ArrayList<String> writeIndices = new ArrayList<String>();
                SortedMap lookup = currentState.metadata().getIndicesLookup();
                for (Index index : concreteIndices) {
                    IndexAbstraction ia = (IndexAbstraction)lookup.get(index.getName());
                    if (ia == null || ia.getParentDataStream() == null || !ia.getParentDataStream().getWriteIndex().equals((Object)index)) continue;
                    writeIndices.add(index.getName());
                }
                if (writeIndices.size() > 0) {
                    throw new IllegalArgumentException("cannot freeze the following data stream write indices [" + Strings.collectionToCommaDelimitedString(writeIndices) + "]");
                }
                Metadata.Builder builder = Metadata.builder((Metadata)currentState.metadata());
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                for (Index index : concreteIndices) {
                    IndexMetadata indexMetadata = currentState.metadata().getIndexSafe(index);
                    if (indexMetadata.getState() != IndexMetadata.State.CLOSE) {
                        throw new IllegalStateException("index [" + index.getName() + "] is not closed");
                    }
                    Settings.Builder settingsBuilder = Settings.builder().put(indexMetadata.getSettings());
                    if (request.freeze()) {
                        settingsBuilder.put(FrozenEngine.INDEX_FROZEN.getKey(), true);
                        settingsBuilder.put(IndexSettings.INDEX_SEARCH_THROTTLED.getKey(), true);
                        settingsBuilder.put("index.blocks.write", true);
                        blocks.addIndexBlock(index.getName(), IndexMetadata.INDEX_WRITE_BLOCK);
                    } else {
                        settingsBuilder.remove(FrozenEngine.INDEX_FROZEN.getKey());
                        settingsBuilder.remove(IndexSettings.INDEX_SEARCH_THROTTLED.getKey());
                        if (!indexMetadata.isSearchableSnapshot()) {
                            settingsBuilder.remove("index.blocks.write");
                            blocks.removeIndexBlock(index.getName(), IndexMetadata.INDEX_WRITE_BLOCK);
                        }
                    }
                    builder.put(IndexMetadata.builder((IndexMetadata)indexMetadata).settingsVersion(indexMetadata.getSettingsVersion() + 1L).settings(settingsBuilder).build(), true);
                }
                return ClusterState.builder((ClusterState)currentState).blocks(blocks).metadata(builder).build();
            }
        }, ClusterStateTaskExecutor.unbatched());
    }

    protected ClusterBlockException checkBlock(FreezeRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request));
    }
}

