/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.action.TransportResumeFollowAction;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.action.PutAutoFollowPatternAction;

public class TransportPutAutoFollowPatternAction
extends AcknowledgedTransportMasterNodeAction<PutAutoFollowPatternAction.Request> {
    private final Client client;
    private final CcrLicenseChecker ccrLicenseChecker;

    @Inject
    public TransportPutAutoFollowPatternAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Client client, IndexNameExpressionResolver indexNameExpressionResolver, CcrLicenseChecker ccrLicenseChecker) {
        super("cluster:admin/xpack/ccr/auto_follow_pattern/put", transportService, clusterService, threadPool, actionFilters, PutAutoFollowPatternAction.Request::new, indexNameExpressionResolver, "same");
        this.client = client;
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker, "ccrLicenseChecker");
    }

    protected void masterOperation(Task task, final PutAutoFollowPatternAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        if (!this.ccrLicenseChecker.isCcrAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ccr"));
            return;
        }
        Settings replicatedRequestSettings = TransportResumeFollowAction.filter(request.getSettings());
        if (!replicatedRequestSettings.isEmpty()) {
            String message = String.format(Locale.ROOT, "can not put auto-follow pattern that could override leader settings %s", replicatedRequestSettings);
            listener.onFailure((Exception)new IllegalArgumentException(message));
            return;
        }
        Client remoteClient = this.client.getRemoteClusterClient(request.getRemoteCluster());
        final Map filteredHeaders = ClientHelper.filterSecurityHeaders((Map)this.threadPool.getThreadContext().getHeaders());
        Consumer<ClusterStateResponse> consumer = remoteClusterState -> {
            String[] indices = request.getLeaderIndexPatterns().toArray(new String[0]);
            this.ccrLicenseChecker.hasPrivilegesToFollowIndices(remoteClient, indices, e -> {
                if (e == null) {
                    this.clusterService.submitStateUpdateTask("put-auto-follow-pattern-" + request.getRemoteCluster(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask((AckedRequest)request, (ActionListener)listener, (ClusterStateResponse)remoteClusterState){
                        final /* synthetic */ ClusterStateResponse val$remoteClusterState;
                        {
                            this.val$remoteClusterState = clusterStateResponse;
                            super(arg0, arg1);
                        }

                        public ClusterState execute(ClusterState currentState) {
                            return TransportPutAutoFollowPatternAction.innerPut(request, filteredHeaders, currentState, this.val$remoteClusterState.getState());
                        }
                    }, ClusterStateTaskExecutor.unbatched());
                } else {
                    listener.onFailure(e);
                }
            });
        };
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear();
        clusterStateRequest.metadata(true);
        this.ccrLicenseChecker.checkRemoteClusterLicenseAndFetchClusterState(this.client, request.getRemoteCluster(), clusterStateRequest, arg_0 -> listener.onFailure(arg_0), consumer);
    }

    static ClusterState innerPut(PutAutoFollowPatternAction.Request request, Map<String, String> filteredHeaders, ClusterState localState, ClusterState remoteClusterState) {
        HashMap<String, Map<String, String>> headers;
        HashMap<String, ArrayList<String>> followedLeaderIndices;
        HashMap<String, AutoFollowMetadata.AutoFollowPattern> patterns;
        AutoFollowMetadata currentAutoFollowMetadata = (AutoFollowMetadata)localState.metadata().custom("ccr_auto_follow");
        if (currentAutoFollowMetadata != null) {
            patterns = new HashMap(currentAutoFollowMetadata.getPatterns());
            followedLeaderIndices = new HashMap(currentAutoFollowMetadata.getFollowedLeaderIndexUUIDs());
            headers = new HashMap(currentAutoFollowMetadata.getHeaders());
        } else {
            patterns = new HashMap<String, AutoFollowMetadata.AutoFollowPattern>();
            followedLeaderIndices = new HashMap<String, ArrayList<String>>();
            headers = new HashMap<String, Map<String, String>>();
        }
        AutoFollowMetadata.AutoFollowPattern previousPattern = (AutoFollowMetadata.AutoFollowPattern)patterns.get(request.getName());
        ArrayList<String> followedIndexUUIDs = followedLeaderIndices.containsKey(request.getName()) ? new ArrayList((Collection)followedLeaderIndices.get(request.getName())) : new ArrayList<String>();
        followedLeaderIndices.put(request.getName(), followedIndexUUIDs);
        if (previousPattern != null) {
            TransportPutAutoFollowPatternAction.markExistingIndicesAsAutoFollowedForNewPatterns(request.getLeaderIndexPatterns(), request.getLeaderIndexExclusionPatterns(), remoteClusterState.metadata(), previousPattern, followedIndexUUIDs);
        } else {
            TransportPutAutoFollowPatternAction.markExistingIndicesAsAutoFollowed(request.getLeaderIndexPatterns(), request.getLeaderIndexExclusionPatterns(), remoteClusterState.metadata(), followedIndexUUIDs);
        }
        if (filteredHeaders != null) {
            headers.put(request.getName(), filteredHeaders);
        }
        AutoFollowMetadata.AutoFollowPattern autoFollowPattern = new AutoFollowMetadata.AutoFollowPattern(request.getRemoteCluster(), request.getLeaderIndexPatterns(), request.getLeaderIndexExclusionPatterns(), request.getFollowIndexNamePattern(), request.getSettings(), true, request.getParameters().getMaxReadRequestOperationCount(), request.getParameters().getMaxWriteRequestOperationCount(), request.getParameters().getMaxOutstandingReadRequests(), request.getParameters().getMaxOutstandingWriteRequests(), request.getParameters().getMaxReadRequestSize(), request.getParameters().getMaxWriteRequestSize(), request.getParameters().getMaxWriteBufferCount(), request.getParameters().getMaxWriteBufferSize(), request.getParameters().getMaxRetryDelay(), request.getParameters().getReadPollTimeout());
        patterns.put(request.getName(), autoFollowPattern);
        return localState.copyAndUpdateMetadata(metadata -> metadata.putCustom("ccr_auto_follow", (Metadata.Custom)new AutoFollowMetadata(patterns, followedLeaderIndices, headers)));
    }

    private static void markExistingIndicesAsAutoFollowedForNewPatterns(List<String> leaderIndexPatterns, List<String> leaderIndexExclusionPatterns, Metadata leaderMetadata, AutoFollowMetadata.AutoFollowPattern previousPattern, List<String> followedIndexUUIDS) {
        List<String> newPatterns = leaderIndexPatterns.stream().filter(p -> !previousPattern.getLeaderIndexPatterns().contains(p)).collect(Collectors.toList());
        TransportPutAutoFollowPatternAction.markExistingIndicesAsAutoFollowed(newPatterns, leaderIndexExclusionPatterns, leaderMetadata, followedIndexUUIDS);
    }

    private static void markExistingIndicesAsAutoFollowed(List<String> patterns, List<String> exclusionPatterns, Metadata leaderMetadata, List<String> followedIndexUUIDS) {
        for (IndexMetadata indexMetadata : leaderMetadata) {
            IndexAbstraction indexAbstraction = (IndexAbstraction)leaderMetadata.getIndicesLookup().get(indexMetadata.getIndex().getName());
            if (!AutoFollowMetadata.AutoFollowPattern.match(patterns, exclusionPatterns, (IndexAbstraction)indexAbstraction)) continue;
            followedIndexUUIDS.add(indexMetadata.getIndexUUID());
        }
    }

    protected ClusterBlockException checkBlock(PutAutoFollowPatternAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

