/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.persistent.CompletionPersistentTaskAction;
import org.elasticsearch.persistent.PersistentTaskResponse;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ccr.action.ShardFollowTask;

public class ShardFollowTaskCleaner
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(ShardFollowTaskCleaner.class);
    private final ThreadPool threadPool;
    private final Client client;

    public ShardFollowTaskCleaner(ClusterService clusterService, ThreadPool threadPool, Client client) {
        this.threadPool = threadPool;
        this.client = client;
        clusterService.addListener((ClusterStateListener)this);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (!event.localNodeMaster()) {
            return;
        }
        Metadata metadata = event.state().metadata();
        PersistentTasksCustomMetadata persistentTasksMetadata = (PersistentTasksCustomMetadata)metadata.custom("persistent_tasks");
        if (persistentTasksMetadata == null) {
            return;
        }
        for (final PersistentTasksCustomMetadata.PersistentTask persistentTask : persistentTasksMetadata.tasks()) {
            ShardFollowTask shardFollowTask;
            Index followerIndex;
            if (!"xpack/ccr/shard_follow_task".equals(persistentTask.getTaskName()) || metadata.index(followerIndex = (shardFollowTask = (ShardFollowTask)persistentTask.getParams()).getFollowShardId().getIndex()) != null) continue;
            IndexNotFoundException infe = new IndexNotFoundException(followerIndex);
            CompletionPersistentTaskAction.Request request = new CompletionPersistentTaskAction.Request(persistentTask.getId(), persistentTask.getAllocationId(), (Exception)infe, null);
            this.threadPool.generic().submit(() -> {
                assert (this.threadPool.getThreadContext().isSystemContext());
                this.client.execute((ActionType)CompletionPersistentTaskAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<PersistentTaskResponse>(){

                    public void onResponse(PersistentTaskResponse persistentTaskResponse) {
                        logger.debug("task [{}] cleaned up", (Object)persistentTask.getId());
                    }

                    public void onFailure(Exception e) {
                        logger.warn((Message)new ParameterizedMessage("failed to clean up task [{}]", (Object)persistentTask.getId()), (Throwable)e);
                    }
                });
            });
        }
    }
}

