/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.RequestValidators;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.ccr.CcrSettings;

public final class CcrRequests {
    public static final RequestValidators.RequestValidator<PutMappingRequest> CCR_PUT_MAPPING_REQUEST_VALIDATOR = (request, state, indices) -> {
        if (request.origin() == null) {
            return Optional.empty();
        }
        List followingIndices = Arrays.stream(indices).filter(index -> {
            IndexMetadata indexMetadata = state.metadata().index(index);
            return indexMetadata != null && (Boolean)CcrSettings.CCR_FOLLOWING_INDEX_SETTING.get(indexMetadata.getSettings()) != false;
        }).collect(Collectors.toList());
        if (!followingIndices.isEmpty() && !"ccr".equals(request.origin())) {
            String errorMessage = "can't put mapping to the following indices [" + followingIndices.stream().map(Index::getName).collect(Collectors.joining(", ")) + "]; the mapping of the following indices are self-replicated from its leader indices";
            return Optional.of(new ElasticsearchStatusException(errorMessage, RestStatus.FORBIDDEN, new Object[0]));
        }
        return Optional.empty();
    };
    public static final RequestValidators.RequestValidator<IndicesAliasesRequest> CCR_INDICES_ALIASES_REQUEST_VALIDATOR = (request, state, indices) -> {
        if (request.origin() == null) {
            return Optional.empty();
        }
        List followingIndices = Arrays.stream(indices).filter(index -> {
            IndexMetadata indexMetadata = state.metadata().index(index);
            return indexMetadata != null && (Boolean)CcrSettings.CCR_FOLLOWING_INDEX_SETTING.get(indexMetadata.getSettings()) != false;
        }).collect(Collectors.toList());
        if (!followingIndices.isEmpty() && !"ccr".equals(request.origin())) {
            String errorMessage = "can't modify aliases on indices [" + followingIndices.stream().map(Index::getName).collect(Collectors.joining(", ")) + "]; aliases of following indices are self-replicated from their leader indices";
            return Optional.of(new ElasticsearchStatusException(errorMessage, RestStatus.FORBIDDEN, new Object[0]));
        }
        return Optional.empty();
    };

    private CcrRequests() {
    }

    public static ClusterStateRequest metadataRequest(String leaderIndex) {
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear();
        clusterStateRequest.metadata(true);
        clusterStateRequest.indices(new String[]{leaderIndex});
        return clusterStateRequest;
    }

    public static PutMappingRequest putMappingRequest(String followerIndex, MappingMetadata mappingMetadata) {
        PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{followerIndex});
        putMappingRequest.origin("ccr");
        putMappingRequest.source(mappingMetadata.source().string(), XContentType.JSON);
        putMappingRequest.masterNodeTimeout(TimeValue.MAX_VALUE);
        return putMappingRequest;
    }

    public static void getIndexMetadata(Client client, Index index, long mappingVersion, long metadataVersion, Supplier<TimeValue> timeoutSupplier, ActionListener<IndexMetadata> listener) {
        ClusterStateRequest request = CcrRequests.metadataRequest(index.getName());
        if (metadataVersion > 0L) {
            request.waitForMetadataVersion(metadataVersion).waitForTimeout(timeoutSupplier.get());
        }
        client.admin().cluster().state(request, ActionListener.wrap(response -> {
            if (response.getState() == null) {
                assert (metadataVersion > 0L) : metadataVersion;
                if (((TimeValue)timeoutSupplier.get()).nanos() < 0L) {
                    listener.onFailure((Exception)new IllegalStateException("timeout to get cluster state with metadata version [" + metadataVersion + "], mapping version [" + mappingVersion + "]"));
                } else {
                    CcrRequests.getIndexMetadata(client, index, mappingVersion, metadataVersion, timeoutSupplier, listener);
                }
            } else {
                Metadata metadata = response.getState().metadata();
                IndexMetadata indexMetadata = metadata.getIndexSafe(index);
                if (indexMetadata.getMappingVersion() >= mappingVersion) {
                    listener.onResponse((Object)indexMetadata);
                    return;
                }
                if (((TimeValue)timeoutSupplier.get()).nanos() < 0L) {
                    listener.onFailure((Exception)new IllegalStateException("timeout to get cluster state with mapping version [" + mappingVersion + "]"));
                } else {
                    CcrRequests.getIndexMetadata(client, index, mappingVersion, metadata.version() + 1L, timeoutSupplier, listener);
                }
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

