/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.cache.blob;

import java.io.IOException;
import java.time.Instant;
import java.util.Base64;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class CachedBlob
implements ToXContent {
    public static final CachedBlob CACHE_NOT_READY = new CachedBlob(null, null, null, "CACHE_NOT_READY", null, (BytesReference)BytesArray.EMPTY, 0L, 0L);
    public static final CachedBlob CACHE_MISS = new CachedBlob(null, null, null, "CACHE_MISS", null, (BytesReference)BytesArray.EMPTY, 0L, 0L);
    private static final String TYPE = "blob";
    public static final String CREATION_TIME_FIELD = "creation_time";
    private final Instant creationTime;
    private final Version version;
    private final String repository;
    private final String name;
    private final String path;
    private final BytesReference bytes;
    private final long from;
    private final long to;

    public CachedBlob(Instant creationTime, Version version, String repository, String name, String path, BytesReference content, long offset) {
        this(creationTime, version, repository, name, path, content, offset, offset + (long)(content == null ? 0 : content.length()));
    }

    private CachedBlob(Instant creationTime, Version version, String repository, String name, String path, BytesReference content, long from, long to) {
        this.creationTime = creationTime;
        this.version = version;
        this.repository = repository;
        this.name = name;
        this.path = path;
        this.bytes = content;
        this.from = from;
        this.to = to;
        assert (this.to == this.from + (long)this.bytes.length());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", TYPE);
        builder.field(CREATION_TIME_FIELD, this.creationTime.toEpochMilli());
        builder.field("version", this.version.id);
        builder.field("repository", this.repository);
        builder.startObject(TYPE);
        builder.field("name", this.name);
        builder.field("path", this.path);
        builder.endObject();
        builder.startObject("data");
        builder.field("content", BytesReference.toBytes((BytesReference)this.bytes));
        builder.field("length", this.bytes.length());
        builder.field("from", this.from);
        builder.field("to", this.to);
        builder.endObject();
        return builder.endObject();
    }

    public long from() {
        return this.from;
    }

    public long to() {
        return this.to;
    }

    public int length() {
        return this.bytes.length();
    }

    public BytesReference bytes() {
        return this.bytes;
    }

    public Version version() {
        return this.version;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public static CachedBlob fromSource(Map<String, Object> source) {
        Long creationTimeEpochMillis = (Long)source.get(CREATION_TIME_FIELD);
        if (creationTimeEpochMillis == null) {
            throw new IllegalStateException("cached blob document does not have the [creation_time] field");
        }
        Version version = Version.fromId((int)((Integer)source.get("version")));
        if (version == null) {
            throw new IllegalStateException("cached blob document does not have the [version] field");
        }
        String repository = (String)source.get("repository");
        if (repository == null) {
            throw new IllegalStateException("cached blob document does not have the [repository] field");
        }
        Map blob = (Map)source.get(TYPE);
        if (blob == null || blob.isEmpty()) {
            throw new IllegalStateException("cached blob document does not have the [blob] object");
        }
        String name = (String)blob.get("name");
        if (name == null) {
            throw new IllegalStateException("cached blob document does not have the [blob.name] field");
        }
        String path = (String)blob.get("path");
        if (path == null) {
            throw new IllegalStateException("cached blob document does not have the [blob.path] field");
        }
        Map data = (Map)source.get("data");
        if (data == null || data.isEmpty()) {
            throw new IllegalStateException("cached blob document does not have the [data] fobjectield");
        }
        String encodedContent = (String)data.get("content");
        if (encodedContent == null) {
            throw new IllegalStateException("cached blob document does not have the [data.content] field");
        }
        Integer length = (Integer)data.get("length");
        if (length == null) {
            throw new IllegalStateException("cached blob document does not have the [data.length] field");
        }
        byte[] content = Base64.getDecoder().decode(encodedContent);
        if (content.length != length) {
            throw new IllegalStateException("cached blob document content length does not match [data.length] field");
        }
        Number from = (Number)data.get("from");
        if (from == null) {
            throw new IllegalStateException("cached blob document does not have the [data.from] field");
        }
        Number to = (Number)data.get("to");
        if (to == null) {
            throw new IllegalStateException("cached blob document does not have the [data.to] field");
        }
        return new CachedBlob(Instant.ofEpochMilli(creationTimeEpochMillis), version, repository, name, path, (BytesReference)new BytesArray(content), from.longValue(), to.longValue());
    }

    public String toString() {
        return "CachedBlob [creationTime=" + this.creationTime + ", version=" + this.version + ", repository='" + this.repository + "', name='" + this.name + "', path='" + this.path + "', from=" + this.from + ", to=" + this.to + "]";
    }
}

