/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.allocation;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;
import org.elasticsearch.xpack.searchablesnapshots.cache.full.CacheService;
import org.elasticsearch.xpack.searchablesnapshots.cache.shared.FrozenCacheService;
import org.elasticsearch.xpack.searchablesnapshots.store.SearchableSnapshotDirectory;

public class SearchableSnapshotIndexEventListener
implements IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SearchableSnapshotIndexEventListener.class);
    @Nullable
    private final CacheService cacheService;
    @Nullable
    private final FrozenCacheService frozenCacheService;

    public SearchableSnapshotIndexEventListener(Settings settings, @Nullable CacheService cacheService, @Nullable FrozenCacheService frozenCacheService) {
        assert (cacheService != null || !DiscoveryNode.canContainData((Settings)settings));
        this.cacheService = cacheService;
        this.frozenCacheService = frozenCacheService;
    }

    public void beforeIndexShardRecovery(IndexShard indexShard, IndexSettings indexSettings) {
        assert (Thread.currentThread().getName().contains("generic"));
        SearchableSnapshotIndexEventListener.ensureSnapshotIsLoaded(indexShard);
    }

    private static void ensureSnapshotIsLoaded(IndexShard indexShard) {
        SearchableSnapshotDirectory directory = SearchableSnapshotDirectory.unwrapDirectory(indexShard.store().directory());
        assert (directory != null);
        StepListener preWarmListener = new StepListener();
        boolean success = directory.loadSnapshot(indexShard.recoveryState(), (ActionListener<Void>)preWarmListener);
        ShardRouting shardRouting = indexShard.routingEntry();
        if (success && shardRouting.isRelocationTarget()) {
            Runnable preWarmCondition = indexShard.addCleanFilesDependency();
            preWarmListener.whenComplete(v -> preWarmCondition.run(), e -> {
                logger.warn((Message)new ParameterizedMessage("pre-warm operation failed for [{}] while it was the target of primary relocation [{}]", (Object)shardRouting.shardId(), (Object)shardRouting), (Throwable)e);
                preWarmCondition.run();
            });
        }
        assert (directory.listAll().length > 0) : "expecting directory listing to be non-empty";
        assert (success || indexShard.routingEntry().recoverySource().getType() == RecoverySource.Type.PEER) : "loading snapshot must not be called twice unless we are retrying a peer recovery";
    }

    public void beforeIndexRemoved(IndexService indexService, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        if (SearchableSnapshotIndexEventListener.shouldEvictCacheFiles(reason) && indexService.getMetadata().isSearchableSnapshot()) {
            IndexSettings indexSettings = indexService.getIndexSettings();
            for (IndexShard indexShard : indexService) {
                ShardId shardId = indexShard.shardId();
                logger.debug("{} marking shard as evicted in searchable snapshots cache (reason: {})", (Object)shardId, (Object)reason);
                if (this.cacheService != null) {
                    this.cacheService.markShardAsEvictedInCache((String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSettings.getSettings()), (String)SearchableSnapshots.SNAPSHOT_INDEX_NAME_SETTING.get(indexSettings.getSettings()), shardId);
                }
                if (this.frozenCacheService == null) continue;
                this.frozenCacheService.markShardAsEvictedInCache((String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSettings.getSettings()), (String)SearchableSnapshots.SNAPSHOT_INDEX_NAME_SETTING.get(indexSettings.getSettings()), shardId);
            }
        }
    }

    private static boolean shouldEvictCacheFiles(IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        return reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.DELETED || reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED || reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.FAILURE;
    }
}

